/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.wsdl.parser.message;

import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.value.FullyQualifiedName;
import in.specmatic.core.value.StringValue;
import in.specmatic.core.value.XMLNode;
import in.specmatic.core.value.XMLNodeKt;
import in.specmatic.core.value.XMLValue;
import in.specmatic.core.wsdl.parser.WSDL;
import in.specmatic.core.wsdl.parser.message.ParseMessageWithElementRefKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a6\u0010\u0000\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0006\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"createSimpleType", "Lkotlin/Pair;", "", "Lin/specmatic/core/value/XMLValue;", "", "element", "Lin/specmatic/core/value/XMLNode;", "wsdl", "Lin/specmatic/core/wsdl/parser/WSDL;", "actualElement", "fromRestriction", "fromTypeAttribute", "simpleTypeName", "core"})
public final class SimpleElementKt {
    @NotNull
    public static final Pair<List<XMLValue>, String> createSimpleType(@NotNull XMLNode element, @NotNull WSDL wsdl, @Nullable XMLNode actualElement) {
        CharSequence charSequence;
        StringValue stringValue;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)wsdl, (String)"wsdl");
        String typeName2 = SimpleElementKt.simpleTypeName(element);
        if (ParseMessageWithElementRefKt.getPrimitiveStringTypes().contains(typeName2)) {
            stringValue = new StringValue("(string)");
        } else if (ParseMessageWithElementRefKt.getPrimitiveNumberTypes().contains(typeName2)) {
            stringValue = new StringValue("(number)");
        } else if (ParseMessageWithElementRefKt.getPrimitiveDateTypes().contains(typeName2)) {
            stringValue = new StringValue("(datetime)");
        } else if (ParseMessageWithElementRefKt.getPrimitiveBooleanType().contains(typeName2)) {
            stringValue = new StringValue("(boolean)");
        } else if (Intrinsics.areEqual((Object)typeName2, (Object)"anyType")) {
            stringValue = new StringValue("(anything)");
        } else {
            throw new ContractException("Primitive type \"" + typeName2 + "\" not recognized", null, null, null, false, 30, null);
        }
        StringValue value2 = stringValue;
        XMLNode xMLNode = actualElement;
        if (xMLNode == null) {
            xMLNode = element;
        }
        XMLNode resolvedElement = xMLNode;
        Map<String, StringValue> qontractAttributes = ParseMessageWithElementRefKt.deriveSpecmaticAttributes(resolvedElement);
        FullyQualifiedName fqname = resolvedElement.fullyQualifiedName(wsdl);
        CharSequence charSequence2 = fqname.getPrefix();
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        String prefix2 = (String)charSequence;
        return new Pair((Object)CollectionsKt.listOf((Object)new XMLNode(fqname.getQname(), qontractAttributes, CollectionsKt.listOf((Object)value2), null, 8, null)), (Object)prefix2);
    }

    public static /* synthetic */ Pair createSimpleType$default(XMLNode xMLNode, WSDL wSDL, XMLNode xMLNode2, int n, Object object) {
        if ((n & 4) != 0) {
            xMLNode2 = null;
        }
        return SimpleElementKt.createSimpleType(xMLNode, wSDL, xMLNode2);
    }

    @NotNull
    public static final String simpleTypeName(@NotNull XMLNode element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = SimpleElementKt.fromTypeAttribute(element);
        if (string == null && (string = SimpleElementKt.fromRestriction(element)) == null) {
            throw new ContractException("Could not find type for node " + element.displayableValue(), null, null, null, false, 30, null);
        }
        return string;
    }

    @Nullable
    public static final String fromRestriction(@NotNull XMLNode element) {
        String string;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Iterable iterable = element.getChildNodes();
            for (Object t : iterable) {
                XMLValue it = (XMLValue)t;
                boolean bl = false;
                if (!(it instanceof XMLNode && Intrinsics.areEqual((Object)((XMLNode)it).getName(), (Object)"restriction"))) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        XMLValue xMLValue = v0;
        if (xMLValue != null) {
            XMLValue it = xMLValue;
            boolean bl = false;
            XMLNode cfr_ignored_0 = (XMLNode)it;
            string = XMLNodeKt.localName(XMLNode.getAttributeValue$default((XMLNode)it, "base", null, 2, null));
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final String fromTypeAttribute(@NotNull XMLNode element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        StringValue stringValue = element.getAttributes().get("type");
        if (stringValue != null) {
            StringValue it = stringValue;
            boolean bl = false;
            string = XMLNodeKt.localName(it.toStringLiteral());
        } else {
            string = null;
        }
        return string;
    }
}

