/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.stub;

import in.specmatic.core.HttpRequest;
import in.specmatic.core.HttpRequestPattern;
import in.specmatic.core.HttpResponse;
import in.specmatic.core.HttpResponsePattern;
import in.specmatic.core.Resolver;
import in.specmatic.core.Result;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.utilities.JSONSerialisationKt;
import in.specmatic.core.value.Value;
import in.specmatic.stub.ContractExternalResponseMismatch;
import in.specmatic.stub.HttpStubKt;
import in.specmatic.stub.StubData;
import in.specmatic.stub.StubDataKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J\u0010\u0010%\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0015J\t\u0010&\u001a\u00020\u000bH\u00c6\u0003J\t\u0010'\u001a\u00020\rH\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003Jd\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00c6\u0001\u00a2\u0006\u0002\u0010+J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u00d6\u0003J\t\u00100\u001a\u00020\tH\u00d6\u0001J\u0010\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u000203H\u0002J\u000e\u00104\u001a\u00020\u00002\u0006\u00102\u001a\u000203J\t\u00105\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0013\u00a8\u00066"}, d2={"Lin/specmatic/stub/HttpStubData;", "Lin/specmatic/stub/StubData;", "requestType", "Lin/specmatic/core/HttpRequestPattern;", "response", "Lin/specmatic/core/HttpResponse;", "resolver", "Lin/specmatic/core/Resolver;", "delayInSeconds", "", "responsePattern", "Lin/specmatic/core/HttpResponsePattern;", "contractPath", "", "stubToken", "requestBodyRegex", "Lkotlin/text/Regex;", "(Lin/specmatic/core/HttpRequestPattern;Lin/specmatic/core/HttpResponse;Lin/specmatic/core/Resolver;Ljava/lang/Integer;Lin/specmatic/core/HttpResponsePattern;Ljava/lang/String;Ljava/lang/String;Lkotlin/text/Regex;)V", "getContractPath", "()Ljava/lang/String;", "getDelayInSeconds", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getRequestBodyRegex", "()Lkotlin/text/Regex;", "getRequestType", "()Lin/specmatic/core/HttpRequestPattern;", "getResolver", "()Lin/specmatic/core/Resolver;", "getResponse", "()Lin/specmatic/core/HttpResponse;", "getResponsePattern", "()Lin/specmatic/core/HttpResponsePattern;", "getStubToken", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "(Lin/specmatic/core/HttpRequestPattern;Lin/specmatic/core/HttpResponse;Lin/specmatic/core/Resolver;Ljava/lang/Integer;Lin/specmatic/core/HttpResponsePattern;Ljava/lang/String;Ljava/lang/String;Lkotlin/text/Regex;)Lin/specmatic/stub/HttpStubData;", "equals", "", "other", "", "hashCode", "invokeExternalCommand", "httpRequest", "Lin/specmatic/core/HttpRequest;", "softCastResponseToXML", "toString", "core"})
public final class HttpStubData
implements StubData {
    @NotNull
    private final HttpRequestPattern requestType;
    @NotNull
    private final HttpResponse response;
    @NotNull
    private final Resolver resolver;
    @Nullable
    private final Integer delayInSeconds;
    @NotNull
    private final HttpResponsePattern responsePattern;
    @NotNull
    private final String contractPath;
    @Nullable
    private final String stubToken;
    @Nullable
    private final Regex requestBodyRegex;

    public HttpStubData(@NotNull HttpRequestPattern requestType, @NotNull HttpResponse response, @NotNull Resolver resolver, @Nullable Integer delayInSeconds, @NotNull HttpResponsePattern responsePattern, @NotNull String contractPath, @Nullable String stubToken, @Nullable Regex requestBodyRegex) {
        Intrinsics.checkNotNullParameter((Object)requestType, (String)"requestType");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)responsePattern, (String)"responsePattern");
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        this.requestType = requestType;
        this.response = response;
        this.resolver = resolver;
        this.delayInSeconds = delayInSeconds;
        this.responsePattern = responsePattern;
        this.contractPath = contractPath;
        this.stubToken = stubToken;
        this.requestBodyRegex = requestBodyRegex;
    }

    public /* synthetic */ HttpStubData(HttpRequestPattern httpRequestPattern, HttpResponse httpResponse, Resolver resolver, Integer n, HttpResponsePattern httpResponsePattern, String string, String string2, Regex regex, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        if ((n2 & 0x20) != 0) {
            string = "";
        }
        if ((n2 & 0x40) != 0) {
            string2 = null;
        }
        if ((n2 & 0x80) != 0) {
            regex = null;
        }
        this(httpRequestPattern, httpResponse, resolver, n, httpResponsePattern, string, string2, regex);
    }

    @NotNull
    public final HttpRequestPattern getRequestType() {
        return this.requestType;
    }

    @NotNull
    public final HttpResponse getResponse() {
        return this.response;
    }

    @NotNull
    public final Resolver getResolver() {
        return this.resolver;
    }

    @Nullable
    public final Integer getDelayInSeconds() {
        return this.delayInSeconds;
    }

    @NotNull
    public final HttpResponsePattern getResponsePattern() {
        return this.responsePattern;
    }

    @NotNull
    public final String getContractPath() {
        return this.contractPath;
    }

    @Nullable
    public final String getStubToken() {
        return this.stubToken;
    }

    @Nullable
    public final Regex getRequestBodyRegex() {
        return this.requestBodyRegex;
    }

    @NotNull
    public final HttpStubData softCastResponseToXML(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        return ((CharSequence)this.response.getExternalisedResponseCommand()).length() > 0 ? HttpStubData.copy$default(this.invokeExternalCommand(httpRequest), null, null, null, null, null, this.contractPath, null, null, 223, null) : HttpStubData.copy$default(this, null, HttpResponse.copy$default(this.response, 0, null, HttpStubKt.softCastValueToXML(this.response.getBody()), null, 11, null), null, null, null, null, null, null, 253, null);
    }

    private final HttpStubData invokeExternalCommand(HttpRequest httpRequest) {
        String result2 = StubDataKt.executeExternalCommand(this.response.getExternalisedResponseCommand(), "SPECMATIC_REQUEST='" + httpRequest.toJSON().toUnformattedStringLiteral() + '\'');
        Map<String, Value> responseMap = JSONSerialisationKt.jsonStringToValueMap(result2);
        HttpResponse externalCommandResponse = HttpResponse.Companion.fromJSON(responseMap);
        Result responseMatches = this.responsePattern.matches(externalCommandResponse, Resolver.copy$default(this.resolver, null, false, null, null, null, ContractExternalResponseMismatch.INSTANCE, false, null, null, false, null, 2015, null));
        if (!responseMatches.isSuccess()) {
            String errorMessage = "Response returned by " + this.response.getExternalisedResponseCommand() + " not in line with specification for " + httpRequest.getMethod() + ' ' + httpRequest.getPath() + ":\\n" + responseMatches.reportString();
            LoggingKt.getLogger().log(errorMessage);
            throw new ContractException(errorMessage, null, null, null, false, 30, null);
        }
        return HttpStubData.copy$default(this, null, externalCommandResponse, null, null, null, null, null, null, 253, null);
    }

    @NotNull
    public final HttpRequestPattern component1() {
        return this.requestType;
    }

    @NotNull
    public final HttpResponse component2() {
        return this.response;
    }

    @NotNull
    public final Resolver component3() {
        return this.resolver;
    }

    @Nullable
    public final Integer component4() {
        return this.delayInSeconds;
    }

    @NotNull
    public final HttpResponsePattern component5() {
        return this.responsePattern;
    }

    @NotNull
    public final String component6() {
        return this.contractPath;
    }

    @Nullable
    public final String component7() {
        return this.stubToken;
    }

    @Nullable
    public final Regex component8() {
        return this.requestBodyRegex;
    }

    @NotNull
    public final HttpStubData copy(@NotNull HttpRequestPattern requestType, @NotNull HttpResponse response, @NotNull Resolver resolver, @Nullable Integer delayInSeconds, @NotNull HttpResponsePattern responsePattern, @NotNull String contractPath, @Nullable String stubToken, @Nullable Regex requestBodyRegex) {
        Intrinsics.checkNotNullParameter((Object)requestType, (String)"requestType");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)responsePattern, (String)"responsePattern");
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        return new HttpStubData(requestType, response, resolver, delayInSeconds, responsePattern, contractPath, stubToken, requestBodyRegex);
    }

    public static /* synthetic */ HttpStubData copy$default(HttpStubData httpStubData, HttpRequestPattern httpRequestPattern, HttpResponse httpResponse, Resolver resolver, Integer n, HttpResponsePattern httpResponsePattern, String string, String string2, Regex regex, int n2, Object object) {
        if ((n2 & 1) != 0) {
            httpRequestPattern = httpStubData.requestType;
        }
        if ((n2 & 2) != 0) {
            httpResponse = httpStubData.response;
        }
        if ((n2 & 4) != 0) {
            resolver = httpStubData.resolver;
        }
        if ((n2 & 8) != 0) {
            n = httpStubData.delayInSeconds;
        }
        if ((n2 & 0x10) != 0) {
            httpResponsePattern = httpStubData.responsePattern;
        }
        if ((n2 & 0x20) != 0) {
            string = httpStubData.contractPath;
        }
        if ((n2 & 0x40) != 0) {
            string2 = httpStubData.stubToken;
        }
        if ((n2 & 0x80) != 0) {
            regex = httpStubData.requestBodyRegex;
        }
        return httpStubData.copy(httpRequestPattern, httpResponse, resolver, n, httpResponsePattern, string, string2, regex);
    }

    @NotNull
    public String toString() {
        return "HttpStubData(requestType=" + this.requestType + ", response=" + this.response + ", resolver=" + this.resolver + ", delayInSeconds=" + this.delayInSeconds + ", responsePattern=" + this.responsePattern + ", contractPath=" + this.contractPath + ", stubToken=" + this.stubToken + ", requestBodyRegex=" + this.requestBodyRegex + ')';
    }

    public int hashCode() {
        int result2 = this.requestType.hashCode();
        result2 = result2 * 31 + this.response.hashCode();
        result2 = result2 * 31 + this.resolver.hashCode();
        result2 = result2 * 31 + (this.delayInSeconds == null ? 0 : ((Object)this.delayInSeconds).hashCode());
        result2 = result2 * 31 + this.responsePattern.hashCode();
        result2 = result2 * 31 + this.contractPath.hashCode();
        result2 = result2 * 31 + (this.stubToken == null ? 0 : this.stubToken.hashCode());
        result2 = result2 * 31 + (this.requestBodyRegex == null ? 0 : this.requestBodyRegex.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpStubData)) {
            return false;
        }
        HttpStubData httpStubData = (HttpStubData)other;
        if (!Intrinsics.areEqual((Object)this.requestType, (Object)httpStubData.requestType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.response, (Object)httpStubData.response)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.resolver, (Object)httpStubData.resolver)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.delayInSeconds, (Object)httpStubData.delayInSeconds)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.responsePattern, (Object)httpStubData.responsePattern)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contractPath, (Object)httpStubData.contractPath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stubToken, (Object)httpStubData.stubToken)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.requestBodyRegex, (Object)httpStubData.requestBodyRegex);
    }
}

