/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.test;

import in.specmatic.core.Result;
import in.specmatic.core.Scenario;
import in.specmatic.core.ScenarioKt;
import in.specmatic.core.pattern.KafkaMessagePattern;
import in.specmatic.stub.API;
import in.specmatic.test.ContractTest;
import in.specmatic.test.HttpClient;
import in.specmatic.test.TestResultRecord;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J4\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J6\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0015H\u0016J\b\u0010\u0017\u001a\u00020\fH\u0002J(\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u001a\u0010\u001a\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001c\u001a\u00020\u0010H\u0016J$\u0010\u001a\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u001d\u001a\u00020\fH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006!"}, d2={"Lin/specmatic/test/ScenarioTest;", "Lin/specmatic/test/ContractTest;", "scenario", "Lin/specmatic/core/Scenario;", "generativeTestingEnabled", "", "(Lin/specmatic/core/Scenario;Z)V", "getScenario", "()Lin/specmatic/core/Scenario;", "executeTest", "Lin/specmatic/core/Result;", "protocol", "", "host", "port", "timeout", "", "testScenario", "generateTestScenarios", "", "testVariables", "", "testBaseURLs", "getBootstrapKafkaServers", "runHttpTest", "runKafkaTest", "runTest", "testBaseURL", "timeOut", "testDescription", "testResultRecord", "Lin/specmatic/test/TestResultRecord;", "result", "core"})
public final class ScenarioTest
implements ContractTest {
    @NotNull
    private final Scenario scenario;
    private final boolean generativeTestingEnabled;

    public ScenarioTest(@NotNull Scenario scenario, boolean generativeTestingEnabled) {
        Intrinsics.checkNotNullParameter((Object)scenario, (String)"scenario");
        this.scenario = scenario;
        this.generativeTestingEnabled = generativeTestingEnabled;
    }

    public /* synthetic */ ScenarioTest(Scenario scenario, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(scenario, bl);
    }

    @NotNull
    public final Scenario getScenario() {
        return this.scenario;
    }

    @Override
    @NotNull
    public TestResultRecord testResultRecord(@NotNull Result result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        CharSequence charSequence = this.scenario.getPath();
        Regex regex = new Regex("\\((.*):.*\\)");
        String string = "{$1}";
        return new TestResultRecord(regex.replace(charSequence, string), this.scenario.getMethod(), this.scenario.getStatus(), result2.testResult());
    }

    @Override
    @NotNull
    public List<ContractTest> generateTestScenarios(@NotNull Map<String, String> testVariables, @NotNull Map<String, String> testBaseURLs) {
        Intrinsics.checkNotNullParameter(testVariables, (String)"testVariables");
        Intrinsics.checkNotNullParameter(testBaseURLs, (String)"testBaseURLs");
        return this.scenario.generateContractTests(testVariables, testBaseURLs, this.generativeTestingEnabled);
    }

    @Override
    @NotNull
    public String testDescription() {
        return this.scenario.testDescription();
    }

    @Override
    @NotNull
    public Result runTest(@Nullable String host, @Nullable String port, int timeout) {
        Result result2;
        KafkaMessagePattern kafkaMessagePattern = this.scenario.getKafkaMessagePattern();
        if (kafkaMessagePattern != null) {
            result2 = this.runKafkaTest(this.scenario);
        } else {
            String string = host;
            Intrinsics.checkNotNull((Object)string);
            String string2 = port;
            Intrinsics.checkNotNull((Object)string2);
            result2 = this.runHttpTest(timeout, string, string2, this.scenario);
        }
        return result2;
    }

    @Override
    @NotNull
    public Result runTest(@Nullable String testBaseURL, int timeOut) {
        Result result2;
        KafkaMessagePattern kafkaMessagePattern = this.scenario.getKafkaMessagePattern();
        if (kafkaMessagePattern != null) {
            result2 = this.runKafkaTest(this.scenario);
        } else {
            String string = testBaseURL;
            Intrinsics.checkNotNull((Object)string);
            HttpClient httpClient = new HttpClient(string, timeOut, null, null, 12, null);
            result2 = ScenarioKt.executeTest(this.scenario, httpClient).updateScenario(this.scenario);
        }
        return result2;
    }

    private final Result runKafkaTest(Scenario testScenario) {
        if (System.getProperty("kafkaPort") == null) {
            System.out.println((Object)"The contract has a kafka message. Please specify the port of the Kafka instance to connect to.");
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        boolean commit = Intrinsics.areEqual((Object)"true", (Object)System.getProperty("commit"));
        return API.testKafkaMessages(testScenario, this.getBootstrapKafkaServers(), commit);
    }

    private final Result runHttpTest(int timeout, String host, String port, Scenario testScenario) {
        String string = System.getProperty("protocol");
        if (string == null) {
            string = "http";
        }
        String protocol = string;
        return this.executeTest(protocol, host, port, timeout, testScenario).updateScenario(this.scenario);
    }

    private final Result executeTest(String protocol, String host, String port, int timeout, Scenario testScenario) {
        HttpClient httpClient = new HttpClient(protocol + "://" + host + ':' + port, timeout, null, null, 12, null);
        return ScenarioKt.executeTest(testScenario, httpClient);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String getBootstrapKafkaServers() {
        String string;
        if (System.getProperty("kafkaBootstrapServers") != null) {
            String string2 = System.getProperty("kafkaBootstrapServers");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(\"kafkaBootstrapServers\")");
            if (((CharSequence)string2).length() > 0) {
                String string3 = System.getProperty("kafkaBootstrapServers");
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(\"kafkaBootstrapServers\")");
                return string;
            }
        }
        String string4 = System.getProperty("kafkaPort");
        int kafkaPort = string4 != null ? Integer.parseInt(string4) : 9093;
        String string5 = System.getProperty("kafkaHost");
        if (string5 == null) {
            string5 = "localhost";
        }
        String kafkaHost = string5;
        string = "PLAINTEXT://" + kafkaHost + ':' + kafkaPort;
        return string;
    }
}

