/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.conversions;

import in.specmatic.conversions.OpenAPISecurityScheme;
import in.specmatic.conversions.OpenAPISecuritySchemeKt;
import in.specmatic.core.HttpRequest;
import in.specmatic.core.HttpRequestPattern;
import in.specmatic.core.Resolver;
import in.specmatic.core.Result;
import in.specmatic.core.pattern.Row;
import in.specmatic.core.pattern.StringPattern;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\u0005\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0003H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lin/specmatic/conversions/BearerSecurityScheme;", "Lin/specmatic/conversions/OpenAPISecurityScheme;", "token", "", "(Ljava/lang/String;)V", "addTo", "Lin/specmatic/core/HttpRequest;", "httpRequest", "Lin/specmatic/core/HttpRequestPattern;", "requestPattern", "row", "Lin/specmatic/core/pattern/Row;", "getAuthorizationHeaderValue", "isInRow", "", "matches", "Lin/specmatic/core/Result;", "removeParam", "core"})
public final class BearerSecurityScheme
implements OpenAPISecurityScheme {
    @Nullable
    private final String token;

    public BearerSecurityScheme(@Nullable String token) {
        this.token = token;
    }

    public /* synthetic */ BearerSecurityScheme(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    @Override
    @NotNull
    public Result matches(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        Map<String, String> it = httpRequest.getHeaders();
        boolean bl = false;
        String string = it.get("Authorization");
        if (string == null) {
            return new Result.Failure("Authorization header is missing in request", null, null, null, 14, null);
        }
        String authHeaderValue = string;
        String string2 = authHeaderValue.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (!StringsKt.startsWith$default((String)string2, (String)"bearer", (boolean)false, (int)2, null)) {
            return new Result.Failure("Authorization header must be prefixed with \"Bearer\"", null, null, null, 14, null);
        }
        return new Result.Success(null, null, 3, null);
    }

    @Override
    @NotNull
    public HttpRequest removeParam(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        return HttpRequest.copy$default(httpRequest, null, null, MapsKt.minus(httpRequest.getHeaders(), (Object)"Authorization"), null, null, null, null, 123, null);
    }

    @Override
    @NotNull
    public HttpRequest addTo(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        return HttpRequest.copy$default(httpRequest, null, null, MapsKt.plus(httpRequest.getHeaders(), (Pair)TuplesKt.to((Object)"Authorization", (Object)this.getAuthorizationHeaderValue())), null, null, null, null, 123, null);
    }

    @Override
    @NotNull
    public HttpRequestPattern addTo(@NotNull HttpRequestPattern requestPattern, @NotNull Row row) {
        Intrinsics.checkNotNullParameter((Object)requestPattern, (String)"requestPattern");
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        return OpenAPISecuritySchemeKt.addToHeaderType("Authorization", row, requestPattern);
    }

    @Override
    public boolean isInRow(@NotNull Row row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        return row.containsField("Authorization");
    }

    private final String getAuthorizationHeaderValue() {
        StringBuilder stringBuilder = new StringBuilder().append("Bearer ");
        String string = this.token;
        if (string == null) {
            string = new StringPattern(null, null, null, null, 15, null).generate(new Resolver()).toStringLiteral();
        }
        return stringBuilder.append(string).toString();
    }

    public BearerSecurityScheme() {
        this(null, 1, null);
    }
}

