/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core;

import in.specmatic.core.ContractCache;
import in.specmatic.core.ContractFileWithExports;
import in.specmatic.core.pattern.ContractException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007H\u00c2\u0003J\t\u0010\u0016\u001a\u00020\nH\u00c2\u0003JS\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007H\u0002J\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007H\u0002J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\u000e\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lin/specmatic/core/References;", "", "valueName", "", "contractFile", "Lin/specmatic/core/ContractFileWithExports;", "baseURLs", "", "variables", "contractCache", "Lin/specmatic/core/ContractCache;", "(Ljava/lang/String;Lin/specmatic/core/ContractFileWithExports;Ljava/util/Map;Ljava/util/Map;Lin/specmatic/core/ContractCache;)V", "getBaseURLs", "()Ljava/util/Map;", "getContractFile", "()Lin/specmatic/core/ContractFileWithExports;", "getValueName", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "fetchAndCache", "fetchAndUpdateContractCache", "hashCode", "", "lookup", "key", "toString", "core"})
public final class References {
    @NotNull
    private final String valueName;
    @NotNull
    private final ContractFileWithExports contractFile;
    @NotNull
    private final Map<String, String> baseURLs;
    @NotNull
    private final Map<String, String> variables;
    @NotNull
    private final ContractCache contractCache;

    public References(@NotNull String valueName, @NotNull ContractFileWithExports contractFile, @NotNull Map<String, String> baseURLs, @NotNull Map<String, String> variables, @NotNull ContractCache contractCache) {
        Intrinsics.checkNotNullParameter((Object)valueName, (String)"valueName");
        Intrinsics.checkNotNullParameter((Object)contractFile, (String)"contractFile");
        Intrinsics.checkNotNullParameter(baseURLs, (String)"baseURLs");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)contractCache, (String)"contractCache");
        this.valueName = valueName;
        this.contractFile = contractFile;
        this.baseURLs = baseURLs;
        this.variables = variables;
        this.contractCache = contractCache;
    }

    public /* synthetic */ References(String string, ContractFileWithExports contractFileWithExports, Map map, Map map2, ContractCache contractCache, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(string, contractFileWithExports, map, map2, contractCache);
    }

    @NotNull
    public final String getValueName() {
        return this.valueName;
    }

    @NotNull
    public final ContractFileWithExports getContractFile() {
        return this.contractFile;
    }

    @NotNull
    public final Map<String, String> getBaseURLs() {
        return this.baseURLs;
    }

    @NotNull
    public final String lookup(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        String string = this.fetchAndCache().get(key2);
        if (string == null) {
            throw new ContractException("Key \"" + key2 + "\" not found in value named " + this.valueName, null, null, null, false, 30, null);
        }
        return string;
    }

    private final Map<String, String> fetchAndCache() {
        Map<String, String> map = this.contractCache.lookup(this.contractFile.getAbsolutePath());
        if (map == null) {
            map = this.fetchAndUpdateContractCache();
        }
        return map;
    }

    private final Map<String, String> fetchAndUpdateContractCache() {
        return this.contractCache.update(this.contractFile.getAbsolutePath(), (Function0<? extends Map<String, String>>)((Function0)new Function0<Map<String, ? extends String>>(this){
            final /* synthetic */ References this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<String, String> invoke() {
                return this.this$0.getContractFile().runContractAndExtractExports(this.this$0.getValueName(), this.this$0.getBaseURLs(), References.access$getVariables$p(this.this$0));
            }
        }));
    }

    @NotNull
    public final String component1() {
        return this.valueName;
    }

    @NotNull
    public final ContractFileWithExports component2() {
        return this.contractFile;
    }

    @NotNull
    public final Map<String, String> component3() {
        return this.baseURLs;
    }

    private final Map<String, String> component4() {
        return this.variables;
    }

    private final ContractCache component5() {
        return this.contractCache;
    }

    @NotNull
    public final References copy(@NotNull String valueName, @NotNull ContractFileWithExports contractFile, @NotNull Map<String, String> baseURLs, @NotNull Map<String, String> variables, @NotNull ContractCache contractCache) {
        Intrinsics.checkNotNullParameter((Object)valueName, (String)"valueName");
        Intrinsics.checkNotNullParameter((Object)contractFile, (String)"contractFile");
        Intrinsics.checkNotNullParameter(baseURLs, (String)"baseURLs");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)contractCache, (String)"contractCache");
        return new References(valueName, contractFile, baseURLs, variables, contractCache);
    }

    public static /* synthetic */ References copy$default(References references, String string, ContractFileWithExports contractFileWithExports, Map map, Map map2, ContractCache contractCache, int n, Object object) {
        if ((n & 1) != 0) {
            string = references.valueName;
        }
        if ((n & 2) != 0) {
            contractFileWithExports = references.contractFile;
        }
        if ((n & 4) != 0) {
            map = references.baseURLs;
        }
        if ((n & 8) != 0) {
            map2 = references.variables;
        }
        if ((n & 0x10) != 0) {
            contractCache = references.contractCache;
        }
        return references.copy(string, contractFileWithExports, map, map2, contractCache);
    }

    @NotNull
    public String toString() {
        return "References(valueName=" + this.valueName + ", contractFile=" + this.contractFile + ", baseURLs=" + this.baseURLs + ", variables=" + this.variables + ", contractCache=" + this.contractCache + ')';
    }

    public int hashCode() {
        int result2 = this.valueName.hashCode();
        result2 = result2 * 31 + this.contractFile.hashCode();
        result2 = result2 * 31 + ((Object)this.baseURLs).hashCode();
        result2 = result2 * 31 + ((Object)this.variables).hashCode();
        result2 = result2 * 31 + this.contractCache.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof References)) {
            return false;
        }
        References references = (References)other;
        if (!Intrinsics.areEqual((Object)this.valueName, (Object)references.valueName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contractFile, (Object)references.contractFile)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.baseURLs, references.baseURLs)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.variables, references.variables)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.contractCache, (Object)references.contractCache);
    }

    public static final /* synthetic */ Map access$getVariables$p(References $this) {
        return $this.variables;
    }
}

