/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.log;

import in.specmatic.core.log.CurrentDate;
import in.specmatic.core.log.LogDirectoryKt;
import in.specmatic.core.log.LogFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\u0002\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lin/specmatic/core/log/LogDirectory;", "Lin/specmatic/core/log/LogFile;", "directory", "", "prefix", "tag", "extension", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Ljava/io/File;", "(Ljava/io/File;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "file", "getFile", "()Ljava/io/File;", "appendText", "", "text", "core"})
public final class LogDirectory
implements LogFile {
    @NotNull
    private final File file;

    public LogDirectory(@NotNull File directory, @NotNull String prefix2, @NotNull String tag, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        CurrentDate currentDate = new CurrentDate(null, 1, null);
        String name = prefix2 + '-' + currentDate.toFileNameString() + LogDirectoryKt.logFileNameSuffix(tag, extension);
        this.file = FilesKt.resolve((File)directory, (String)name);
        if (!this.file.exists()) {
            this.file.createNewFile();
            System.out.println((Object)("Logging to file " + this.file.getCanonicalFile()));
        }
    }

    public LogDirectory(@NotNull String directory, @NotNull String prefix2, @NotNull String tag, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this(new File(directory), prefix2, tag, extension);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @Override
    public void appendText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        FilesKt.appendText$default((File)this.file, (String)text, null, (int)2, null);
    }
}

