/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.pattern;

import in.specmatic.core.Resolver;
import in.specmatic.core.Result;
import in.specmatic.core.ResultKt;
import in.specmatic.core.pattern.ConsumeResult;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.pattern.DictionaryPattern;
import in.specmatic.core.pattern.ExactValuePattern;
import in.specmatic.core.pattern.GrammarKt;
import in.specmatic.core.pattern.JSONArrayPatternKt;
import in.specmatic.core.pattern.PairOfTypes;
import in.specmatic.core.pattern.Pattern;
import in.specmatic.core.pattern.Row;
import in.specmatic.core.pattern.TypeStackKt;
import in.specmatic.core.value.JSONArrayValue;
import in.specmatic.core.value.JSONObjectValue;
import in.specmatic.core.value.StringValue;
import in.specmatic.core.value.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0012\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0001H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u00012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J2\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0010\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\u001e0\u001dj\u0002`\u001fH\u0016J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\nH\u00d6\u0003J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001aH\u0016J\t\u0010&\u001a\u00020'H\u00d6\u0001J\u001e\u0010(\u001a\u00020$2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020$0*2\u0006\u0010%\u001a\u00020\u001aH\u0016J\u001a\u0010+\u001a\u00020\u00172\b\u0010,\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u001aH\u0016J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00010*2\u0006\u0010.\u001a\u00020/2\u0006\u0010%\u001a\u00020\u001aH\u0016J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u00010*2\u0006\u0010%\u001a\u00020\u001aH\u0016J\u001e\u00100\u001a\b\u0012\u0004\u0012\u00020\u00010*2\u0006\u0010.\u001a\u00020/2\u0006\u0010%\u001a\u00020\u001aH\u0016J\u0018\u00101\u001a\u00020$2\u0006\u00102\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u001aH\u0016J\t\u00103\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\b\u00a8\u00064"}, d2={"Lin/specmatic/core/pattern/DictionaryPattern;", "Lin/specmatic/core/pattern/Pattern;", "keyPattern", "valuePattern", "typeAlias", "", "(Lin/specmatic/core/pattern/Pattern;Lin/specmatic/core/pattern/Pattern;Ljava/lang/String;)V", "getKeyPattern", "()Lin/specmatic/core/pattern/Pattern;", "pattern", "", "getPattern", "()Ljava/lang/Object;", "getTypeAlias", "()Ljava/lang/String;", "typeName", "getTypeName", "getValuePattern", "component1", "component2", "component3", "copy", "encompasses", "Lin/specmatic/core/Result;", "otherPattern", "thisResolver", "Lin/specmatic/core/Resolver;", "otherResolver", "typeStack", "", "Lin/specmatic/core/pattern/PairOfTypes;", "Lin/specmatic/core/pattern/TypeStack;", "equals", "", "other", "generate", "Lin/specmatic/core/value/Value;", "resolver", "hashCode", "", "listOf", "valueList", "", "matches", "sampleData", "negativeBasedOn", "row", "Lin/specmatic/core/pattern/Row;", "newBasedOn", "parse", "value", "toString", "core"})
@SourceDebugExtension(value={"SMAP\nDictionaryPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DictionaryPattern.kt\nin/specmatic/core/pattern/DictionaryPattern\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,100:1\n215#2,2:101\n1789#3,3:103\n1549#3:106\n1620#3,3:107\n1549#3:110\n1620#3,3:111\n179#4,2:114\n*S KotlinDebug\n*F\n+ 1 DictionaryPattern.kt\nin/specmatic/core/pattern/DictionaryPattern\n*L\n16#1:101,2\n46#1:103,3\n59#1:106\n59#1:107,3\n69#1:110\n69#1:111,3\n88#1:114,2\n*E\n"})
public final class DictionaryPattern
implements Pattern {
    @NotNull
    private final Pattern keyPattern;
    @NotNull
    private final Pattern valuePattern;
    @Nullable
    private final String typeAlias;
    @NotNull
    private final String typeName;
    @NotNull
    private final Object pattern;

    public DictionaryPattern(@NotNull Pattern keyPattern, @NotNull Pattern valuePattern, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter((Object)keyPattern, (String)"keyPattern");
        Intrinsics.checkNotNullParameter((Object)valuePattern, (String)"valuePattern");
        this.keyPattern = keyPattern;
        this.valuePattern = valuePattern;
        this.typeAlias = typeAlias;
        this.typeName = "object with key type " + this.keyPattern.getTypeName() + " and value type " + this.valuePattern.getTypeName();
        this.pattern = '(' + GrammarKt.withoutPatternDelimiters(this.keyPattern.getPattern().toString()) + ':' + GrammarKt.withoutPatternDelimiters(this.valuePattern.getPattern().toString()) + ')';
    }

    public /* synthetic */ DictionaryPattern(Pattern pattern2, Pattern pattern3, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(pattern2, pattern3, string);
    }

    @NotNull
    public final Pattern getKeyPattern() {
        return this.keyPattern;
    }

    @NotNull
    public final Pattern getValuePattern() {
        return this.valuePattern;
    }

    @Override
    @Nullable
    public String getTypeAlias() {
        return this.typeAlias;
    }

    @Override
    @NotNull
    public Result matches(@Nullable Value sampleData, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        if (!(sampleData instanceof JSONObjectValue)) {
            return ResultKt.mismatchResult("JSON object", sampleData, resolver.getMismatchMessages());
        }
        Map<String, Value> $this$forEach$iv = ((JSONObjectValue)sampleData).getJsonObject();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Value>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Result result2;
            Map.Entry<String, Value> element$iv;
            Map.Entry<String, Value> entry = element$iv = iterator.next();
            boolean bl = false;
            String key2 = entry.getKey();
            Value value2 = entry.getValue();
            try {
                Value parsedKey = this.keyPattern.parse(key2, resolver);
                result2 = resolver.matchesPattern(null, this.keyPattern, parsedKey);
                if (result2 instanceof Result.Failure) {
                    return ((Result.Failure)result2).breadCrumb(key2);
                }
            }
            catch (ContractException e) {
                return e.failure().breadCrumb(key2);
            }
            try {
                Value parsedValue = value2 instanceof StringValue ? this.valuePattern.parse(((StringValue)value2).getString(), resolver) : value2;
                result2 = resolver.matchesPattern(null, this.valuePattern, parsedValue);
                if (!(result2 instanceof Result.Failure)) continue;
                return ((Result.Failure)result2).breadCrumb(key2);
            }
            catch (ContractException e) {
                return e.failure().breadCrumb(key2);
            }
        }
        return new Result.Success(null, null, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Value generate(@NotNull Resolver resolver) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Iterable iterable = (Iterable)new IntRange(1, JSONArrayPatternKt.randomNumber(10));
        Map initial$iv = MapsKt.emptyMap();
        boolean $i$f$fold = false;
        Map accumulator$iv = initial$iv;
        Iterator iterator = $this$fold$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv = ((IntIterator)iterator).nextInt();
            Map obj = accumulator$iv;
            boolean bl = false;
            String key2 = ((Value)resolver.withCyclePrevention(this.keyPattern, (Function1)new Function1<Resolver, Value>((Object)this.keyPattern){

                @NotNull
                public final Value invoke(@NotNull Resolver p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((Pattern)this.receiver).generate(p0);
                }
            })).toStringLiteral();
            Value value2 = (Value)resolver.withCyclePrevention(this.valuePattern, (Function1)new Function1<Resolver, Value>((Object)this.valuePattern){

                @NotNull
                public final Value invoke(@NotNull Resolver p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((Pattern)this.receiver).generate(p0);
                }
            });
            accumulator$iv = MapsKt.plus((Map)obj, (Pair)TuplesKt.to((Object)key2, (Object)value2));
        }
        Map map = accumulator$iv;
        return new JSONObjectValue(map);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pattern> newBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        List newValuePatterns2 = (List)resolver.withCyclePrevention(this.valuePattern, (Function1)new Function1<Resolver, List<? extends Pattern>>(this){
            final /* synthetic */ DictionaryPattern this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<Pattern> invoke(@NotNull Resolver cyclePreventedResolver) {
                Intrinsics.checkNotNullParameter((Object)cyclePreventedResolver, (String)"cyclePreventedResolver");
                return this.this$0.getValuePattern().newBasedOn(new Row(null, null, null, null, null, null, 63, null), cyclePreventedResolver);
            }
        });
        Iterable $this$map$iv = newValuePatterns2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pattern pattern2 = (Pattern)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DictionaryPattern(this.keyPattern, (Pattern)it, null, 4, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pattern> newBasedOn(@NotNull Resolver resolver) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        List newValuePatterns2 = (List)resolver.withCyclePrevention(this.valuePattern, (Function1)new Function1<Resolver, List<? extends Pattern>>(this){
            final /* synthetic */ DictionaryPattern this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<Pattern> invoke(@NotNull Resolver cyclePreventedResolver) {
                Intrinsics.checkNotNullParameter((Object)cyclePreventedResolver, (String)"cyclePreventedResolver");
                return this.this$0.getValuePattern().newBasedOn(cyclePreventedResolver);
            }
        });
        Iterable $this$map$iv = newValuePatterns2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pattern pattern2 = (Pattern)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DictionaryPattern(this.keyPattern, (Pattern)it, null, 4, null));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<Pattern> negativeBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return CollectionsKt.listOf((Object)this);
    }

    @Override
    @NotNull
    public Value parse(@NotNull String value2, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return GrammarKt.parsedJSONObject$default(value2, null, 2, null);
    }

    @Override
    @NotNull
    public Result encompasses(@NotNull Pattern otherPattern, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        Result result2;
        Intrinsics.checkNotNullParameter((Object)otherPattern, (String)"otherPattern");
        Intrinsics.checkNotNullParameter((Object)thisResolver, (String)"thisResolver");
        Intrinsics.checkNotNullParameter((Object)otherResolver, (String)"otherResolver");
        Intrinsics.checkNotNullParameter(typeStack, (String)"typeStack");
        Pattern pattern2 = otherPattern;
        if (pattern2 instanceof ExactValuePattern) {
            result2 = otherPattern.fitsWithin(CollectionsKt.listOf((Object)this), otherResolver, thisResolver, typeStack);
        } else if (!(pattern2 instanceof DictionaryPattern)) {
            result2 = new Result.Failure("Expected dictionary type, got " + otherPattern.getTypeName(), null, null, null, 14, null);
        } else {
            Object v1;
            block6: {
                Object[] objectArray = new Function0[]{new Function0<Result>(this, otherPattern, thisResolver, otherResolver, typeStack){
                    final /* synthetic */ DictionaryPattern this$0;
                    final /* synthetic */ Pattern $otherPattern;
                    final /* synthetic */ Resolver $thisResolver;
                    final /* synthetic */ Resolver $otherResolver;
                    final /* synthetic */ Set<PairOfTypes> $typeStack;
                    {
                        this.this$0 = $receiver;
                        this.$otherPattern = $otherPattern;
                        this.$thisResolver = $thisResolver;
                        this.$otherResolver = $otherResolver;
                        this.$typeStack = $typeStack;
                        super(0);
                    }

                    @NotNull
                    public final Result invoke() {
                        return TypeStackKt.biggerEncompassesSmaller(this.this$0.getKeyPattern(), ((DictionaryPattern)this.$otherPattern).getKeyPattern(), this.$thisResolver, this.$otherResolver, this.$typeStack);
                    }
                }, new Function0<Result>(this, otherPattern, thisResolver, otherResolver, typeStack){
                    final /* synthetic */ DictionaryPattern this$0;
                    final /* synthetic */ Pattern $otherPattern;
                    final /* synthetic */ Resolver $thisResolver;
                    final /* synthetic */ Resolver $otherResolver;
                    final /* synthetic */ Set<PairOfTypes> $typeStack;
                    {
                        this.this$0 = $receiver;
                        this.$otherPattern = $otherPattern;
                        this.$thisResolver = $thisResolver;
                        this.$otherResolver = $otherResolver;
                        this.$typeStack = $typeStack;
                        super(0);
                    }

                    @NotNull
                    public final Result invoke() {
                        return TypeStackKt.biggerEncompassesSmaller(this.this$0.getValuePattern(), ((DictionaryPattern)this.$otherPattern).getValuePattern(), this.$thisResolver, this.$otherResolver, this.$typeStack);
                    }
                }};
                Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.listOf((Object[])objectArray)), (Function1)encompasses.3.INSTANCE);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Result it = (Result)element$iv;
                    boolean bl = false;
                    if (!(it instanceof Result.Failure)) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            if ((result2 = (Result)v1) == null) {
                result2 = new Result.Success(null, null, 3, null);
            }
        }
        return result2;
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(valueList, (String)"valueList");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return new JSONArrayValue(valueList);
    }

    @Override
    @NotNull
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @NotNull
    public Object getPattern() {
        return this.pattern;
    }

    @Override
    @NotNull
    public ConsumeResult<Value, Value> matches(@NotNull List<? extends Value> sampleData, @NotNull Resolver resolver) {
        return Pattern.DefaultImpls.matches(this, sampleData, resolver);
    }

    @Override
    @NotNull
    public ConsumeResult<Pattern, Pattern> encompasses(@NotNull List<? extends Pattern> others, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull String lengthError, @NotNull Set<PairOfTypes> typeStack) {
        return Pattern.DefaultImpls.encompasses(this, others, thisResolver, otherResolver, lengthError, typeStack);
    }

    @Override
    @NotNull
    public Value generateWithAll(@NotNull Resolver resolver) {
        return Pattern.DefaultImpls.generateWithAll(this, resolver);
    }

    @Override
    @NotNull
    public List<Pattern> patternSet(@NotNull Resolver resolver) {
        return Pattern.DefaultImpls.patternSet(this, resolver);
    }

    @Override
    @NotNull
    public Pattern parseToType(@NotNull String valueString, @NotNull Resolver resolver) {
        return Pattern.DefaultImpls.parseToType(this, valueString, resolver);
    }

    @Override
    @NotNull
    public Result fitsWithin(@NotNull List<? extends Pattern> otherPatterns, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        return Pattern.DefaultImpls.fitsWithin(this, otherPatterns, thisResolver, otherResolver, typeStack);
    }

    @NotNull
    public final Pattern component1() {
        return this.keyPattern;
    }

    @NotNull
    public final Pattern component2() {
        return this.valuePattern;
    }

    @Nullable
    public final String component3() {
        return this.typeAlias;
    }

    @NotNull
    public final DictionaryPattern copy(@NotNull Pattern keyPattern, @NotNull Pattern valuePattern, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter((Object)keyPattern, (String)"keyPattern");
        Intrinsics.checkNotNullParameter((Object)valuePattern, (String)"valuePattern");
        return new DictionaryPattern(keyPattern, valuePattern, typeAlias);
    }

    public static /* synthetic */ DictionaryPattern copy$default(DictionaryPattern dictionaryPattern, Pattern pattern2, Pattern pattern3, String string, int n, Object object) {
        if ((n & 1) != 0) {
            pattern2 = dictionaryPattern.keyPattern;
        }
        if ((n & 2) != 0) {
            pattern3 = dictionaryPattern.valuePattern;
        }
        if ((n & 4) != 0) {
            string = dictionaryPattern.typeAlias;
        }
        return dictionaryPattern.copy(pattern2, pattern3, string);
    }

    @NotNull
    public String toString() {
        return "DictionaryPattern(keyPattern=" + this.keyPattern + ", valuePattern=" + this.valuePattern + ", typeAlias=" + this.typeAlias + ')';
    }

    public int hashCode() {
        int result2 = this.keyPattern.hashCode();
        result2 = result2 * 31 + this.valuePattern.hashCode();
        result2 = result2 * 31 + (this.typeAlias == null ? 0 : this.typeAlias.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DictionaryPattern)) {
            return false;
        }
        DictionaryPattern dictionaryPattern = (DictionaryPattern)other;
        if (!Intrinsics.areEqual((Object)this.keyPattern, (Object)dictionaryPattern.keyPattern)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.valuePattern, (Object)dictionaryPattern.valuePattern)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.typeAlias, (Object)dictionaryPattern.typeAlias);
    }
}

