/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.pattern;

import in.specmatic.core.FeatureKt;
import in.specmatic.core.References;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.pattern.RowValue;
import in.specmatic.core.pattern.ValueReference;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002J\t\u0010\u000b\u001a\u00020\u0003H\u00c2\u0003J\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c2\u0003J)\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lin/specmatic/core/pattern/ReferenceValue;", "Lin/specmatic/core/pattern/RowValue;", "valueReference", "Lin/specmatic/core/pattern/ValueReference;", "references", "", "", "Lin/specmatic/core/References;", "(Lin/specmatic/core/pattern/ValueReference;Ljava/util/Map;)V", "breakUpIntoParts", "", "component1", "component2", "copy", "equals", "", "other", "", "fetch", "hashCode", "", "toString", "core"})
public final class ReferenceValue
implements RowValue {
    @NotNull
    private final ValueReference valueReference;
    @NotNull
    private final Map<String, References> references;

    public ReferenceValue(@NotNull ValueReference valueReference, @NotNull Map<String, References> references) {
        Intrinsics.checkNotNullParameter((Object)valueReference, (String)"valueReference");
        Intrinsics.checkNotNullParameter(references, (String)"references");
        this.valueReference = valueReference;
        this.references = references;
    }

    public /* synthetic */ ReferenceValue(ValueReference valueReference, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(valueReference, map);
    }

    @Override
    @NotNull
    public String fetch() {
        List<String> parts = this.breakUpIntoParts();
        if (parts.size() <= 1) {
            throw new ContractException("A reference to values must be of the form \"value-name.variable-set-by-contract\"", null, null, null, false, 30, null);
        }
        String name = parts.get(0);
        String selector = parts.get(1);
        Object object = this.references.get(name);
        if (object == null || (object = ((References)object).lookup(selector)) == null) {
            throw new ContractException("Could not find reference to value \"" + this.valueReference.getName() + '\"', null, null, null, false, 30, null);
        }
        return object;
    }

    private final List<String> breakUpIntoParts() {
        return FeatureKt.breakIntoPartsMaxLength(this.valueReference.getName(), "\\.", 2);
    }

    private final ValueReference component1() {
        return this.valueReference;
    }

    private final Map<String, References> component2() {
        return this.references;
    }

    @NotNull
    public final ReferenceValue copy(@NotNull ValueReference valueReference, @NotNull Map<String, References> references) {
        Intrinsics.checkNotNullParameter((Object)valueReference, (String)"valueReference");
        Intrinsics.checkNotNullParameter(references, (String)"references");
        return new ReferenceValue(valueReference, references);
    }

    public static /* synthetic */ ReferenceValue copy$default(ReferenceValue referenceValue, ValueReference valueReference, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            valueReference = referenceValue.valueReference;
        }
        if ((n & 2) != 0) {
            map = referenceValue.references;
        }
        return referenceValue.copy(valueReference, map);
    }

    @NotNull
    public String toString() {
        return "ReferenceValue(valueReference=" + this.valueReference + ", references=" + this.references + ')';
    }

    public int hashCode() {
        int result2 = this.valueReference.hashCode();
        result2 = result2 * 31 + ((Object)this.references).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReferenceValue)) {
            return false;
        }
        ReferenceValue referenceValue = (ReferenceValue)other;
        if (!Intrinsics.areEqual((Object)this.valueReference, (Object)referenceValue.valueReference)) {
            return false;
        }
        return Intrinsics.areEqual(this.references, referenceValue.references);
    }
}

