/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.value;

import in.specmatic.core.ExampleDeclarations;
import in.specmatic.core.Result;
import in.specmatic.core.pattern.ExactValuePattern;
import in.specmatic.core.pattern.Pattern;
import in.specmatic.core.pattern.StringPattern;
import in.specmatic.core.value.JSONArrayValue;
import in.specmatic.core.value.ScalarValue;
import in.specmatic.core.value.StringValue;
import in.specmatic.core.value.TypeDeclaration;
import in.specmatic.core.value.TypeDeclarationKt;
import in.specmatic.core.value.Value;
import in.specmatic.core.value.XMLNode;
import in.specmatic.core.value.XMLValue;
import io.ktor.http.HeaderValueWithParametersKt;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u0013\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\b\u0010\u0018\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\nH\u0016J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\t\u0010 \u001a\u00020!H\u00d6\u0001J\u0016\u0010\"\u001a\u00020\u00012\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\nH\u0016J\b\u0010(\u001a\u00020\nH\u0016J\b\u0010)\u001a\u00020\u001fH\u0016J8\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0+2\u0006\u0010.\u001a\u00020\n2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001f002\u0006\u00101\u001a\u00020-H\u0016J8\u00102\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0+2\u0006\u00103\u001a\u00020\n2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001f002\u0006\u00101\u001a\u00020-H\u0016J\b\u00104\u001a\u00020\nH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\u00a8\u00065"}, d2={"Lin/specmatic/core/value/BinaryValue;", "Lin/specmatic/core/value/Value;", "Lin/specmatic/core/value/ScalarValue;", "Lin/specmatic/core/value/XMLValue;", "byteArray", "", "([B)V", "getByteArray", "()[B", "httpContentType", "", "getHttpContentType", "()Ljava/lang/String;", "nativeValue", "getNativeValue", "addSchema", "schema", "Lin/specmatic/core/value/XMLNode;", "build", "Lorg/w3c/dom/Node;", "document", "Lorg/w3c/dom/Document;", "component1", "copy", "displayableType", "displayableValue", "equals", "", "other", "", "exactMatchElseType", "Lin/specmatic/core/pattern/Pattern;", "hashCode", "", "listOf", "valueList", "", "matchFailure", "Lin/specmatic/core/Result$Failure;", "toString", "toStringLiteral", "type", "typeDeclarationWithKey", "Lkotlin/Pair;", "Lin/specmatic/core/value/TypeDeclaration;", "Lin/specmatic/core/ExampleDeclarations;", "key", "types", "", "exampleDeclarations", "typeDeclarationWithoutKey", "exampleKey", "valueErrorSnippet", "core"})
public final class BinaryValue
implements Value,
ScalarValue,
XMLValue {
    @NotNull
    private final byte[] byteArray;
    @NotNull
    private final String httpContentType;

    public BinaryValue(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        this.byteArray = byteArray;
        this.httpContentType = "application/octet-stream";
    }

    public /* synthetic */ BinaryValue(byte[] byArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            byArray = new byte[]{};
        }
        this(byArray);
    }

    @NotNull
    public final byte[] getByteArray() {
        return this.byteArray;
    }

    @Override
    @NotNull
    public String getHttpContentType() {
        return this.httpContentType;
    }

    @Override
    @NotNull
    public String valueErrorSnippet() {
        return this.displayableValue();
    }

    @Override
    @NotNull
    public String displayableValue() {
        return HeaderValueWithParametersKt.quote((String)this.toStringLiteral());
    }

    @Override
    @NotNull
    public String toStringLiteral() {
        String string = Arrays.toString(this.byteArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public String displayableType() {
        return "binary";
    }

    @Override
    @NotNull
    public Pattern exactMatchElseType() {
        return new ExactValuePattern(this, null, 2, null);
    }

    @Override
    @NotNull
    public Node build(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        String string = Arrays.toString(this.byteArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Text text = document.createTextNode(string);
        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"createTextNode(...)");
        return text;
    }

    @Override
    @NotNull
    public Result.Failure matchFailure() {
        return new Result.Failure("Unexpected child value found: " + this.byteArray, null, null, null, 14, null);
    }

    @Override
    @NotNull
    public XMLValue addSchema(@NotNull XMLNode schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return this;
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList) {
        Intrinsics.checkNotNullParameter(valueList, (String)"valueList");
        return new JSONArrayValue(valueList);
    }

    @Override
    @NotNull
    public Pattern type() {
        return new StringPattern(null, null, null, null, 15, null);
    }

    @Override
    @NotNull
    public Pair<TypeDeclaration, ExampleDeclarations> typeDeclarationWithKey(@NotNull String key2, @NotNull Map<String, ? extends Pattern> types, @NotNull ExampleDeclarations exampleDeclarations) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)exampleDeclarations, (String)"exampleDeclarations");
        String string = this.displayableType();
        String string2 = Arrays.toString(this.byteArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return TypeDeclarationKt.primitiveTypeDeclarationWithKey(key2, types, exampleDeclarations, string, string2);
    }

    @Override
    @NotNull
    public Pair<TypeDeclaration, ExampleDeclarations> typeDeclarationWithoutKey(@NotNull String exampleKey, @NotNull Map<String, ? extends Pattern> types, @NotNull ExampleDeclarations exampleDeclarations) {
        Intrinsics.checkNotNullParameter((Object)exampleKey, (String)"exampleKey");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)exampleDeclarations, (String)"exampleDeclarations");
        String string = this.displayableType();
        String string2 = Arrays.toString(this.byteArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return TypeDeclarationKt.primitiveTypeDeclarationWithoutKey(exampleKey, types, exampleDeclarations, string, string2);
    }

    @NotNull
    public byte[] getNativeValue() {
        return this.byteArray;
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.byteArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public StringValue toStringValue() {
        return Value.DefaultImpls.toStringValue(this);
    }

    @NotNull
    public final byte[] component1() {
        return this.byteArray;
    }

    @NotNull
    public final BinaryValue copy(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        return new BinaryValue(byteArray);
    }

    public static /* synthetic */ BinaryValue copy$default(BinaryValue binaryValue, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            byArray = binaryValue.byteArray;
        }
        return binaryValue.copy(byArray);
    }

    public int hashCode() {
        return Arrays.hashCode(this.byteArray);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BinaryValue)) {
            return false;
        }
        BinaryValue binaryValue = (BinaryValue)other;
        return Intrinsics.areEqual((Object)this.byteArray, (Object)binaryValue.byteArray);
    }

    public BinaryValue() {
        this(null, 1, null);
    }
}

