/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.wsdl.parser.message;

import in.specmatic.core.pattern.XMLPattern;
import in.specmatic.core.utilities.Utilities;
import in.specmatic.core.value.FullyQualifiedName;
import in.specmatic.core.value.XMLNode;
import in.specmatic.core.wsdl.parser.SOAPMessageType;
import in.specmatic.core.wsdl.parser.WSDL;
import in.specmatic.core.wsdl.parser.WSDLTypeInfo;
import in.specmatic.core.wsdl.parser.message.MessageTypeInfoParser;
import in.specmatic.core.wsdl.parser.message.MessageTypeProcessingComplete;
import in.specmatic.core.wsdl.parser.message.WSDLElement;
import in.specmatic.core.wsdl.payload.SOAPPayload;
import in.specmatic.core.wsdl.payload.SoapPayloadType;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0010\u001a\u00020\u0007H\u00c2\u0003J\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u00c2\u0003J\t\u0010\u0012\u001a\u00020\nH\u00c2\u0003JG\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\b\b\u0002\u0010\f\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\b\u0010\u0018\u001a\u00020\u0001H\u0016J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\nH\u00d6\u0001R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lin/specmatic/core/wsdl/parser/message/ParseMessageWithElementRef;", "Lin/specmatic/core/wsdl/parser/message/MessageTypeInfoParser;", "wsdl", "Lin/specmatic/core/wsdl/parser/WSDL;", "fullyQualifiedName", "Lin/specmatic/core/value/FullyQualifiedName;", "soapMessageType", "Lin/specmatic/core/wsdl/parser/SOAPMessageType;", "existingTypes", "", "", "Lin/specmatic/core/pattern/XMLPattern;", "operationName", "(Lin/specmatic/core/wsdl/parser/WSDL;Lin/specmatic/core/value/FullyQualifiedName;Lin/specmatic/core/wsdl/parser/SOAPMessageType;Ljava/util/Map;Ljava/lang/String;)V", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "execute", "hashCode", "", "toString", "core"})
public final class ParseMessageWithElementRef
implements MessageTypeInfoParser {
    @NotNull
    private final WSDL wsdl;
    @NotNull
    private final FullyQualifiedName fullyQualifiedName;
    @NotNull
    private final SOAPMessageType soapMessageType;
    @NotNull
    private final Map<String, XMLPattern> existingTypes;
    @NotNull
    private final String operationName;

    public ParseMessageWithElementRef(@NotNull WSDL wsdl, @NotNull FullyQualifiedName fullyQualifiedName2, @NotNull SOAPMessageType soapMessageType, @NotNull Map<String, XMLPattern> existingTypes, @NotNull String operationName) {
        Intrinsics.checkNotNullParameter((Object)wsdl, (String)"wsdl");
        Intrinsics.checkNotNullParameter((Object)fullyQualifiedName2, (String)"fullyQualifiedName");
        Intrinsics.checkNotNullParameter((Object)((Object)soapMessageType), (String)"soapMessageType");
        Intrinsics.checkNotNullParameter(existingTypes, (String)"existingTypes");
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        this.wsdl = wsdl;
        this.fullyQualifiedName = fullyQualifiedName2;
        this.soapMessageType = soapMessageType;
        this.existingTypes = existingTypes;
        this.operationName = operationName;
    }

    @Override
    @NotNull
    public MessageTypeInfoParser execute() {
        WSDLElement topLevelElement = WSDL.getSOAPElement$default(this.wsdl, this.fullyQualifiedName, null, null, 6, null);
        String qontractTypeName = StringsKt.replace$default((String)this.operationName, (String)":", (String)"_", (boolean)false, (int)4, null) + "_SOAPPayload_" + Utilities.capitalizeFirstChar(this.soapMessageType.getMessageTypeName());
        WSDLTypeInfo typeInfo = topLevelElement.deriveSpecmaticTypes(qontractTypeName, this.existingTypes, SetsKt.emptySet());
        Map<String, String> namespaces = this.wsdl.getNamespaces(typeInfo);
        Object object = CollectionsKt.first(typeInfo.getNodes());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type in.specmatic.core.value.XMLNode");
        String nodeNameForSOAPBody = ((XMLNode)object).getRealName();
        SOAPPayload soapPayload = topLevelElement.getSOAPPayload(this.soapMessageType, nodeNameForSOAPBody, qontractTypeName, namespaces, typeInfo);
        return new MessageTypeProcessingComplete(new SoapPayloadType(typeInfo.getTypes(), soapPayload));
    }

    @Override
    @Nullable
    public SoapPayloadType getSoapPayloadType() {
        return MessageTypeInfoParser.DefaultImpls.getSoapPayloadType(this);
    }

    private final WSDL component1() {
        return this.wsdl;
    }

    private final FullyQualifiedName component2() {
        return this.fullyQualifiedName;
    }

    private final SOAPMessageType component3() {
        return this.soapMessageType;
    }

    private final Map<String, XMLPattern> component4() {
        return this.existingTypes;
    }

    private final String component5() {
        return this.operationName;
    }

    @NotNull
    public final ParseMessageWithElementRef copy(@NotNull WSDL wsdl, @NotNull FullyQualifiedName fullyQualifiedName2, @NotNull SOAPMessageType soapMessageType, @NotNull Map<String, XMLPattern> existingTypes, @NotNull String operationName) {
        Intrinsics.checkNotNullParameter((Object)wsdl, (String)"wsdl");
        Intrinsics.checkNotNullParameter((Object)fullyQualifiedName2, (String)"fullyQualifiedName");
        Intrinsics.checkNotNullParameter((Object)((Object)soapMessageType), (String)"soapMessageType");
        Intrinsics.checkNotNullParameter(existingTypes, (String)"existingTypes");
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        return new ParseMessageWithElementRef(wsdl, fullyQualifiedName2, soapMessageType, existingTypes, operationName);
    }

    public static /* synthetic */ ParseMessageWithElementRef copy$default(ParseMessageWithElementRef parseMessageWithElementRef, WSDL wSDL, FullyQualifiedName fullyQualifiedName2, SOAPMessageType sOAPMessageType, Map map, String string, int n, Object object) {
        if ((n & 1) != 0) {
            wSDL = parseMessageWithElementRef.wsdl;
        }
        if ((n & 2) != 0) {
            fullyQualifiedName2 = parseMessageWithElementRef.fullyQualifiedName;
        }
        if ((n & 4) != 0) {
            sOAPMessageType = parseMessageWithElementRef.soapMessageType;
        }
        if ((n & 8) != 0) {
            map = parseMessageWithElementRef.existingTypes;
        }
        if ((n & 0x10) != 0) {
            string = parseMessageWithElementRef.operationName;
        }
        return parseMessageWithElementRef.copy(wSDL, fullyQualifiedName2, sOAPMessageType, map, string);
    }

    @NotNull
    public String toString() {
        return "ParseMessageWithElementRef(wsdl=" + this.wsdl + ", fullyQualifiedName=" + this.fullyQualifiedName + ", soapMessageType=" + (Object)((Object)this.soapMessageType) + ", existingTypes=" + this.existingTypes + ", operationName=" + this.operationName + ')';
    }

    public int hashCode() {
        int result2 = this.wsdl.hashCode();
        result2 = result2 * 31 + this.fullyQualifiedName.hashCode();
        result2 = result2 * 31 + this.soapMessageType.hashCode();
        result2 = result2 * 31 + ((Object)this.existingTypes).hashCode();
        result2 = result2 * 31 + this.operationName.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ParseMessageWithElementRef)) {
            return false;
        }
        ParseMessageWithElementRef parseMessageWithElementRef = (ParseMessageWithElementRef)other;
        if (!Intrinsics.areEqual((Object)this.wsdl, (Object)parseMessageWithElementRef.wsdl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fullyQualifiedName, (Object)parseMessageWithElementRef.fullyQualifiedName)) {
            return false;
        }
        if (this.soapMessageType != parseMessageWithElementRef.soapMessageType) {
            return false;
        }
        if (!Intrinsics.areEqual(this.existingTypes, parseMessageWithElementRef.existingTypes)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.operationName, (Object)parseMessageWithElementRef.operationName);
    }
}

