/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core;

import in.specmatic.core.HttpHeadersPattern;
import in.specmatic.core.HttpHeadersPatternKt;
import in.specmatic.core.HttpPathPattern;
import in.specmatic.core.HttpPathPatternKt;
import in.specmatic.core.HttpQueryParamPattern;
import in.specmatic.core.HttpRequest;
import in.specmatic.core.HttpRequestKt;
import in.specmatic.core.HttpRequestPattern;
import in.specmatic.core.MultiPartContent;
import in.specmatic.core.MultiPartContentValue;
import in.specmatic.core.MultiPartFileValue;
import in.specmatic.core.MultiPartFormDataPattern;
import in.specmatic.core.MultiPartFormDataValue;
import in.specmatic.core.NoBodyValue;
import in.specmatic.core.Resolver;
import in.specmatic.core.URLParts;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.pattern.ExactValuePattern;
import in.specmatic.core.pattern.GrammarKt;
import in.specmatic.core.pattern.Pattern;
import in.specmatic.core.pattern.StringPattern;
import in.specmatic.core.utilities.URIUtils;
import in.specmatic.core.value.EmptyStringKt;
import in.specmatic.core.value.JSONArrayValue;
import in.specmatic.core.value.JSONObjectValue;
import in.specmatic.core.value.StringValue;
import in.specmatic.core.value.Value;
import in.specmatic.core.value.XMLNode;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.UtilsKt;
import io.ktor.client.request.forms.FormBuilder;
import io.ktor.client.request.forms.FormDataContent;
import io.ktor.client.request.forms.FormDslKt;
import io.ktor.client.request.forms.MultiPartFormDataContent;
import io.ktor.http.ContentType;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.HttpMethod;
import io.ktor.http.ParametersKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLBuilderKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.TextContent;
import io.ktor.util.reflect.TypeInfoJvmKt;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0086\b\u0018\u00002\u00020\u0001:\u0003YZ[B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006By\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u0012\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$J\u000b\u0010%\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J\t\u0010(\u001a\u00020\u000bH\u00c6\u0003J\u0015\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J\u0015\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J\u000f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u00c6\u0003J$\u0010,\u001a\u00020\u00032\b\u0010-\u001a\u0004\u0018\u00010\u00032\b\u0010.\u001a\u0004\u0018\u00010\u00032\u0006\u0010/\u001a\u00020\u0003H\u0002J}\u00100\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u00c6\u0001J\u0013\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u00104\u001a\u00020\u00032\b\u00105\u001a\u0004\u0018\u00010\u0003J\t\u00106\u001a\u000207H\u00d6\u0001J\u0010\u00108\u001a\u0002022\u0006\u00109\u001a\u00020\u0003H\u0002J\u0010\u0010:\u001a\u0002022\u0006\u00109\u001a\u00020\u0003H\u0002J\u0006\u0010;\u001a\u00020\u0000J(\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020=0\t2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u0002J\u0006\u0010?\u001a\u00020\u0003J\u000e\u0010?\u001a\u00020\u00032\u0006\u0010@\u001a\u00020AJ\u0006\u0010B\u001a\u00020\u0003J\u001a\u0010C\u001a\u00020\u00002\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tJ\u0006\u0010E\u001a\u00020FJ\u0010\u0010G\u001a\u00020\u00032\b\b\u0002\u0010H\u001a\u00020\u0003J\u0006\u0010I\u001a\u00020JJ\t\u0010K\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010L\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010L\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u0003J\u0016\u0010M\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u00032\u0006\u0010O\u001a\u00020\u0003J\u000e\u0010P\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020\u0003J\u000e\u0010R\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u0010S\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u00032\u0006\u0010O\u001a\u00020\u0003J\u001a\u0010T\u001a\u00020\u00002\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tJ\u000e\u0010U\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0005J\u000e\u0010V\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0003J2\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u0006\u0010X\u001a\u00020\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0016R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018\u00a8\u0006\\"}, d2={"Lin/specmatic/core/HttpRequest;", "", "method", "", "uri", "Ljava/net/URI;", "(Ljava/lang/String;Ljava/net/URI;)V", "path", "headers", "", "body", "Lin/specmatic/core/value/Value;", "queryParams", "formFields", "multiPartFormData", "", "Lin/specmatic/core/MultiPartFormDataValue;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Lin/specmatic/core/value/Value;Ljava/util/Map;Ljava/util/Map;Ljava/util/List;)V", "getBody", "()Lin/specmatic/core/value/Value;", "bodyString", "getBodyString", "()Ljava/lang/String;", "getFormFields", "()Ljava/util/Map;", "getHeaders", "getMethod", "getMultiPartFormData", "()Ljava/util/List;", "getPath", "getQueryParams", "buildKTORRequest", "", "httpRequestBuilder", "Lio/ktor/client/request/HttpRequestBuilder;", "url", "Ljava/net/URL;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "concatNonNulls", "first", "second", "separator", "copy", "equals", "", "other", "getURL", "baseURL", "hashCode", "", "isIPAddress", "host", "isNotIPAddress", "loadFileContentIntoParts", "mapToPattern", "Lin/specmatic/core/pattern/Pattern;", "map", "requestNotRecognized", "requestNotRecognizedMessages", "Lin/specmatic/core/HttpRequest$RequestNotRecognizedMessages;", "requestNotRecognizedInStrictMode", "setHeaders", "addedHeaders", "toJSON", "Lin/specmatic/core/value/JSONObjectValue;", "toLogString", "prefix", "toPattern", "Lin/specmatic/core/HttpRequestPattern;", "toString", "updateBody", "updateHeader", "key", "value", "updateMethod", "name", "updatePath", "updateQueryParam", "updateQueryParams", "updateWith", "withHost", "withoutDuplicateHostHeader", "withoutDynamicHeaders", "LenientRequestNotRecognizedMessages", "RequestNotRecognizedMessages", "StrictRequestNotRecognizedMessages", "core"})
@SourceDebugExtension(value={"SMAP\nHttpRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequest.kt\nin/specmatic/core/HttpRequest\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 7 RequestBody.kt\nio/ktor/client/request/RequestBodyKt\n+ 8 TypeInfoJvm.kt\nio/ktor/util/reflect/TypeInfoJvmKt\n*L\n1#1,570:1\n125#2:571\n152#2,3:572\n125#2:589\n152#2,3:590\n125#2:593\n152#2,3:594\n125#2:597\n152#2,3:598\n125#2:611\n152#2,3:612\n819#3:575\n847#3,2:576\n1238#3,4:581\n1549#3:585\n1620#3,3:586\n1549#3:601\n1620#3,3:602\n1238#3,4:607\n766#3:615\n857#3,2:616\n1855#3,2:618\n1238#3,4:622\n1549#3:645\n1620#3,3:646\n1549#3:649\n1620#3,3:650\n1#4:578\n453#5:579\n403#5:580\n453#5:605\n403#5:606\n453#5:620\n403#5:621\n37#6,2:626\n16#7,4:628\n21#7,10:635\n17#8,3:632\n*S KotlinDebug\n*F\n+ 1 HttpRequest.kt\nin/specmatic/core/HttpRequest\n*L\n82#1:571\n82#1:572,3\n119#1:589\n119#1:590,3\n123#1:593\n123#1:594,3\n125#1:597\n125#1:598,3\n167#1:611\n167#1:612,3\n87#1:575\n87#1:576,2\n101#1:581,4\n104#1:585\n104#1:586,3\n148#1:601\n148#1:602,3\n153#1:607,4\n168#1:615\n168#1:616,2\n169#1:618,2\n182#1:622,4\n225#1:645\n225#1:646,3\n234#1:649\n234#1:650,3\n101#1:579\n101#1:580\n153#1:605\n153#1:606\n182#1:620\n182#1:621\n183#1:626,2\n179#1:628,4\n179#1:635,10\n179#1:632,3\n*E\n"})
public final class HttpRequest {
    @Nullable
    private final String method;
    @Nullable
    private final String path;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    private final Value body;
    @NotNull
    private final Map<String, String> queryParams;
    @NotNull
    private final Map<String, String> formFields;
    @NotNull
    private final List<MultiPartFormDataValue> multiPartFormData;

    public HttpRequest(@Nullable String method, @Nullable String path2, @NotNull Map<String, String> headers2, @NotNull Value body, @NotNull Map<String, String> queryParams2, @NotNull Map<String, String> formFields, @NotNull List<? extends MultiPartFormDataValue> multiPartFormData) {
        Intrinsics.checkNotNullParameter(headers2, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter(queryParams2, (String)"queryParams");
        Intrinsics.checkNotNullParameter(formFields, (String)"formFields");
        Intrinsics.checkNotNullParameter(multiPartFormData, (String)"multiPartFormData");
        this.method = method;
        this.path = path2;
        this.headers = headers2;
        this.body = body;
        this.queryParams = queryParams2;
        this.formFields = formFields;
        this.multiPartFormData = multiPartFormData;
    }

    public /* synthetic */ HttpRequest(String string, String string2, Map map, Value value2, Map map2, Map map3, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            value2 = EmptyStringKt.getEmptyString();
        }
        if ((n & 0x10) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            map3 = MapsKt.emptyMap();
        }
        if ((n & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, string2, map, value2, map2, map3, list);
    }

    @Nullable
    public final String getMethod() {
        return this.method;
    }

    @Nullable
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Value getBody() {
        return this.body;
    }

    @NotNull
    public final Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    @NotNull
    public final Map<String, String> getFormFields() {
        return this.formFields;
    }

    @NotNull
    public final List<MultiPartFormDataValue> getMultiPartFormData() {
        return this.multiPartFormData;
    }

    public HttpRequest(@NotNull String method, @NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this(method, uri.getPath(), null, null, HttpRequestKt.urlToQueryParams(uri), null, null, 108, null);
    }

    @NotNull
    public final HttpRequest updateQueryParams(@NotNull Map<String, String> queryParams2) {
        Intrinsics.checkNotNullParameter(queryParams2, (String)"queryParams");
        return HttpRequest.copy$default(this, null, null, null, null, MapsKt.plus(queryParams2, queryParams2), null, null, 111, null);
    }

    @NotNull
    public final HttpRequest withHost(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return HttpRequest.copy$default(this, null, null, MapsKt.plus(this.headers, (Pair)TuplesKt.to((Object)"Host", (Object)host)), null, null, null, null, 123, null);
    }

    @NotNull
    public final HttpRequest updatePath(@NotNull String path2) {
        HttpRequest httpRequest;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        try {
            URI urlParam = new URI(path2);
            httpRequest = this.updateWith(urlParam);
        }
        catch (URISyntaxException e) {
            httpRequest = HttpRequest.copy$default(this, null, path2, null, null, null, null, null, 125, null);
        }
        catch (UnsupportedEncodingException e) {
            httpRequest = HttpRequest.copy$default(this, null, path2, null, null, null, null, null, 125, null);
        }
        return httpRequest;
    }

    @NotNull
    public final HttpRequest updateQueryParam(@NotNull String key2, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return HttpRequest.copy$default(this, null, null, null, null, MapsKt.plus(this.queryParams, (Pair)TuplesKt.to((Object)key2, (Object)value2)), null, null, 111, null);
    }

    @NotNull
    public final HttpRequest updateBody(@NotNull Value body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return HttpRequest.copy$default(this, null, null, null, body, null, null, null, 119, null);
    }

    @NotNull
    public final HttpRequest updateBody(@Nullable String body) {
        return HttpRequest.copy$default(this, null, null, null, GrammarKt.parsedValue(body), null, null, null, 119, null);
    }

    @NotNull
    public final HttpRequest updateWith(@NotNull URI url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String path2 = url.getPath();
        Map<String, String> queryParams2 = URIUtils.INSTANCE.parseQuery(url.getQuery());
        return HttpRequest.copy$default(this, null, path2, null, null, queryParams2, null, null, 109, null);
    }

    @NotNull
    public final HttpRequest updateMethod(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return HttpRequest.copy$default(this, string, null, null, null, null, null, null, 126, null);
    }

    @NotNull
    public final HttpRequest updateHeader(@NotNull String key2, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return HttpRequest.copy$default(this, null, null, MapsKt.plus(this.headers, (Pair)TuplesKt.to((Object)key2, (Object)value2)), null, null, null, null, 123, null);
    }

    @NotNull
    public final String getBodyString() {
        return this.body.toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getURL(@Nullable String baseURL) {
        void $this$mapTo$iv$iv;
        String string = baseURL;
        String cleanBase = string != null ? StringsKt.removeSuffix((String)string, (CharSequence)"/") : null;
        String string2 = this.path;
        String cleanPath = string2 != null ? StringsKt.removePrefix((String)string2, (CharSequence)"/") : null;
        String fullUrl = new URLParts(this.concatNonNulls(cleanBase, cleanPath, "/")).withEncodedPathSegments();
        Map<String, String> $this$map$iv = this.queryParams;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new BasicNameValuePair((String)it.getKey(), (String)it.getValue()));
        }
        String queryPart = URLEncodedUtils.format((Iterable)((List)destination$iv$iv), (Charset)Charsets.UTF_8);
        return this.concatNonNulls(fullUrl, queryPart, "?");
    }

    /*
     * WARNING - void declaration
     */
    private final String concatNonNulls(String first, String second, String separator) {
        void $this$filterNotTo$iv$iv;
        Object[] objectArray = new String[]{first, second};
        Iterable $this$filterNot$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)separator, null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JSONObjectValue toJSON() {
        Unit unit;
        StringValue stringValue;
        Map requestMap;
        Map map = requestMap = (Map)new LinkedHashMap();
        String string = "path";
        String string2 = this.path;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            stringValue = new StringValue(it);
        } else {
            stringValue = new StringValue("/");
        }
        Value value2 = stringValue;
        map.put(string, value2);
        String string3 = this.method;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            requestMap.put("method", new StringValue(it));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ContractException("Can't serialise the request without a method.", null, null, null, false, 30, null);
        }
        HttpRequestKt.access$setIfNotEmpty(requestMap, "query", this.queryParams);
        HttpRequestKt.access$setIfNotEmpty(requestMap, "headers", this.headers);
        if (!this.formFields.isEmpty()) {
            void $this$mapValuesTo$iv$iv;
            map = requestMap;
            string = "form-fields";
            Object $this$mapValues$iv = this.formFields;
            boolean $i$f$mapValues = false;
            Map<String, String> bl = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object object = destination$iv$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Object object2 = object;
                boolean bl3 = false;
                StringValue stringValue2 = new StringValue((String)it.getValue());
                object2.put(k, stringValue2);
            }
            Object object = destination$iv$iv;
            $this$mapValues$iv = new JSONObjectValue((Map<String, ? extends Value>)object);
            map.put(string, $this$mapValues$iv);
        } else if (!((Collection)this.multiPartFormData).isEmpty()) {
            void $this$mapTo$iv$iv;
            map = requestMap;
            string = "multipart-formdata";
            Iterable $this$map$iv = this.multiPartFormData;
            boolean $i$f$map = false;
            Iterable $this$mapValuesTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MultiPartFormDataValue multiPartFormDataValue = (MultiPartFormDataValue)item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl = false;
                object.add(it.toJSONObject());
            }
            List list = (List)destination$iv$iv;
            value2 = new JSONArrayValue(list);
            map.put(string, value2);
        } else {
            requestMap.put("body", this.body);
        }
        return new JSONObjectValue(requestMap);
    }

    @NotNull
    public final HttpRequest setHeaders(@NotNull Map<String, String> addedHeaders) {
        Intrinsics.checkNotNullParameter(addedHeaders, (String)"addedHeaders");
        return HttpRequest.copy$default(this, null, null, MapsKt.plus(this.headers, addedHeaders), null, null, null, null, 123, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toLogString(@NotNull String prefix2) {
        String string;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        String string2;
        String methodString;
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        String string3 = this.method;
        if (string3 == null) {
            string3 = methodString = "NO_METHOD";
        }
        if ((string2 = this.path) == null) {
            string2 = "NO_PATH";
        }
        String pathString = string2;
        Map<String, String> $this$map$iv = this.queryParams;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Object object = $this$mapTo$iv$iv2.entrySet().iterator();
        while (object.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = object.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getKey() + "=" + it.getValue());
        }
        String it = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        boolean bl = false;
        Object queryParamString = ((CharSequence)it).length() > 0 ? "?" + it : it;
        String urlString = pathString + (String)queryParamString;
        String firstLine = methodString + " " + urlString;
        Map<String, String> $this$map$iv2 = this.headers;
        boolean $i$f$map2 = false;
        object = $this$map$iv2;
        Object destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        Iterator bl2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (bl2.hasNext()) {
            void it2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = bl2.next();
            collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(it2.getKey() + ": " + it2.getValue());
        }
        String headerString2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        if (!this.formFields.isEmpty()) {
            void $this$mapTo$iv$iv3;
            Map<String, String> $this$map$iv3 = this.formFields;
            boolean $i$f$map3 = false;
            destination$iv$iv2 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList($this$map$iv3.size());
            boolean $i$f$mapTo3 = false;
            Iterator iterator = $this$mapTo$iv$iv3.entrySet().iterator();
            while (iterator.hasNext()) {
                void it3;
                Map.Entry item$iv$iv;
                Map.Entry bl3 = item$iv$iv = iterator.next();
                collection = destination$iv$iv3;
                boolean bl4 = false;
                collection.add(it3.getKey() + "=" + it3.getValue());
            }
            string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv3), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        } else {
            string = !((Collection)this.multiPartFormData).isEmpty() ? CollectionsKt.joinToString$default((Iterable)this.multiPartFormData, (CharSequence)"\n", null, null, (int)0, null, (Function1)toLogString.bodyString.2.INSTANCE, (int)30, null) : this.body.toString();
        }
        String bodyString2 = string;
        Object[] $i$f$map3 = new String[]{firstLine, headerString2};
        String firstPart = ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])$i$f$map3), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null))).toString();
        Object[] objectArray = new String[]{firstPart, "", bodyString2};
        String requestString = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return HttpRequestKt.startLinesWith(requestString, prefix2);
    }

    public static /* synthetic */ String toLogString$default(HttpRequest httpRequest, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return httpRequest.toLogString(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HttpRequestPattern toPattern() {
        Collection<MultiPartFormDataPattern> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string = this.path;
        if (string == null) {
            string = "/";
        }
        String pathForPattern = string;
        Iterable iterable = this.multiPartFormData;
        Map<String, Pattern> map = this.mapToPattern(this.formFields);
        Pattern pattern2 = this.body.exactMatchElseType();
        String string2 = this.method;
        HttpQueryParamPattern httpQueryParamPattern = new HttpQueryParamPattern(this.mapToPattern(this.queryParams));
        HttpPathPattern httpPathPattern = new HttpPathPattern(HttpPathPatternKt.pathToPattern(pathForPattern), pathForPattern);
        HttpHeadersPattern httpHeadersPattern = new HttpHeadersPattern(this.mapToPattern(this.headers), null, null, 6, null);
        boolean $i$f$map = false;
        void var4_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MultiPartFormDataValue multiPartFormDataValue = (MultiPartFormDataValue)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.inferType());
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 128;
        List list = null;
        Collection<MultiPartFormDataPattern> collection2 = collection;
        Map<String, Pattern> map2 = map;
        Pattern pattern3 = pattern2;
        String string3 = string2;
        HttpQueryParamPattern httpQueryParamPattern2 = httpQueryParamPattern;
        HttpPathPattern httpPathPattern2 = httpPathPattern;
        HttpHeadersPattern httpHeadersPattern2 = httpHeadersPattern;
        return new HttpRequestPattern(httpHeadersPattern2, httpPathPattern2, httpQueryParamPattern2, string3, pattern3, map2, (List)collection2, list, n, defaultConstructorMarker);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Pattern> mapToPattern(Map<String, String> map) {
        void $this$mapValuesTo$iv$iv;
        Map<String, String> $this$mapValues$iv = map;
        boolean $i$f$mapValues = false;
        Map<String, String> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            String value2 = (String)entry2.getValue();
            Pattern pattern2 = GrammarKt.isPatternToken(value2) ? GrammarKt.parsedPattern$default(value2, null, null, 6, null) : (Pattern)new ExactValuePattern(new StringValue(value2), null, 2, null);
            map4.put(k, pattern2);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void buildKTORRequest(@NotNull HttpRequestBuilder httpRequestBuilder, @Nullable URL url) {
        HttpRequestBuilder $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Triple it;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)httpRequestBuilder, (String)"httpRequestBuilder");
        String string = this.method;
        Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String");
        httpRequestBuilder.setMethod(HttpMethod.Companion.parse(string));
        List<String> listOfExcludedHeaders = HttpRequestKt.listOfExcludedHeaders();
        Map<String, String> map = this.withoutDuplicateHostHeader(this.headers, url);
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            object = destination$iv$iv;
            boolean bl = false;
            String string2 = ((Object)StringsKt.trim((CharSequence)((String)it.getKey()))).toString();
            String string3 = ((Object)StringsKt.trim((CharSequence)((String)it.getKey()))).toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            object.add(new Triple((Object)string2, (Object)string3, (Object)((Object)StringsKt.trim((CharSequence)((String)it.getValue()))).toString()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv = iterator.next();
            it = (Triple)element$iv$iv;
            boolean bl = false;
            String loweredKey = (String)it.component2();
            if (!(!listOfExcludedHeaders.contains(loweredKey))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Triple $i$f$filterTo2 = (Triple)element$iv;
            boolean bl = false;
            String key2 = (String)$i$f$filterTo2.component1();
            String value2 = (String)$i$f$filterTo2.component3();
            UtilsKt.header((HttpMessageBuilder)((HttpMessageBuilder)httpRequestBuilder), (String)key2, (Object)value2);
        }
        URLBuilder it2 = httpRequestBuilder.getUrl();
        boolean bl = false;
        if (it2.getPort() == 0 || it2.getPort() == it2.getProtocol().getDefaultPort()) {
            UtilsKt.header((HttpMessageBuilder)((HttpMessageBuilder)httpRequestBuilder), (String)"Host", (Object)URLBuilderKt.getAuthority((URLBuilder)it2));
        }
        if (!(this.body instanceof NoBodyValue)) {
            void body$iv;
            OutgoingContent outgoingContent;
            Object parameters;
            $this$forEach$iv = httpRequestBuilder;
            if (!this.formFields.isEmpty()) {
                void $this$mapValuesTo$iv$iv;
                Pair[] $this$mapValues$iv = this.formFields;
                boolean $i$f$mapValues = false;
                Pair[] $i$f$filterTo2 = $this$mapValues$iv;
                Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it3;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map2 = destination$iv$iv2;
                    boolean bl2 = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    object = map2;
                    boolean bl3 = false;
                    List list = CollectionsKt.listOf(it3.getValue());
                    object.put(k, list);
                }
                parameters = MapsKt.toList((Map)destination$iv$iv2);
                Collection $this$toTypedArray$iv = (Collection)parameters;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$mapValues$iv = thisCollection$iv.toArray(new Pair[0]);
                outgoingContent = (OutgoingContent)new FormDataContent(ParametersKt.parametersOf((Pair[])Arrays.copyOf($this$mapValues$iv, $this$mapValues$iv.length)));
            } else if (!((Collection)this.multiPartFormData).isEmpty()) {
                outgoingContent = (OutgoingContent)new MultiPartFormDataContent(FormDslKt.formData((Function1)((Function1)new Function1<FormBuilder, Unit>(this){
                    final /* synthetic */ HttpRequest this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull FormBuilder $this$formData) {
                        Intrinsics.checkNotNullParameter((Object)$this$formData, (String)"$this$formData");
                        Iterable $this$forEach$iv = this.this$0.getMultiPartFormData();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            MultiPartFormDataValue value2 = (MultiPartFormDataValue)element$iv;
                            boolean bl = false;
                            value2.addTo($this$formData);
                        }
                    }
                })), null, null, 6, null);
            } else {
                TextContent textContent;
                if (this.headers.containsKey("Content-Type")) {
                    String string4 = this.getBodyString();
                    String string5 = this.headers.get("Content-Type");
                    Intrinsics.checkNotNull((Object)string5, (String)"null cannot be cast to non-null type kotlin.String");
                    textContent = new TextContent(string4, ContentType.Companion.parse(string5), null, 4, null);
                } else {
                    textContent = new TextContent(this.getBodyString(), ContentType.Companion.parse(this.body.getHttpContentType()), null, 4, null);
                }
                outgoingContent = (OutgoingContent)textContent;
            }
            parameters = outgoingContent;
            boolean $i$f$setBody = false;
            void var7_11 = body$iv;
            if (var7_11 instanceof OutgoingContent) {
                $this$setBody$iv.setBody((Object)body$iv);
                $this$setBody$iv.setBodyType(null);
            } else {
                $this$setBody$iv.setBody((Object)body$iv);
                boolean $i$f$typeInfo = false;
                KType kType$iv$iv = Reflection.typeOf(OutgoingContent.class);
                Type reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(OutgoingContent.class), (KType)kType$iv$iv));
            }
        }
    }

    private final Map<String, String> withoutDuplicateHostHeader(Map<String, String> headers2, URL url) {
        if (url == null) {
            return headers2;
        }
        String string = url.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        if (this.isNotIPAddress(string)) {
            return MapsKt.minus(headers2, (Object)"Host");
        }
        return headers2;
    }

    private final boolean isNotIPAddress(String host) {
        return !this.isIPAddress(host) && !Intrinsics.areEqual((Object)host, (Object)"localhost");
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isIPAddress(String host) {
        boolean bl;
        try {
            void $this$mapTo$iv$iv;
            String[] stringArray = new String[]{"."};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)host, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(Integer.parseInt((String)it));
            }
            bl = !((Collection)((List)destination$iv$iv)).isEmpty();
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HttpRequest loadFileContentIntoParts() {
        void $this$mapTo$iv$iv;
        List<MultiPartFormDataValue> parts = this.multiPartFormData;
        Iterable $this$map$iv = parts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MultiPartFormDataValue multiPartFormDataValue;
            void part;
            MultiPartFormDataValue multiPartFormDataValue2 = (MultiPartFormDataValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var12_11 = part;
            if (var12_11 instanceof MultiPartContentValue) {
                multiPartFormDataValue = part;
            } else if (var12_11 instanceof MultiPartFileValue) {
                File partFile = new File(StringsKt.removePrefix((String)((MultiPartFileValue)part).getFilename(), (CharSequence)"@"));
                MultiPartContent binaryContent = partFile.exists() ? new MultiPartContent(partFile) : new MultiPartContent(new StringPattern(null, null, null, null, 15, null).generate(new Resolver()).toStringLiteral());
                multiPartFormDataValue = MultiPartFileValue.copy$default((MultiPartFileValue)part, null, null, null, null, binaryContent, null, 47, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(multiPartFormDataValue);
        }
        List newMultiPartFormData = (List)destination$iv$iv;
        return HttpRequest.copy$default(this, null, null, null, null, null, null, newMultiPartFormData, 63, null);
    }

    @NotNull
    public final String requestNotRecognized(@NotNull RequestNotRecognizedMessages requestNotRecognizedMessages) {
        Intrinsics.checkNotNullParameter((Object)requestNotRecognizedMessages, (String)"requestNotRecognizedMessages");
        String soapActionHeader = "SOAPAction";
        String string = this.method;
        Intrinsics.checkNotNull((Object)string);
        String method = string;
        String string2 = this.path;
        if (string2 == null) {
            string2 = "/";
        }
        String path2 = string2;
        return this.headers.containsKey(soapActionHeader) ? requestNotRecognizedMessages.soap((String)MapsKt.getValue(this.headers, (Object)soapActionHeader), path2) : (this.body instanceof XMLNode ? requestNotRecognizedMessages.xmlOverHttp(method, path2) : requestNotRecognizedMessages.restful(method, path2));
    }

    @NotNull
    public final String requestNotRecognized() {
        return this.requestNotRecognized(new LenientRequestNotRecognizedMessages());
    }

    @NotNull
    public final String requestNotRecognizedInStrictMode() {
        return this.requestNotRecognized(new StrictRequestNotRecognizedMessages());
    }

    @NotNull
    public final HttpRequest withoutDynamicHeaders() {
        return HttpRequest.copy$default(this, null, null, HttpHeadersPatternKt.withoutDynamicHeaders(this.headers), null, null, null, null, 123, null);
    }

    @Nullable
    public final String component1() {
        return this.method;
    }

    @Nullable
    public final String component2() {
        return this.path;
    }

    @NotNull
    public final Map<String, String> component3() {
        return this.headers;
    }

    @NotNull
    public final Value component4() {
        return this.body;
    }

    @NotNull
    public final Map<String, String> component5() {
        return this.queryParams;
    }

    @NotNull
    public final Map<String, String> component6() {
        return this.formFields;
    }

    @NotNull
    public final List<MultiPartFormDataValue> component7() {
        return this.multiPartFormData;
    }

    @NotNull
    public final HttpRequest copy(@Nullable String method, @Nullable String path2, @NotNull Map<String, String> headers2, @NotNull Value body, @NotNull Map<String, String> queryParams2, @NotNull Map<String, String> formFields, @NotNull List<? extends MultiPartFormDataValue> multiPartFormData) {
        Intrinsics.checkNotNullParameter(headers2, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter(queryParams2, (String)"queryParams");
        Intrinsics.checkNotNullParameter(formFields, (String)"formFields");
        Intrinsics.checkNotNullParameter(multiPartFormData, (String)"multiPartFormData");
        return new HttpRequest(method, path2, headers2, body, queryParams2, formFields, multiPartFormData);
    }

    public static /* synthetic */ HttpRequest copy$default(HttpRequest httpRequest, String string, String string2, Map map, Value value2, Map map2, Map map3, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = httpRequest.method;
        }
        if ((n & 2) != 0) {
            string2 = httpRequest.path;
        }
        if ((n & 4) != 0) {
            map = httpRequest.headers;
        }
        if ((n & 8) != 0) {
            value2 = httpRequest.body;
        }
        if ((n & 0x10) != 0) {
            map2 = httpRequest.queryParams;
        }
        if ((n & 0x20) != 0) {
            map3 = httpRequest.formFields;
        }
        if ((n & 0x40) != 0) {
            list = httpRequest.multiPartFormData;
        }
        return httpRequest.copy(string, string2, map, value2, map2, map3, list);
    }

    @NotNull
    public String toString() {
        return "HttpRequest(method=" + this.method + ", path=" + this.path + ", headers=" + this.headers + ", body=" + this.body + ", queryParams=" + this.queryParams + ", formFields=" + this.formFields + ", multiPartFormData=" + this.multiPartFormData + ")";
    }

    public int hashCode() {
        int result2 = this.method == null ? 0 : this.method.hashCode();
        result2 = result2 * 31 + (this.path == null ? 0 : this.path.hashCode());
        result2 = result2 * 31 + ((Object)this.headers).hashCode();
        result2 = result2 * 31 + this.body.hashCode();
        result2 = result2 * 31 + ((Object)this.queryParams).hashCode();
        result2 = result2 * 31 + ((Object)this.formFields).hashCode();
        result2 = result2 * 31 + ((Object)this.multiPartFormData).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpRequest)) {
            return false;
        }
        HttpRequest httpRequest = (HttpRequest)other;
        if (!Intrinsics.areEqual((Object)this.method, (Object)httpRequest.method)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)httpRequest.path)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.headers, httpRequest.headers)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.body, (Object)httpRequest.body)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.queryParams, httpRequest.queryParams)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.formFields, httpRequest.formFields)) {
            return false;
        }
        return Intrinsics.areEqual(this.multiPartFormData, httpRequest.multiPartFormData);
    }

    public HttpRequest() {
        this(null, null, null, null, null, null, null, 127, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lin/specmatic/core/HttpRequest$LenientRequestNotRecognizedMessages;", "Lin/specmatic/core/HttpRequest$RequestNotRecognizedMessages;", "()V", "restful", "", "method", "path", "soap", "soapActionHeaderValue", "xmlOverHttp", "core"})
    public static final class LenientRequestNotRecognizedMessages
    implements RequestNotRecognizedMessages {
        @Override
        @NotNull
        public String soap(@NotNull String soapActionHeaderValue, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)soapActionHeaderValue, (String)"soapActionHeaderValue");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return "No matching SOAP stub or contract found for SOAPAction " + soapActionHeaderValue + " and path " + path2;
        }

        @Override
        @NotNull
        public String xmlOverHttp(@NotNull String method, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return "No matching XML-REST stub or contract found for method " + method + " and path " + path2 + " (assuming you're looking for a REST API since no SOAPAction header was detected)";
        }

        @Override
        @NotNull
        public String restful(@NotNull String method, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return "No matching REST stub or contract found for method " + method + " and path " + path2 + " (assuming you're looking for a REST API since no SOAPAction header was detected)";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&\u00a8\u0006\t"}, d2={"Lin/specmatic/core/HttpRequest$RequestNotRecognizedMessages;", "", "restful", "", "method", "path", "soap", "soapActionHeaderValue", "xmlOverHttp", "core"})
    public static interface RequestNotRecognizedMessages {
        @NotNull
        public String soap(@NotNull String var1, @NotNull String var2);

        @NotNull
        public String xmlOverHttp(@NotNull String var1, @NotNull String var2);

        @NotNull
        public String restful(@NotNull String var1, @NotNull String var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lin/specmatic/core/HttpRequest$StrictRequestNotRecognizedMessages;", "Lin/specmatic/core/HttpRequest$RequestNotRecognizedMessages;", "()V", "restful", "", "method", "path", "soap", "soapActionHeaderValue", "xmlOverHttp", "core"})
    public static final class StrictRequestNotRecognizedMessages
    implements RequestNotRecognizedMessages {
        @Override
        @NotNull
        public String soap(@NotNull String soapActionHeaderValue, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)soapActionHeaderValue, (String)"soapActionHeaderValue");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return "No matching SOAP stub (strict mode) found for SOAPAction " + soapActionHeaderValue + " and path " + path2;
        }

        @Override
        @NotNull
        public String xmlOverHttp(@NotNull String method, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return "No matching XML-REST stub (strict mode) found for method " + method + " and path " + path2 + " (assuming you're looking for a REST API since no SOAPAction header was detected)";
        }

        @Override
        @NotNull
        public String restful(@NotNull String method, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return "No matching REST stub (strict mode) found for method " + method + " and path " + path2 + " (assuming you're looking for a REST API since no SOAPAction header was detected)";
        }
    }
}

