/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.conversions;

import in.specmatic.conversions.OpenAPISecurityScheme;
import in.specmatic.core.HttpRequest;
import in.specmatic.core.HttpRequestPattern;
import in.specmatic.core.QueryParameters;
import in.specmatic.core.Resolver;
import in.specmatic.core.Result;
import in.specmatic.core.pattern.ExactValuePattern;
import in.specmatic.core.pattern.GrammarKt;
import in.specmatic.core.pattern.Pattern;
import in.specmatic.core.pattern.Row;
import in.specmatic.core.pattern.StringPattern;
import in.specmatic.core.value.StringValue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lin/specmatic/conversions/APIKeyInQueryParamSecurityScheme;", "Lin/specmatic/conversions/OpenAPISecurityScheme;", "name", "", "apiKey", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "addTo", "Lin/specmatic/core/HttpRequest;", "httpRequest", "Lin/specmatic/core/HttpRequestPattern;", "requestPattern", "row", "Lin/specmatic/core/pattern/Row;", "isInRow", "", "matches", "Lin/specmatic/core/Result;", "removeParam", "core"})
public final class APIKeyInQueryParamSecurityScheme
implements OpenAPISecurityScheme {
    @NotNull
    private final String name;
    @Nullable
    private final String apiKey;

    public APIKeyInQueryParamSecurityScheme(@NotNull String name, @Nullable String apiKey) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.apiKey = apiKey;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Result matches(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        return httpRequest.getQueryParams().containsKey(this.name) ? (Result)new Result.Success(null, null, 3, null) : (Result)new Result.Failure("API-key named " + this.name + " was not present in query string", null, null, null, 14, null);
    }

    @Override
    @NotNull
    public HttpRequest removeParam(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        return HttpRequest.copy$default(httpRequest, null, null, null, null, httpRequest.getQueryParams().minus(this.name), null, null, 111, null);
    }

    @Override
    @NotNull
    public HttpRequest addTo(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        QueryParameters queryParameters = httpRequest.getQueryParams();
        String string = this.apiKey;
        if (string == null) {
            string = new StringPattern(null, null, null, null, 15, null).generate(new Resolver()).toStringLiteral();
        }
        return HttpRequest.copy$default(httpRequest, null, null, null, null, queryParameters.plus((Pair<String, String>)TuplesKt.to((Object)this.name, (Object)string)), null, null, 111, null);
    }

    @Override
    @NotNull
    public HttpRequestPattern addTo(@NotNull HttpRequestPattern requestPattern, @NotNull Row row) {
        Intrinsics.checkNotNullParameter((Object)requestPattern, (String)"requestPattern");
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        String it = row.getField(this.name);
        boolean bl = false;
        Pattern queryParamValueType = GrammarKt.isPatternToken(it) ? GrammarKt.parsedPattern$default(it, null, null, 6, null) : (Pattern)new ExactValuePattern(new StringValue(it), null, 2, null);
        return HttpRequestPattern.copy$default(requestPattern, null, null, requestPattern.getHttpQueryParamPattern().copy(MapsKt.plus(requestPattern.getHttpQueryParamPattern().getQueryPatterns(), (Pair)TuplesKt.to((Object)this.name, (Object)queryParamValueType))), null, null, null, null, null, 251, null);
    }

    @Override
    public boolean isInRow(@NotNull Row row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        return row.containsField(this.name);
    }
}

