/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core;

import in.specmatic.core.FailureReason;
import in.specmatic.core.MultiPartFileValue;
import in.specmatic.core.MultiPartFormDataPattern;
import in.specmatic.core.MultiPartFormDataValue;
import in.specmatic.core.Resolver;
import in.specmatic.core.Result;
import in.specmatic.core.pattern.ExactValuePattern;
import in.specmatic.core.pattern.GrammarKt;
import in.specmatic.core.pattern.Pattern;
import in.specmatic.core.pattern.Row;
import in.specmatic.core.value.StringValue;
import in.specmatic.core.value.Value;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J5\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010)\u001a\u00020\u0001H\u0016J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006+"}, d2={"Lin/specmatic/core/MultiPartFilePattern;", "Lin/specmatic/core/MultiPartFormDataPattern;", "name", "", "filename", "Lin/specmatic/core/pattern/Pattern;", "contentType", "contentEncoding", "(Ljava/lang/String;Lin/specmatic/core/pattern/Pattern;Ljava/lang/String;Ljava/lang/String;)V", "getContentEncoding", "()Ljava/lang/String;", "getContentType", "getFilename", "()Lin/specmatic/core/pattern/Pattern;", "getName", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "fileContentMismatch", "value", "Lin/specmatic/core/MultiPartFileValue;", "resolver", "Lin/specmatic/core/Resolver;", "fileContentMismatchError", "Lin/specmatic/core/Result$Failure;", "generate", "Lin/specmatic/core/MultiPartFormDataValue;", "hashCode", "", "matches", "Lin/specmatic/core/Result;", "newBasedOn", "", "row", "Lin/specmatic/core/pattern/Row;", "nonOptional", "toString", "core"})
@SourceDebugExtension(value={"SMAP\nMultiPartFormDataPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiPartFormDataPattern.kt\nin/specmatic/core/MultiPartFilePattern\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class MultiPartFilePattern
extends MultiPartFormDataPattern {
    @NotNull
    private final String name;
    @NotNull
    private final Pattern filename;
    @Nullable
    private final String contentType;
    @Nullable
    private final String contentEncoding;

    public MultiPartFilePattern(@NotNull String name, @NotNull Pattern filename, @Nullable String contentType, @Nullable String contentEncoding) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        super(name, contentType, null);
        this.name = name;
        this.filename = filename;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
    }

    public /* synthetic */ MultiPartFilePattern(String string, Pattern pattern2, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        this(string, pattern2, string2, string3);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final Pattern getFilename() {
        return this.filename;
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    @Nullable
    public final String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    @NotNull
    public List<MultiPartFormDataPattern> newBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        String rowKey = this.getName() + "_filename";
        return CollectionsKt.listOf((Object)MultiPartFilePattern.copy$default(this, null, row.containsField(rowKey) ? (Pattern)new ExactValuePattern(new StringValue(row.getField(rowKey)), null, 2, null) : this.filename, null, null, 13, null));
    }

    @Override
    @NotNull
    public MultiPartFormDataValue generate(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        String string = this.getName();
        String string2 = ((Value)resolver.withCyclePrevention(this.filename, (Function1)new Function1<Resolver, Value>((Object)this.filename){

            @NotNull
            public final Value invoke(@NotNull Resolver p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Pattern)this.receiver).generate(p0);
            }
        })).toStringLiteral();
        String string3 = this.getContentType();
        if (string3 == null) {
            string3 = "";
        }
        return new MultiPartFileValue(string, string2, string3, this.contentEncoding, null, null, 48, null);
    }

    @Override
    @NotNull
    public Result matches(@NotNull MultiPartFormDataValue value2, @NotNull Resolver resolver) {
        Result result2;
        block3: {
            block6: {
                Object object;
                String contentEncodingMessage;
                block8: {
                    block7: {
                        block5: {
                            block4: {
                                block2: {
                                    Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                                    Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
                                    if (value2 instanceof MultiPartFileValue) break block2;
                                    result2 = new Result.Failure("The contract expected a file, but got content instead.", null, null, null, 14, null);
                                    break block3;
                                }
                                if (Intrinsics.areEqual((Object)this.getName(), (Object)value2.getName())) break block4;
                                result2 = new Result.Failure("The contract expected a part name to be " + this.getName() + ", but got " + value2.getName() + ".", null, null, FailureReason.PartNameMisMatch, 6, null);
                                break block3;
                            }
                            if (!this.fileContentMismatch((MultiPartFileValue)value2, resolver)) break block5;
                            result2 = this.fileContentMismatchError((MultiPartFileValue)value2, resolver);
                            break block3;
                        }
                        if (this.contentEncoding == null || Intrinsics.areEqual((Object)((MultiPartFileValue)value2).getContentEncoding(), (Object)this.contentEncoding)) break block6;
                        String it = this.contentEncoding;
                        boolean bl = false;
                        contentEncodingMessage = "content encoding " + this.contentEncoding;
                        object = ((MultiPartFileValue)value2).getContentEncoding();
                        if (object == null) break block7;
                        String it2 = object;
                        boolean bl2 = false;
                        String string = "content encoding " + ((MultiPartFileValue)value2).getContentEncoding();
                        object = string;
                        if (string != null) break block8;
                    }
                    object = "no content encoding";
                }
                String receivedContentEncodingMessage = object;
                result2 = new Result.Failure("The contract expected " + contentEncodingMessage + ", but got " + receivedContentEncodingMessage + ".", null, "contentEncoding", null, 10, null);
                break block3;
            }
            result2 = new Result.Success(null, null, 3, null);
        }
        return result2;
    }

    private final Result.Failure fileContentMismatchError(MultiPartFileValue value2, Resolver resolver) {
        Result.Failure failure;
        if (this.filename instanceof ExactValuePattern) {
            failure = new Result.Failure("In the part named " + this.getName() + ", the contents in request did not match the value in file " + ((ExactValuePattern)this.filename).getPattern().toStringLiteral(), null, null, FailureReason.PartNameMisMatch, 6, null);
        } else {
            String string = "In the part named " + this.getName() + ", the contract expected the filename to be " + this.filename.getTypeName() + ", but got " + value2.getFilename() + ".";
            FailureReason failureReason = FailureReason.PartNameMisMatch;
            Result result2 = this.filename.matches(new StringValue(value2.getFilename()), resolver);
            Intrinsics.checkNotNull((Object)result2, (String)"null cannot be cast to non-null type in.specmatic.core.Result.Failure");
            Result.Failure failure2 = (Result.Failure)result2;
            failure = new Result.Failure(string, failure2, null, failureReason, 4, null);
        }
        return failure;
    }

    private final boolean fileContentMismatch(MultiPartFileValue value2, Resolver resolver) {
        boolean bl;
        if (this.filename instanceof ExactValuePattern) {
            File file;
            String patternFilePath = ((ExactValuePattern)this.filename).getPattern().toStringLiteral();
            File it = file = new File(patternFilePath).getCanonicalFile();
            boolean bl2 = false;
            if (!it.exists()) {
                System.out.println((Object)(it.getCanonicalFile().getPath() + " does not exist"));
                throw new Exception(it.getCanonicalFile().getPath() + " does not exist");
            }
            File file2 = file;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"also(...)");
            byte[] bytes = FilesKt.readBytes((File)file2);
            byte[] contentBytes = value2.getContent().getBytes();
            bl = !Arrays.equals(bytes, contentBytes);
        } else {
            bl = !this.filename.matches(new StringValue(value2.getFilename()), resolver).isSuccess();
        }
        return bl;
    }

    @Override
    @NotNull
    public MultiPartFormDataPattern nonOptional() {
        return MultiPartFilePattern.copy$default(this, GrammarKt.withoutOptionality(this.getName()), null, null, null, 14, null);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Pattern component2() {
        return this.filename;
    }

    @Nullable
    public final String component3() {
        return this.contentType;
    }

    @Nullable
    public final String component4() {
        return this.contentEncoding;
    }

    @NotNull
    public final MultiPartFilePattern copy(@NotNull String name, @NotNull Pattern filename, @Nullable String contentType, @Nullable String contentEncoding) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return new MultiPartFilePattern(name, filename, contentType, contentEncoding);
    }

    public static /* synthetic */ MultiPartFilePattern copy$default(MultiPartFilePattern multiPartFilePattern, String string, Pattern pattern2, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = multiPartFilePattern.name;
        }
        if ((n & 2) != 0) {
            pattern2 = multiPartFilePattern.filename;
        }
        if ((n & 4) != 0) {
            string2 = multiPartFilePattern.contentType;
        }
        if ((n & 8) != 0) {
            string3 = multiPartFilePattern.contentEncoding;
        }
        return multiPartFilePattern.copy(string, pattern2, string2, string3);
    }

    @NotNull
    public String toString() {
        return "MultiPartFilePattern(name=" + this.name + ", filename=" + this.filename + ", contentType=" + this.contentType + ", contentEncoding=" + this.contentEncoding + ")";
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + this.filename.hashCode();
        result2 = result2 * 31 + (this.contentType == null ? 0 : this.contentType.hashCode());
        result2 = result2 * 31 + (this.contentEncoding == null ? 0 : this.contentEncoding.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MultiPartFilePattern)) {
            return false;
        }
        MultiPartFilePattern multiPartFilePattern = (MultiPartFilePattern)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)multiPartFilePattern.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.filename, (Object)multiPartFilePattern.filename)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contentType, (Object)multiPartFilePattern.contentType)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.contentEncoding, (Object)multiPartFilePattern.contentEncoding);
    }
}

