/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.log;

import in.specmatic.core.log.CompositePrinter;
import in.specmatic.core.log.LogMessage;
import in.specmatic.core.log.LogStrategy;
import in.specmatic.core.log.NewLineLogMessage;
import in.specmatic.core.log.NonVerboseExceptionLog;
import in.specmatic.core.log.ReadyMessage;
import in.specmatic.core.log.StringLog;
import in.specmatic.core.utilities.Utilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\rH\u0016J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\rH\u0016J\u001a\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016J\u001a\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\rH\u0016J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lin/specmatic/core/log/NonVerbose;", "Lin/specmatic/core/log/LogStrategy;", "printer", "Lin/specmatic/core/log/CompositePrinter;", "(Lin/specmatic/core/log/CompositePrinter;)V", "getPrinter", "()Lin/specmatic/core/log/CompositePrinter;", "readyMessage", "Lin/specmatic/core/log/ReadyMessage;", "debug", "", "msg", "Lin/specmatic/core/log/LogMessage;", "", "e", "", "exceptionString", "keepReady", "log", "logError", "newLine", "ofTheException", "print", "core"})
public final class NonVerbose
implements LogStrategy {
    @NotNull
    private final CompositePrinter printer;
    @NotNull
    private final ReadyMessage readyMessage;

    public NonVerbose(@NotNull CompositePrinter printer) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        this.printer = printer;
        this.readyMessage = new ReadyMessage(null, 1, null);
    }

    @Override
    @NotNull
    public CompositePrinter getPrinter() {
        return this.printer;
    }

    @Override
    public void keepReady(@NotNull LogMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.readyMessage.setMsg(msg);
    }

    public final void print(@NotNull LogMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.readyMessage.printLogString(this.getPrinter());
        this.getPrinter().print(msg);
    }

    @Override
    @NotNull
    public String exceptionString(@NotNull Throwable e, @Nullable String msg) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return msg == null ? Utilities.exceptionCauseMessage(e) : msg + ": " + Utilities.exceptionCauseMessage(e);
    }

    @Override
    @NotNull
    public LogMessage ofTheException(@NotNull Throwable e, @Nullable String msg) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new NonVerboseExceptionLog(e, msg);
    }

    @Override
    public void log(@NotNull Throwable e, @Nullable String msg) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.print(new NonVerboseExceptionLog(e, msg));
    }

    @Override
    public void log(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.log(new StringLog(msg));
    }

    @Override
    public void log(@NotNull LogMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.print(msg);
    }

    @Override
    public void logError(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.log(e, "ERROR");
    }

    @Override
    public void newLine() {
        this.print(NewLineLogMessage.INSTANCE);
    }

    @Override
    @NotNull
    public String debug(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        return msg;
    }

    @Override
    public void debug(@NotNull LogMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
    }

    @Override
    public void debug(@NotNull Throwable e, @Nullable String msg) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }
}

