/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.value;

import in.specmatic.core.ExampleDeclarations;
import in.specmatic.core.pattern.DeferredPattern;
import in.specmatic.core.pattern.JSONObjectPattern;
import in.specmatic.core.pattern.JSONObjectPatternKt;
import in.specmatic.core.pattern.Pattern;
import in.specmatic.core.pattern.TabularPattern;
import in.specmatic.core.pattern.TabularPatternKt;
import in.specmatic.core.utilities.JSONSerialisationKt;
import in.specmatic.core.utilities.Utilities;
import in.specmatic.core.value.BooleanValue;
import in.specmatic.core.value.JSONArrayValue;
import in.specmatic.core.value.JSONComposite;
import in.specmatic.core.value.JSONObjectValueKt;
import in.specmatic.core.value.NumberValue;
import in.specmatic.core.value.StringValue;
import in.specmatic.core.value.TypeDeclaration;
import in.specmatic.core.value.Value;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0014\b\u0002\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\u0014\b\u0002\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004H\u00c6\u0001J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0017\u001a\u00020\u0005J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0019\u001a\u00020\u0005J \u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001a\u001a\u00020\u00052\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cH\u0002J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0005J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0005J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u0005J\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u001e\u001a\u00020\u0005J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0005J\u000e\u0010$\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005J\t\u0010%\u001a\u00020 H\u00d6\u0001J\u0016\u0010&\u001a\u00020\u00012\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00010\u001cH\u0016J\b\u0010(\u001a\u00020\u0005H\u0016J\b\u0010)\u001a\u00020\u0005H\u0016J\u0006\u0010*\u001a\u00020\u0005J\b\u0010+\u001a\u00020\u0015H\u0016J8\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-2\u0006\u0010\u001e\u001a\u00020\u00052\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u00042\u0006\u00101\u001a\u00020/H\u0016J8\u00102\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-2\u0006\u00103\u001a\u00020\u00052\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u00042\u0006\u00101\u001a\u00020/H\u0016J\b\u00104\u001a\u00020\u0005H\u0016R\u0014\u0010\u0007\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00065"}, d2={"Lin/specmatic/core/value/JSONObjectValue;", "Lin/specmatic/core/value/Value;", "Lin/specmatic/core/value/JSONComposite;", "jsonObject", "", "", "(Ljava/util/Map;)V", "httpContentType", "getHttpContentType", "()Ljava/lang/String;", "getJsonObject", "()Ljava/util/Map;", "component1", "copy", "displayableType", "displayableValue", "equals", "", "other", "", "exactMatchElseType", "Lin/specmatic/core/pattern/Pattern;", "findFirstChildByName", "name", "findFirstChildByPath", "path", "first", "rest", "", "getBoolean", "key", "getInt", "", "getJSONArray", "getJSONObject", "getJSONObjectValue", "getString", "hashCode", "listOf", "valueList", "toString", "toStringLiteral", "toUnformattedStringLiteral", "type", "typeDeclarationWithKey", "Lkotlin/Pair;", "Lin/specmatic/core/value/TypeDeclaration;", "Lin/specmatic/core/ExampleDeclarations;", "types", "exampleDeclarations", "typeDeclarationWithoutKey", "exampleKey", "valueErrorSnippet", "core"})
@SourceDebugExtension(value={"SMAP\nJSONObjectValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSONObjectValue.kt\nin/specmatic/core/value/JSONObjectValue\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n453#2:100\n403#2:101\n453#2:106\n403#2:107\n1238#3,4:102\n1238#3,4:108\n*S KotlinDebug\n*F\n+ 1 JSONObjectValue.kt\nin/specmatic/core/value/JSONObjectValue\n*L\n18#1:100\n18#1:101\n26#1:106\n26#1:107\n18#1:102,4\n26#1:108,4\n*E\n"})
public final class JSONObjectValue
implements Value,
JSONComposite {
    @NotNull
    private final Map<String, Value> jsonObject;
    @NotNull
    private final String httpContentType;

    public JSONObjectValue(@NotNull Map<String, ? extends Value> jsonObject) {
        Intrinsics.checkNotNullParameter(jsonObject, (String)"jsonObject");
        this.jsonObject = jsonObject;
        this.httpContentType = "application/json";
    }

    public /* synthetic */ JSONObjectValue(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        this(map);
    }

    @NotNull
    public final Map<String, Value> getJsonObject() {
        return this.jsonObject;
    }

    @Override
    @NotNull
    public String getHttpContentType() {
        return this.httpContentType;
    }

    @Override
    @NotNull
    public String valueErrorSnippet() {
        return "JSON object " + this.displayableValue();
    }

    @Override
    @NotNull
    public String displayableValue() {
        return this.toStringLiteral();
    }

    @Override
    @NotNull
    public String toStringLiteral() {
        return JSONSerialisationKt.valueMapToPrettyJsonString(this.jsonObject);
    }

    @NotNull
    public final String toUnformattedStringLiteral() {
        return JSONSerialisationKt.valueMapToUnindentedJsonString(this.jsonObject);
    }

    @Override
    @NotNull
    public String displayableType() {
        return "json object";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pattern exactMatchElseType() {
        void $this$mapValuesTo$iv$iv;
        Map<String, Value> $this$mapValues$iv = this.jsonObject;
        boolean $i$f$mapValues = false;
        Map<String, Value> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Pattern pattern2 = ((Value)it.getValue()).exactMatchElseType();
            map3.put(k, pattern2);
        }
        return JSONObjectPatternKt.toJSONObjectPattern$default(destination$iv$iv, null, 2, null);
    }

    @Override
    @NotNull
    public Pattern type() {
        return new JSONObjectPattern(null, null, null, null, null, 31, null);
    }

    @NotNull
    public String toString() {
        return JSONSerialisationKt.valueMapToPrettyJsonString(this.jsonObject);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pair<TypeDeclaration, ExampleDeclarations> typeDeclarationWithKey(@NotNull String key2, @NotNull Map<String, ? extends Pattern> types, @NotNull ExampleDeclarations exampleDeclarations) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)exampleDeclarations, (String)"exampleDeclarations");
        Triple<Map<String, DeferredPattern>, Map<String, Pattern>, ExampleDeclarations> triple = JSONObjectValueKt.dictionaryToDeclarations(this.jsonObject, types, exampleDeclarations);
        Map jsonTypeMap = (Map)triple.component1();
        Map newTypes = (Map)triple.component2();
        ExampleDeclarations newExamples = (ExampleDeclarations)triple.component3();
        Map $this$mapValues$iv = jsonTypeMap;
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            DeferredPattern deferredPattern = new DeferredPattern(((DeferredPattern)it.getValue()).getPattern(), null, 2, null);
            map3.put(k, deferredPattern);
        }
        TabularPattern newType = TabularPatternKt.toTabularPattern$default(destination$iv$iv, null, 2, null);
        String newTypeName = exampleDeclarations.getNewName(Utilities.capitalizeFirstChar(key2), newTypes.keySet());
        TypeDeclaration typeDeclaration = new TypeDeclaration("(" + newTypeName + ")", MapsKt.plus((Map)newTypes, (Pair)TuplesKt.to((Object)newTypeName, (Object)newType)));
        return new Pair((Object)typeDeclaration, (Object)newExamples);
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList) {
        Intrinsics.checkNotNullParameter(valueList, (String)"valueList");
        return new JSONArrayValue(valueList);
    }

    @Override
    @NotNull
    public Pair<TypeDeclaration, ExampleDeclarations> typeDeclarationWithoutKey(@NotNull String exampleKey, @NotNull Map<String, ? extends Pattern> types, @NotNull ExampleDeclarations exampleDeclarations) {
        Intrinsics.checkNotNullParameter((Object)exampleKey, (String)"exampleKey");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)exampleDeclarations, (String)"exampleDeclarations");
        return this.typeDeclarationWithKey(exampleKey, types, exampleDeclarations);
    }

    @NotNull
    public final String getString(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Object object = MapsKt.getValue(this.jsonObject, (Object)key2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type in.specmatic.core.value.StringValue");
        return ((StringValue)object).getString();
    }

    public final boolean getBoolean(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Object object = MapsKt.getValue(this.jsonObject, (Object)key2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type in.specmatic.core.value.BooleanValue");
        return ((BooleanValue)object).getBooleanValue();
    }

    public final int getInt(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Object object = MapsKt.getValue(this.jsonObject, (Object)key2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type in.specmatic.core.value.NumberValue");
        return ((NumberValue)object).getNumber().intValue();
    }

    @NotNull
    public final Map<String, Value> getJSONObject(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Object object = MapsKt.getValue(this.jsonObject, (Object)key2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type in.specmatic.core.value.JSONObjectValue");
        return ((JSONObjectValue)object).jsonObject;
    }

    @NotNull
    public final JSONObjectValue getJSONObjectValue(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Object object = MapsKt.getValue(this.jsonObject, (Object)key2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type in.specmatic.core.value.JSONObjectValue");
        return (JSONObjectValue)object;
    }

    @NotNull
    public final List<Value> getJSONArray(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Object object = MapsKt.getValue(this.jsonObject, (Object)key2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type in.specmatic.core.value.JSONArrayValue");
        return ((JSONArrayValue)object).getList();
    }

    @Nullable
    public final Value findFirstChildByPath(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String[] stringArray = new String[]{"."};
        return this.findFirstChildByPath(StringsKt.split$default((CharSequence)path2, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    private final Value findFirstChildByPath(List<String> path2) {
        return this.findFirstChildByPath((String)CollectionsKt.first(path2), CollectionsKt.drop((Iterable)path2, (int)1));
    }

    private final Value findFirstChildByPath(String first, List<String> rest2) {
        Value value2;
        Value value3 = this.findFirstChildByName(first);
        if (value3 != null) {
            Value it = value3;
            boolean bl = false;
            value2 = rest2.isEmpty() ? it : (it instanceof JSONObjectValue ? ((JSONObjectValue)it).findFirstChildByPath(rest2) : null);
        } else {
            value2 = null;
        }
        return value2;
    }

    @Nullable
    public final Value findFirstChildByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.jsonObject.get(name);
    }

    @Override
    @NotNull
    public StringValue toStringValue() {
        return Value.DefaultImpls.toStringValue(this);
    }

    @NotNull
    public final Map<String, Value> component1() {
        return this.jsonObject;
    }

    @NotNull
    public final JSONObjectValue copy(@NotNull Map<String, ? extends Value> jsonObject) {
        Intrinsics.checkNotNullParameter(jsonObject, (String)"jsonObject");
        return new JSONObjectValue(jsonObject);
    }

    public static /* synthetic */ JSONObjectValue copy$default(JSONObjectValue jSONObjectValue, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = jSONObjectValue.jsonObject;
        }
        return jSONObjectValue.copy(map);
    }

    public int hashCode() {
        return ((Object)this.jsonObject).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JSONObjectValue)) {
            return false;
        }
        JSONObjectValue jSONObjectValue = (JSONObjectValue)other;
        return Intrinsics.areEqual(this.jsonObject, jSONObjectValue.jsonObject);
    }

    public JSONObjectValue() {
        this(null, 1, null);
    }
}

