/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.git;

import in.specmatic.core.Configuration;
import in.specmatic.core.azure.AzureAuthCredentials;
import in.specmatic.core.git.InsecureHttpConnectionFactory;
import in.specmatic.core.git.SystemGit;
import in.specmatic.core.log.LogStrategy;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.pattern.GrammarKt;
import in.specmatic.core.utilities.GitRepo;
import in.specmatic.core.utilities.Utilities;
import in.specmatic.core.value.JSONObjectValue;
import in.specmatic.core.value.Value;
import io.ktor.http.CodecsKt;
import java.io.File;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.transport.http.HttpConnectionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0003H\u0002\u001a\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u001a\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u001a\n\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\n\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\n\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0003H\u0002\u001a \u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015\u001a\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0012H\u0002\u001a\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0003H\u0002\u00a8\u0006\u001c"}, d2={"checkout", "", "workingDirectory", "Ljava/io/File;", "branchName", "", "clone", "gitRepo", "Lin/specmatic/core/utilities/GitRepo;", "gitRepositoryURI", "cloneDirectory", "getBearerToken", "getPersonalAccessToken", "getPersonalAccessTokenConfig", "getPersonalAccessTokenEnvVariable", "getPersonalAccessTokenProperty", "jgitClone", "loadFromPath", "Lin/specmatic/core/value/Value;", "json", "path", "", "readBearerFromEnvVariable", "config", "readBearerFromFile", "readConfig", "configFile", "resetCloneDirectory", "core"})
@JvmName(name="GitOperations")
public final class GitOperations {
    @NotNull
    public static final File clone(@NotNull File workingDirectory, @NotNull GitRepo gitRepo) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)gitRepo, (String)"gitRepo");
        File cloneDirectory = gitRepo.directoryRelativeTo(workingDirectory);
        GitOperations.resetCloneDirectory(cloneDirectory);
        GitOperations.clone(gitRepo.getGitRepositoryURL(), cloneDirectory);
        return cloneDirectory;
    }

    public static final void checkout(@NotNull File workingDirectory, @NotNull String branchName) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        LoggingKt.getLogger().log("Checking out branch: " + branchName);
        try {
            String string = workingDirectory.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            new SystemGit(string, null, null, 6, null).checkout(branchName);
        }
        catch (Exception exception) {
            LoggingKt.getLogger().debug("Could not checkout branch " + branchName);
            LogStrategy logStrategy = LoggingKt.getLogger();
            String string = exception.getLocalizedMessage();
            if (string == null && (string = exception.getMessage()) == null) {
                string = "";
            }
            logStrategy.debug(string);
            LoggingKt.getLogger().debug(ExceptionsKt.stackTraceToString((Throwable)exception));
        }
    }

    private static final void clone(String gitRepositoryURI, File cloneDirectory) {
        try {
            String string = cloneDirectory.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParent(...)");
            new SystemGit(string, "-", AzureAuthCredentials.INSTANCE).clone(gitRepositoryURI, cloneDirectory);
        }
        catch (Exception exception) {
            LoggingKt.getLogger().debug("Falling back to jgit after trying shallow clone");
            LogStrategy logStrategy = LoggingKt.getLogger();
            String string = exception.getLocalizedMessage();
            if (string == null && (string = exception.getMessage()) == null) {
                string = "";
            }
            logStrategy.debug(string);
            LoggingKt.getLogger().debug(ExceptionsKt.stackTraceToString((Throwable)exception));
            GitOperations.jgitClone(gitRepositoryURI, cloneDirectory);
        }
    }

    private static final void resetCloneDirectory(File cloneDirectory) {
        LoggingKt.getLogger().log("Resetting " + cloneDirectory.getAbsolutePath());
        if (cloneDirectory.exists()) {
            FilesKt.deleteRecursively((File)cloneDirectory);
        }
        cloneDirectory.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void jgitClone(String gitRepositoryURI, File cloneDirectory) {
        HttpConnectionFactory httpConnectionFactory = HttpTransport.getConnectionFactory();
        Intrinsics.checkNotNullExpressionValue((Object)httpConnectionFactory, (String)"getConnectionFactory(...)");
        HttpConnectionFactory preservedConnectionFactory = httpConnectionFactory;
        try {
            CloneCommand cloneCommand;
            HttpTransport.setConnectionFactory((HttpConnectionFactory)new InsecureHttpConnectionFactory());
            CloneCommand $this$jgitClone_u24lambda_u240 = cloneCommand = Git.cloneRepository();
            boolean bl = false;
            $this$jgitClone_u24lambda_u240.setTransportConfigCallback(Utilities.getTransportCallingCallback$default(null, 1, null));
            $this$jgitClone_u24lambda_u240.setURI(gitRepositoryURI);
            $this$jgitClone_u24lambda_u240.setDirectory(cloneDirectory);
            CloneCommand cloneCommand2 = cloneCommand;
            String accessTokenText = GitOperations.getPersonalAccessToken();
            if (accessTokenText != null) {
                CredentialsProvider credentialsProvider = (CredentialsProvider)new UsernamePasswordCredentialsProvider(accessTokenText, "");
                cloneCommand2.setCredentialsProvider(credentialsProvider);
            } else {
                String ciBearerToken = GitOperations.getBearerToken();
                if (ciBearerToken != null) {
                    cloneCommand2.setTransportConfigCallback(Utilities.getTransportCallingCallback(CodecsKt.encodeOAuth((String)ciBearerToken)));
                }
            }
            LoggingKt.getLogger().log("Cloning: " + gitRepositoryURI + " -> " + cloneDirectory.getCanonicalPath());
            cloneCommand2.call();
        }
        finally {
            HttpTransport.setConnectionFactory((HttpConnectionFactory)preservedConnectionFactory);
        }
    }

    @Nullable
    public static final Value loadFromPath(@Nullable Value json2, @NotNull List<String> path2) {
        Intrinsics.checkNotNullParameter(path2, (String)"path");
        if (!(json2 instanceof JSONObjectValue)) {
            return null;
        }
        return switch (path2.size()) {
            case 0 -> null;
            case 1 -> ((JSONObjectValue)json2).getJsonObject().get(CollectionsKt.first(path2));
            default -> GitOperations.loadFromPath(((JSONObjectValue)json2).getJsonObject().get(CollectionsKt.first(path2)), CollectionsKt.drop((Iterable)path2, (int)1));
        };
    }

    @Nullable
    public static final String getBearerToken() {
        String string;
        File specmaticConfigFile = new File(Configuration.Companion.getGlobalConfigFileName());
        if (specmaticConfigFile.exists()) {
            Value config = GitOperations.readConfig(specmaticConfigFile);
            boolean bl = false;
            string = GitOperations.readBearerFromEnvVariable(config);
            if (string == null) {
                string = GitOperations.readBearerFromFile(config);
            }
        } else {
            Object var1_5;
            Object it = var1_5 = null;
            boolean bl = false;
            LoggingKt.getLogger().log(Configuration.Companion.getGlobalConfigFileName() + " not found");
            LoggingKt.getLogger().log("Current working directory is " + new File(".").getAbsolutePath());
            string = var1_5;
        }
        return string;
    }

    private static final String readBearerFromEnvVariable(Value config) {
        String string;
        Object[] objectArray = new String[]{"auth", "bearer-environment-variable"};
        Object object = GitOperations.loadFromPath(config, CollectionsKt.listOf((Object[])objectArray));
        if (object != null && (object = object.toStringLiteral()) != null) {
            String string2;
            Object bearerName = object;
            boolean bl = false;
            LoggingKt.getLogger().log("Found bearer environment variable name \"" + (String)bearerName + "\"");
            String it = string2 = System.getenv((String)bearerName);
            boolean bl2 = false;
            if (it == null) {
                LoggingKt.getLogger().log((String)bearerName + " environment variable has not been set");
            }
            string = string2;
        } else {
            string = null;
        }
        return string;
    }

    private static final String readBearerFromFile(Value config) {
        String string;
        Object[] objectArray = new String[]{"auth", "bearer-file"};
        Object object = GitOperations.loadFromPath(config, CollectionsKt.listOf((Object[])objectArray));
        if (object != null && (object = object.toStringLiteral()) != null) {
            Object bearerFileName = object;
            boolean bl = false;
            LoggingKt.getLogger().log("Found bearer file name " + (String)bearerFileName);
            File bearerFile = new File((String)bearerFileName).getAbsoluteFile();
            if (bearerFile.exists()) {
                LoggingKt.getLogger().log("Found bearer file " + bearerFile.getAbsolutePath());
                Intrinsics.checkNotNull((Object)bearerFile);
                string = ((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)bearerFile, null, (int)1, null))).toString();
            } else {
                LoggingKt.getLogger().log("Could not find bearer file " + bearerFile.getAbsolutePath());
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final String getPersonalAccessToken() {
        String string = GitOperations.getPersonalAccessTokenProperty();
        if (string == null && (string = GitOperations.getPersonalAccessTokenEnvVariable()) == null) {
            string = GitOperations.getPersonalAccessTokenConfig();
        }
        return string;
    }

    private static final String getPersonalAccessTokenConfig() {
        File homeDir = new File(System.getProperty("user.home"));
        File configFile = FilesKt.resolve((File)homeDir, (String)"specmatic-azure.json");
        if (configFile.exists()) {
            Value config = GitOperations.readConfig(configFile);
            String azureAccessTokenKey = "azure-access-token";
            boolean bl = false;
            if (config instanceof JSONObjectValue && ((JSONObjectValue)config).getJsonObject().containsKey(azureAccessTokenKey)) {
                String string;
                String it = string = ((JSONObjectValue)config).getString(azureAccessTokenKey);
                boolean bl2 = false;
                System.out.println((Object)"Using personal access token from home directory config");
                return string;
            }
            azureAccessTokenKey = "personal-access-token";
            boolean bl3 = false;
            if (config instanceof JSONObjectValue && ((JSONObjectValue)config).getJsonObject().containsKey(azureAccessTokenKey)) {
                String string;
                String it = string = ((JSONObjectValue)config).getString(azureAccessTokenKey);
                boolean bl4 = false;
                System.out.println((Object)"Using personal access token from home directory config");
                return string;
            }
        }
        return null;
    }

    private static final String getPersonalAccessTokenEnvVariable() {
        String string;
        String environmentVariableName = "PERSONAL_ACCESS_TOKEN";
        String string2 = System.getenv(environmentVariableName);
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            System.out.println((Object)"Using personal access token from environment variable");
            string = string3;
        } else {
            string = null;
        }
        return string;
    }

    private static final String getPersonalAccessTokenProperty() {
        String string;
        String accessTokenVariableName = "personalAccessToken";
        String string2 = System.getProperty(accessTokenVariableName);
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            System.out.println((Object)"Using personal access token from property");
            string = string3;
        } else {
            string = null;
        }
        return string;
    }

    private static final Value readConfig(File configFile) {
        return GrammarKt.parsedJSON$default(FilesKt.readText$default((File)configFile, null, (int)1, null), null, 2, null);
    }
}

