/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.pattern;

import in.specmatic.core.MismatchMessages;
import in.specmatic.core.Resolver;
import in.specmatic.core.Result;
import in.specmatic.core.pattern.ConsumeResult;
import in.specmatic.core.pattern.CsvPattern;
import in.specmatic.core.pattern.PairOfTypes;
import in.specmatic.core.pattern.Pattern;
import in.specmatic.core.pattern.Row;
import in.specmatic.core.pattern.StringPattern;
import in.specmatic.core.utilities.Utilities;
import in.specmatic.core.value.JSONArrayValue;
import in.specmatic.core.value.StringValue;
import in.specmatic.core.value.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J2\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u001e\u0010\u0019\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u001a\u0010\u001c\u001a\u00020\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f2\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u0018\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\b\u0010%\u001a\u00020\u0007H\u0016R\u0014\u0010\u0002\u001a\u00020\u0001X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006&"}, d2={"Lin/specmatic/core/pattern/CsvPattern;", "Lin/specmatic/core/pattern/Pattern;", "pattern", "(Lin/specmatic/core/pattern/Pattern;)V", "getPattern", "()Lin/specmatic/core/pattern/Pattern;", "typeAlias", "", "getTypeAlias", "()Ljava/lang/String;", "typeName", "getTypeName", "encompasses", "Lin/specmatic/core/Result;", "otherPattern", "thisResolver", "Lin/specmatic/core/Resolver;", "otherResolver", "typeStack", "", "Lin/specmatic/core/pattern/PairOfTypes;", "Lin/specmatic/core/pattern/TypeStack;", "generate", "Lin/specmatic/core/value/Value;", "resolver", "listOf", "valueList", "", "matches", "sampleData", "negativeBasedOn", "Lkotlin/sequences/Sequence;", "row", "Lin/specmatic/core/pattern/Row;", "newBasedOn", "parse", "value", "toString", "core"})
@SourceDebugExtension(value={"SMAP\nCsvPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CsvPattern.kt\nin/specmatic/core/pattern/CsvPattern\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1559#2:77\n1590#2,4:78\n1549#2:82\n1620#2,3:83\n*S KotlinDebug\n*F\n+ 1 CsvPattern.kt\nin/specmatic/core/pattern/CsvPattern\n*L\n15#1:77\n15#1:78,4\n30#1:82\n30#1:83,3\n*E\n"})
public final class CsvPattern
implements Pattern {
    @NotNull
    private final Pattern pattern;

    public CsvPattern(@NotNull Pattern pattern2) {
        Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
        this.pattern = pattern2;
    }

    @Override
    @NotNull
    public Pattern getPattern() {
        return this.pattern;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result matches(@Nullable Value sampleData, @NotNull Resolver resolver) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        if (!(sampleData instanceof StringValue)) {
            return MismatchMessages.DefaultImpls.valueMismatchFailure$default(resolver.getMismatchMessages(), "CSV string", sampleData, null, 4, null);
        }
        String[] stringArray = new String[]{","};
        Iterable $this$mapIndexed$iv = StringsKt.split$default((CharSequence)((StringValue)sampleData).getString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            Result result2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            try {
                void value2;
                this.getPattern().parse((String)value2, resolver);
                result2 = new Result.Success(null, null, 3, null);
            }
            catch (Throwable e) {
                void index;
                result2 = new Result.Failure("Element " + (int)index + " did not match the type " + this.getPattern().getTypeName() + ". " + Utilities.exceptionCauseMessage(e), null, null, null, 14, null);
            }
            collection.add(result2);
        }
        List results2 = (List)destination$iv$iv;
        return Result.Companion.fromResults(results2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Value generate(@NotNull Resolver resolver) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        int max = RangesKt.random((IntRange)new IntRange(2, 5), (Random)((Random)Random.Default));
        Iterable $this$map$iv = (Iterable)new IntRange(1, max);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Value)resolver.withCyclePrevention(this.getPattern(), (Function1)new Function1<Resolver, Value>((Object)this.getPattern()){

                @NotNull
                public final Value invoke(@NotNull Resolver p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((Pattern)this.receiver).generate(p0);
                }
            }));
        }
        String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, (Function1)generate.2.INSTANCE, (int)30, null);
        return new StringValue(string);
    }

    @Override
    @NotNull
    public Sequence<Pattern> newBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Object[] objectArray = new CsvPattern[]{this};
        return SequencesKt.sequenceOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public Sequence<Pattern> negativeBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return new StringPattern(null, null, null, null, 15, null).negativeBasedOn(row, resolver);
    }

    @Override
    @NotNull
    public Sequence<Pattern> newBasedOn(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Object[] objectArray = new CsvPattern[]{this};
        return SequencesKt.sequenceOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public Value parse(@NotNull String value2, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return new StringValue(value2);
    }

    @Override
    @NotNull
    public Result encompasses(@NotNull Pattern otherPattern, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        Intrinsics.checkNotNullParameter((Object)otherPattern, (String)"otherPattern");
        Intrinsics.checkNotNullParameter((Object)thisResolver, (String)"thisResolver");
        Intrinsics.checkNotNullParameter((Object)otherResolver, (String)"otherResolver");
        Intrinsics.checkNotNullParameter(typeStack, (String)"typeStack");
        if (!(otherPattern instanceof CsvPattern)) {
            return new Result.Failure(thisResolver.getMismatchMessages().mismatchMessage(this.getTypeName(), otherPattern.getTypeName()), null, null, null, 14, null);
        }
        return this.getPattern().encompasses(((CsvPattern)otherPattern).getPattern(), thisResolver, otherResolver, typeStack);
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(valueList, (String)"valueList");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return new JSONArrayValue(valueList);
    }

    @NotNull
    public String toString() {
        return this.getTypeName();
    }

    @Override
    @Nullable
    public String getTypeAlias() {
        return null;
    }

    @Override
    @NotNull
    public String getTypeName() {
        return "(csv/" + this.getPattern().getTypeName() + ")";
    }

    @Override
    @NotNull
    public ConsumeResult<Value, Value> matches(@NotNull List<? extends Value> sampleData, @NotNull Resolver resolver) {
        return Pattern.DefaultImpls.matches(this, sampleData, resolver);
    }

    @Override
    @NotNull
    public ConsumeResult<Pattern, Pattern> encompasses(@NotNull List<? extends Pattern> others, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull String lengthError, @NotNull Set<PairOfTypes> typeStack) {
        return Pattern.DefaultImpls.encompasses(this, others, thisResolver, otherResolver, lengthError, typeStack);
    }

    @Override
    @NotNull
    public Value generateWithAll(@NotNull Resolver resolver) {
        return Pattern.DefaultImpls.generateWithAll(this, resolver);
    }

    @Override
    @NotNull
    public List<Pattern> patternSet(@NotNull Resolver resolver) {
        return Pattern.DefaultImpls.patternSet(this, resolver);
    }

    @Override
    @NotNull
    public Pattern parseToType(@NotNull String valueString, @NotNull Resolver resolver) {
        return Pattern.DefaultImpls.parseToType(this, valueString, resolver);
    }

    @Override
    @NotNull
    public Result fitsWithin(@NotNull List<? extends Pattern> otherPatterns, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        return Pattern.DefaultImpls.fitsWithin(this, otherPatterns, thisResolver, otherResolver, typeStack);
    }

    @Override
    @NotNull
    public Pattern toNullable(@Nullable String defaultValue) {
        return Pattern.DefaultImpls.toNullable(this, defaultValue);
    }
}

