/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.utilities;

import in.specmatic.core.git.GitCommand;
import in.specmatic.core.git.GitOperations;
import in.specmatic.core.git.SystemGit;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.utilities.ContractPathData;
import in.specmatic.core.utilities.ContractSource;
import in.specmatic.core.utilities.ContractSourceKt;
import in.specmatic.core.utilities.ContractsSelectorPredicate;
import in.specmatic.core.utilities.GitSource;
import in.specmatic.core.utilities.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0000H\u0002J\t\u0010\u001c\u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0004H\u00c6\u0003JK\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0016H\u0016J\b\u0010$\u001a\u00020\u0014H\u0002J\u0013\u0010%\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*H\u0016J\t\u0010+\u001a\u00020,H\u00d6\u0001J\u0010\u0010-\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0016H\u0016J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u0016H\u0002J\u0010\u00100\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u0016H\u0002J\u0018\u00101\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*2\u0006\u00102\u001a\u00020\u0016H\u0002J\b\u00103\u001a\u00020\u0018H\u0002J&\u00104\u001a\b\u0012\u0004\u0012\u0002050\u00072\u0006\u00106\u001a\u0002072\u0006\u0010#\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0004H\u0016J\u0010\u00109\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0004H\u0002J\u0010\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u0004H\u0016J\u0010\u0010<\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*H\u0016J\t\u0010=\u001a\u00020\u0004H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0016\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006>"}, d2={"Lin/specmatic/core/utilities/GitRepo;", "Lin/specmatic/core/utilities/ContractSource;", "Lin/specmatic/core/utilities/GitSource;", "gitRepositoryURL", "", "branchName", "testContracts", "", "stubContracts", "type", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "getBranchName", "()Ljava/lang/String;", "getGitRepositoryURL", "repoName", "getStubContracts", "()Ljava/util/List;", "getTestContracts", "getType", "addSpecmaticFolderToGitIgnoreFile", "", "gitIgnoreFile", "Ljava/io/File;", "onNewLine", "", "cloneRepoAndCheckoutBranch", "reposBaseDir", "gitRepo", "component1", "component2", "component3", "component4", "component5", "copy", "directoryRelativeTo", "workingDirectory", "ensureThatSpecmaticFolderIsIgnored", "equals", "other", "", "getLatest", "sourceGit", "Lin/specmatic/core/git/SystemGit;", "hashCode", "", "install", "isBehind", "contractsRepoDir", "isClean", "isEmptyNestedGitDirectory", "sourceDir", "isSpecmaticFolderIgnored", "loadContracts", "Lin/specmatic/core/utilities/ContractPathData;", "selector", "Lin/specmatic/core/utilities/ContractsSelectorPredicate;", "configFilePath", "localRepoDir", "pathDescriptor", "path", "pushUpdates", "toString", "core"})
@SourceDebugExtension(value={"SMAP\nGitRepo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRepo.kt\nin/specmatic/core/utilities/GitRepo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1549#2:167\n1620#2,3:168\n*S KotlinDebug\n*F\n+ 1 GitRepo.kt\nin/specmatic/core/utilities/GitRepo\n*L\n85#1:167\n85#1:168,3\n*E\n"})
public final class GitRepo
implements ContractSource,
GitSource {
    @NotNull
    private final String gitRepositoryURL;
    @Nullable
    private final String branchName;
    @NotNull
    private final List<String> testContracts;
    @NotNull
    private final List<String> stubContracts;
    @Nullable
    private final String type;
    @NotNull
    private final String repoName;

    public GitRepo(@NotNull String gitRepositoryURL, @Nullable String branchName, @NotNull List<String> testContracts, @NotNull List<String> stubContracts, @Nullable String type) {
        Intrinsics.checkNotNullParameter((Object)gitRepositoryURL, (String)"gitRepositoryURL");
        Intrinsics.checkNotNullParameter(testContracts, (String)"testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, (String)"stubContracts");
        this.gitRepositoryURL = gitRepositoryURL;
        this.branchName = branchName;
        this.testContracts = testContracts;
        this.stubContracts = stubContracts;
        this.type = type;
        String[] stringArray = new String[]{"/"};
        this.repoName = StringsKt.removeSuffix((String)((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)this.gitRepositoryURL, (String[])stringArray, (boolean)false, (int)0, (int)6, null))), (CharSequence)".git");
    }

    @NotNull
    public final String getGitRepositoryURL() {
        return this.gitRepositoryURL;
    }

    @Nullable
    public final String getBranchName() {
        return this.branchName;
    }

    @Override
    @NotNull
    public List<String> getTestContracts() {
        return this.testContracts;
    }

    @Override
    @NotNull
    public List<String> getStubContracts() {
        return this.stubContracts;
    }

    @Override
    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String pathDescriptor(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return this.repoName + ":" + path2;
    }

    @Override
    @NotNull
    public File directoryRelativeTo(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        return FilesKt.resolve((File)workingDirectory, (String)this.repoName);
    }

    @Override
    public void getLatest(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
        sourceGit.pull();
    }

    @Override
    public void pushUpdates(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
        ContractSourceKt.commitAndPush(sourceGit);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ContractPathData> loadContracts(@NotNull ContractsSelectorPredicate selector, @NotNull String workingDirectory, @NotNull String configFilePath) {
        void $this$mapTo$iv$iv;
        File file;
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        File userHome = new File(System.getProperty("user.home"));
        File defaultQontractWorkingDir = FilesKt.resolve((File)userHome, (String)".specmatic/repos");
        File defaultRepoDir = this.directoryRelativeTo(defaultQontractWorkingDir);
        File bundleDir = FilesKt.resolve((File)new File(".specmatic_test_bundle"), (String)this.repoName);
        if (bundleDir.exists()) {
            LoggingKt.getLogger().log("Using contracts from " + bundleDir.getPath());
            file = bundleDir;
        } else if (defaultRepoDir.exists()) {
            LoggingKt.getLogger().log("Using contracts in home dir");
            file = defaultRepoDir;
        } else {
            File reposBaseDir = this.localRepoDir(workingDirectory);
            File contractsRepoDir = this.directoryRelativeTo(reposBaseDir);
            LoggingKt.getLogger().log("Looking for a contract repo checkout at: " + contractsRepoDir.getCanonicalPath());
            if (!contractsRepoDir.exists()) {
                LoggingKt.getLogger().log("Contract repo does not exist.");
                file = this.cloneRepoAndCheckoutBranch(reposBaseDir, this);
            } else if (contractsRepoDir.exists() && this.isBehind(contractsRepoDir)) {
                LoggingKt.getLogger().log("Contract repo exists but is behind the remote.");
                file = this.cloneRepoAndCheckoutBranch(reposBaseDir, this);
            } else if (contractsRepoDir.exists() && this.isClean(contractsRepoDir)) {
                LoggingKt.getLogger().log("Contract repo exists, is clean, and is up to date with remote.");
                this.ensureThatSpecmaticFolderIsIgnored();
                file = contractsRepoDir;
            } else {
                LoggingKt.getLogger().log("Contract repo exists, but it is not clean.");
                file = this.cloneRepoAndCheckoutBranch(reposBaseDir, this);
            }
        }
        File repoDir = file;
        Iterable $this$map$iv = selector.select(this);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = repoDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            String string3 = FilesKt.resolve((File)repoDir, (String)it).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
            collection.add(new ContractPathData(string2, string3, this.getType(), this.gitRepositoryURL, this.branchName, (String)it));
        }
        return (List)destination$iv$iv;
    }

    private final boolean isClean(File contractsRepoDir) {
        String string = contractsRepoDir.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        GitCommand sourceGit = Utilities.getSystemGit(string);
        return ((CharSequence)sourceGit.statusPorcelain()).length() == 0;
    }

    private final boolean isBehind(File contractsRepoDir) {
        String string = contractsRepoDir.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        GitCommand sourceGit = Utilities.getSystemGitWithAuth(string);
        sourceGit.fetch();
        return sourceGit.revisionsBehindCount() > 0;
    }

    private final boolean isSpecmaticFolderIgnored() {
        String currentWorkingDirectory = new File(".").getAbsolutePath();
        Intrinsics.checkNotNull((Object)currentWorkingDirectory);
        GitCommand sourceGit = Utilities.getSystemGit(currentWorkingDirectory);
        return ((CharSequence)sourceGit.checkIgnore(".specmatic")).length() > 0;
    }

    private final File cloneRepoAndCheckoutBranch(File reposBaseDir, GitRepo gitRepo) {
        LoggingKt.getLogger().log("Cloning " + this.gitRepositoryURL + " into " + reposBaseDir.getPath());
        reposBaseDir.mkdirs();
        File repositoryDirectory = GitOperations.clone(reposBaseDir, gitRepo);
        if (this.branchName == null) {
            LoggingKt.getLogger().log("No branch specified, using default branch");
        } else {
            GitOperations.checkout(repositoryDirectory, this.branchName);
        }
        this.ensureThatSpecmaticFolderIsIgnored();
        return repositoryDirectory;
    }

    private final void ensureThatSpecmaticFolderIsIgnored() {
        if (!this.isSpecmaticFolderIgnored()) {
            File gitIgnoreFile = new File(".gitignore");
            if (gitIgnoreFile.exists()) {
                LoggingKt.getLogger().log("A .gitignore file exists for this git repo, but it does not contain the .specmatic folder.");
                GitRepo.addSpecmaticFolderToGitIgnoreFile$default(this, gitIgnoreFile, false, 2, null);
            } else {
                LoggingKt.getLogger().log("Creating a gitignore file as it is missing for the current project.");
                this.addSpecmaticFolderToGitIgnoreFile(gitIgnoreFile, false);
            }
        }
    }

    private final void addSpecmaticFolderToGitIgnoreFile(File gitIgnoreFile, boolean onNewLine) {
        LoggingKt.getLogger().log("Adding .specmatic folder to .gitignore file.");
        FilesKt.appendText$default((File)gitIgnoreFile, (String)((onNewLine ? "\n" : "") + ".specmatic"), null, (int)2, null);
    }

    static /* synthetic */ void addSpecmaticFolderToGitIgnoreFile$default(GitRepo gitRepo, File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        gitRepo.addSpecmaticFolderToGitIgnoreFile(file, bl);
    }

    private final File localRepoDir(String workingDirectory) {
        return FilesKt.resolve((File)new File(workingDirectory), (String)"repos");
    }

    @Override
    public void install(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        File baseReposDirectory = FilesKt.resolve((File)workingDirectory, (String)"repos");
        File sourceDir = FilesKt.resolve((File)baseReposDirectory, (String)this.repoName);
        String string = sourceDir.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        SystemGit sourceGit = new SystemGit(string, null, null, 6, null);
        try {
            System.out.println((Object)("Checking " + sourceDir.getPath()));
            if (!sourceDir.exists()) {
                sourceDir.mkdirs();
            }
            if (!sourceGit.workingDirectoryIsGitRepo() || this.isEmptyNestedGitDirectory(sourceGit, sourceDir)) {
                System.out.println((Object)"Found it, not a git dir, recreating...");
                FilesKt.deleteRecursively((File)sourceDir);
                sourceDir.mkdirs();
                System.out.println((Object)("Cloning " + this.gitRepositoryURL + " into " + sourceDir.getCanonicalPath()));
                File file = sourceDir.getCanonicalFile().getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
                this.cloneRepoAndCheckoutBranch(file, this);
            } else {
                System.out.println((Object)("Git repo already exists at " + sourceDir.getPath() + ", so ignoring it and moving on"));
            }
        }
        catch (Throwable e) {
            System.out.println((Object)("Could not clone " + this.gitRepositoryURL + "\n" + e.getClass().getName() + ": " + Utilities.exceptionCauseMessage(e)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEmptyNestedGitDirectory(SystemGit sourceGit, File sourceDir) {
        if (!sourceGit.workingDirectoryIsGitRepo()) return false;
        if (Intrinsics.areEqual((Object)GitCommand.DefaultImpls.getRemoteUrl$default(sourceGit, null, 1, null), (Object)this.gitRepositoryURL)) return false;
        File[] fileArray = sourceDir.listFiles();
        if (fileArray == null) return false;
        if (fileArray.length != 0) return false;
        return true;
    }

    @NotNull
    public final String component1() {
        return this.gitRepositoryURL;
    }

    @Nullable
    public final String component2() {
        return this.branchName;
    }

    @NotNull
    public final List<String> component3() {
        return this.testContracts;
    }

    @NotNull
    public final List<String> component4() {
        return this.stubContracts;
    }

    @Nullable
    public final String component5() {
        return this.type;
    }

    @NotNull
    public final GitRepo copy(@NotNull String gitRepositoryURL, @Nullable String branchName, @NotNull List<String> testContracts, @NotNull List<String> stubContracts, @Nullable String type) {
        Intrinsics.checkNotNullParameter((Object)gitRepositoryURL, (String)"gitRepositoryURL");
        Intrinsics.checkNotNullParameter(testContracts, (String)"testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, (String)"stubContracts");
        return new GitRepo(gitRepositoryURL, branchName, testContracts, stubContracts, type);
    }

    public static /* synthetic */ GitRepo copy$default(GitRepo gitRepo, String string, String string2, List list, List list2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = gitRepo.gitRepositoryURL;
        }
        if ((n & 2) != 0) {
            string2 = gitRepo.branchName;
        }
        if ((n & 4) != 0) {
            list = gitRepo.testContracts;
        }
        if ((n & 8) != 0) {
            list2 = gitRepo.stubContracts;
        }
        if ((n & 0x10) != 0) {
            string3 = gitRepo.type;
        }
        return gitRepo.copy(string, string2, list, list2, string3);
    }

    @NotNull
    public String toString() {
        return "GitRepo(gitRepositoryURL=" + this.gitRepositoryURL + ", branchName=" + this.branchName + ", testContracts=" + this.testContracts + ", stubContracts=" + this.stubContracts + ", type=" + this.type + ")";
    }

    public int hashCode() {
        int result2 = this.gitRepositoryURL.hashCode();
        result2 = result2 * 31 + (this.branchName == null ? 0 : this.branchName.hashCode());
        result2 = result2 * 31 + ((Object)this.testContracts).hashCode();
        result2 = result2 * 31 + ((Object)this.stubContracts).hashCode();
        result2 = result2 * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitRepo)) {
            return false;
        }
        GitRepo gitRepo = (GitRepo)other;
        if (!Intrinsics.areEqual((Object)this.gitRepositoryURL, (Object)gitRepo.gitRepositoryURL)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.branchName, (Object)gitRepo.branchName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.testContracts, gitRepo.testContracts)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.stubContracts, gitRepo.stubContracts)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.type, (Object)gitRepo.type);
    }
}

