/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.conversions;

import in.specmatic.conversions.OpenAPISecurityScheme;
import in.specmatic.conversions.OpenAPISecuritySchemeKt;
import in.specmatic.core.HttpRequest;
import in.specmatic.core.HttpRequestPattern;
import in.specmatic.core.Result;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.pattern.Row;
import in.specmatic.core.pattern.StringPatternKt;
import java.util.Base64;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\u0005\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u0015\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\b\u0010\u0012\u001a\u00020\u0003H\u0002J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lin/specmatic/conversions/BasicAuthSecurityScheme;", "Lin/specmatic/conversions/OpenAPISecurityScheme;", "token", "", "(Ljava/lang/String;)V", "addTo", "Lin/specmatic/core/HttpRequest;", "httpRequest", "Lin/specmatic/core/HttpRequestPattern;", "requestPattern", "row", "Lin/specmatic/core/pattern/Row;", "component1", "copy", "equals", "", "other", "", "getAuthorizationHeaderValue", "hashCode", "", "isInRow", "matches", "Lin/specmatic/core/Result;", "randomBasicAuthCredentials", "removeParam", "toString", "validateBase64EncodedCredentials", "base64Credentials", "validatedToken", "core"})
public final class BasicAuthSecurityScheme
implements OpenAPISecurityScheme {
    @Nullable
    private final String token;

    public BasicAuthSecurityScheme(@Nullable String token) {
        this.token = token;
    }

    public /* synthetic */ BasicAuthSecurityScheme(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    @Override
    @NotNull
    public Result matches(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        String string = httpRequest.getHeaders().get("Authorization");
        if (string == null) {
            return new Result.Failure("Authorization header is missing in request", null, null, null, 14, null);
        }
        String authHeaderValue = string;
        String string2 = authHeaderValue.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (!StringsKt.startsWith$default((String)string2, (String)"basic", (boolean)false, (int)2, null)) {
            return new Result.Failure("Authorization header must be prefixed with \"Basic\"", null, null, null, 14, null);
        }
        String base64Credentials = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)authHeaderValue, (String)" ", null, (int)2, null))).toString();
        return this.validateBase64EncodedCredentials(base64Credentials);
    }

    private final Result validateBase64EncodedCredentials(String base64Credentials) {
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(base64Credentials);
            Intrinsics.checkNotNull((Object)decodedBytes);
            String credentials = new String(decodedBytes, Charsets.UTF_8);
            if (!StringsKt.contains$default((CharSequence)credentials, (CharSequence)":", (boolean)false, (int)2, null)) {
                return new Result.Failure("Base64-encoded credentials in Authorization header is not in the form username:password", null, null, null, 14, null);
            }
        }
        catch (IllegalArgumentException e) {
            return new Result.Failure("Invalid base64 encoding in Authorization header", null, null, null, 14, null);
        }
        return new Result.Success(null, null, 3, null);
    }

    @Override
    @NotNull
    public HttpRequest removeParam(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        return HttpRequest.copy$default(httpRequest, null, null, MapsKt.minus(httpRequest.getHeaders(), (Object)"Authorization"), null, null, null, null, 123, null);
    }

    @Override
    @NotNull
    public HttpRequest addTo(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        return HttpRequest.copy$default(httpRequest, null, null, MapsKt.plus(httpRequest.getHeaders(), (Pair)TuplesKt.to((Object)"Authorization", (Object)this.getAuthorizationHeaderValue())), null, null, null, null, 123, null);
    }

    @Override
    @NotNull
    public HttpRequestPattern addTo(@NotNull HttpRequestPattern requestPattern, @NotNull Row row) {
        Intrinsics.checkNotNullParameter((Object)requestPattern, (String)"requestPattern");
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        return OpenAPISecuritySchemeKt.addToHeaderType("Authorization", row, requestPattern);
    }

    @Override
    public boolean isInRow(@NotNull Row row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        return row.containsField("Authorization");
    }

    private final String getAuthorizationHeaderValue() {
        String validToken = this.token != null ? this.validatedToken(this.token) : this.randomBasicAuthCredentials();
        return "Basic " + validToken;
    }

    private final String validatedToken(String token) {
        Result result2 = this.validateBase64EncodedCredentials(token);
        if (result2 instanceof Result.Failure) {
            throw new ContractException(result2.reportString(), null, null, null, false, 30, null);
        }
        return token;
    }

    private final String randomBasicAuthCredentials() {
        String randomUsername = StringPatternKt.randomString$default(0, 1, null);
        String randomPassword = StringPatternKt.randomString$default(0, 1, null);
        Base64.Encoder encoder = Base64.getEncoder();
        String string = randomUsername + ":" + randomPassword;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String string2 = encoder.encodeToString(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
        return string2;
    }

    private final String component1() {
        return this.token;
    }

    @NotNull
    public final BasicAuthSecurityScheme copy(@Nullable String token) {
        return new BasicAuthSecurityScheme(token);
    }

    public static /* synthetic */ BasicAuthSecurityScheme copy$default(BasicAuthSecurityScheme basicAuthSecurityScheme, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = basicAuthSecurityScheme.token;
        }
        return basicAuthSecurityScheme.copy(string);
    }

    @NotNull
    public String toString() {
        return "BasicAuthSecurityScheme(token=" + this.token + ")";
    }

    public int hashCode() {
        return this.token == null ? 0 : this.token.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BasicAuthSecurityScheme)) {
            return false;
        }
        BasicAuthSecurityScheme basicAuthSecurityScheme = (BasicAuthSecurityScheme)other;
        return Intrinsics.areEqual((Object)this.token, (Object)basicAuthSecurityScheme.token);
    }

    public BasicAuthSecurityScheme() {
        this(null, 1, null);
    }
}

