/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.pattern;

import in.specmatic.core.Resolver;
import in.specmatic.core.Result;
import in.specmatic.core.ResultKt;
import in.specmatic.core.pattern.BooleanPattern;
import in.specmatic.core.pattern.ConsumeResult;
import in.specmatic.core.pattern.ExactValuePattern;
import in.specmatic.core.pattern.HasDefaultExample;
import in.specmatic.core.pattern.HasValue;
import in.specmatic.core.pattern.NullPattern;
import in.specmatic.core.pattern.NumberPattern;
import in.specmatic.core.pattern.NumberPatternKt;
import in.specmatic.core.pattern.PairOfTypes;
import in.specmatic.core.pattern.Pattern;
import in.specmatic.core.pattern.ReturnValue;
import in.specmatic.core.pattern.Row;
import in.specmatic.core.pattern.ScalarType;
import in.specmatic.core.pattern.ScalarTypeKt;
import in.specmatic.core.pattern.StringPattern;
import in.specmatic.core.pattern.TabularPatternKt;
import in.specmatic.core.value.JSONArrayValue;
import in.specmatic.core.value.NumberValue;
import in.specmatic.core.value.Value;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0000\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0086\b\u0018\u0000 _2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001_Bc\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\n\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0010\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0011J\u000b\u0010(\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010)\u001a\u00020\u0007H\u00c6\u0003J\t\u0010*\u001a\u00020\u0007H\u00c6\u0003J\t\u0010+\u001a\u00020\nH\u00c6\u0003J\t\u0010,\u001a\u00020\fH\u00c6\u0003J\t\u0010-\u001a\u00020\nH\u00c6\u0003J\t\u0010.\u001a\u00020\fH\u00c6\u0003J\u000b\u0010/\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u00100\u001a\u00020\fH\u00c6\u0003Jg\u00101\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\f2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0010\u001a\u00020\fH\u00c6\u0001J2\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00012\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002062\u0010\u00108\u001a\f\u0012\u0004\u0012\u00020:09j\u0002`;H\u0016J\u0013\u0010<\u001a\u00020\f2\b\u0010=\u001a\u0004\u0018\u00010 H\u00d6\u0003J \u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020\n2\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\nH\u0002J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u000206H\u0016J\t\u0010E\u001a\u00020\u0007H\u00d6\u0001J\u001e\u0010F\u001a\u00020C2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020C0H2\u0006\u0010D\u001a\u000206H\u0016J\u001a\u0010I\u001a\u0002032\b\u0010J\u001a\u0004\u0018\u00010C2\u0006\u0010D\u001a\u000206H\u0016J\b\u0010K\u001a\u00020\fH\u0002J\b\u0010L\u001a\u00020\fH\u0002J\b\u0010M\u001a\u00020\fH\u0002J$\u0010N\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010P0O2\u0006\u0010Q\u001a\u00020R2\u0006\u0010D\u001a\u000206H\u0016J,\u0010S\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010P0O2\u0006\u0010T\u001a\u00020\f2\u0006\u0010U\u001a\u00020\n2\u0006\u0010V\u001a\u00020\u0005H\u0002J\u0016\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00010O2\u0006\u0010D\u001a\u000206H\u0016J\u001e\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00010O2\u0006\u0010Q\u001a\u00020R2\u0006\u0010D\u001a\u000206H\u0016J$\u0010X\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010P0O2\u0006\u0010Q\u001a\u00020R2\u0006\u0010D\u001a\u000206H\u0016J\u0018\u0010Y\u001a\u00020C2\u0006\u0010Z\u001a\u00020\u00052\u0006\u0010D\u001a\u000206H\u0016J\b\u0010[\u001a\u00020\u0005H\u0002J\u0010\u0010\\\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010]\u001a\u00020\u0007H\u0002J\b\u0010^\u001a\u00020\u0005H\u0016R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0010\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u0014\u0010\u001f\u001a\u00020 X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0019R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0013R\u0014\u0010&\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0013\u00a8\u0006`"}, d2={"Lin/specmatic/core/pattern/NumberPattern;", "Lin/specmatic/core/pattern/Pattern;", "Lin/specmatic/core/pattern/ScalarType;", "Lin/specmatic/core/pattern/HasDefaultExample;", "typeAlias", "", "minLength", "", "maxLength", "minimum", "Ljava/math/BigDecimal;", "exclusiveMinimum", "", "maximum", "exclusiveMaximum", "example", "isDoubleFormat", "(Ljava/lang/String;IILjava/math/BigDecimal;ZLjava/math/BigDecimal;ZLjava/lang/String;Z)V", "getExample", "()Ljava/lang/String;", "getExclusiveMaximum", "()Z", "getExclusiveMinimum", "largestValue", "getLargestValue", "()Ljava/math/BigDecimal;", "getMaxLength", "()I", "getMaximum", "getMinLength", "getMinimum", "pattern", "", "getPattern", "()Ljava/lang/Object;", "smallestIncValue", "getSmallestIncValue", "getTypeAlias", "typeName", "getTypeName", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "encompasses", "Lin/specmatic/core/Result;", "otherPattern", "thisResolver", "Lin/specmatic/core/Resolver;", "otherResolver", "typeStack", "", "Lin/specmatic/core/pattern/PairOfTypes;", "Lin/specmatic/core/pattern/TypeStack;", "equals", "other", "eval", "a", "operator", "b", "generate", "Lin/specmatic/core/value/Value;", "resolver", "hashCode", "listOf", "valueList", "", "matches", "sampleData", "maxValueIsSet", "minAndMaxValuesNotSet", "minValueIsSet", "negativeBasedOn", "Lkotlin/sequences/Sequence;", "Lin/specmatic/core/pattern/ReturnValue;", "row", "Lin/specmatic/core/pattern/Row;", "negativeRangeValues", "condition", "number", "message", "newBasedOn", "newBasedOnR", "parse", "value", "randomDigit", "randomNumber", "randomPositiveDigit", "toString", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nNumberPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberPattern.kt\nin/specmatic/core/pattern/NumberPattern\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,221:1\n1#2:222\n*E\n"})
public final class NumberPattern
implements Pattern,
ScalarType,
HasDefaultExample {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String typeAlias;
    private final int minLength;
    private final int maxLength;
    @NotNull
    private final BigDecimal minimum;
    private final boolean exclusiveMinimum;
    @NotNull
    private final BigDecimal maximum;
    private final boolean exclusiveMaximum;
    @Nullable
    private final String example;
    private final boolean isDoubleFormat;
    @NotNull
    private final String typeName;
    @NotNull
    private final Object pattern;
    @NotNull
    private static final BigDecimal BIG_DECIMAL_INC = new BigDecimal(Double.MIN_VALUE);
    @NotNull
    private static final BigDecimal LOWEST_DECIMAL = new BigDecimal("-1E+1000");
    @NotNull
    private static final BigDecimal HIGHEST_DECIMAL = new BigDecimal("1E+1000");

    public NumberPattern(@Nullable String typeAlias, int minLength, int maxLength, @NotNull BigDecimal minimum, boolean exclusiveMinimum, @NotNull BigDecimal maximum, boolean exclusiveMaximum, @Nullable String example, boolean isDoubleFormat) {
        Intrinsics.checkNotNullParameter((Object)minimum, (String)"minimum");
        Intrinsics.checkNotNullParameter((Object)maximum, (String)"maximum");
        this.typeAlias = typeAlias;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.minimum = minimum;
        this.exclusiveMinimum = exclusiveMinimum;
        this.maximum = maximum;
        this.exclusiveMaximum = exclusiveMaximum;
        this.example = example;
        this.isDoubleFormat = isDoubleFormat;
        if (!(this.minLength > 0)) {
            boolean $i$a$-require-NumberPattern$52 = false;
            String $i$a$-require-NumberPattern$52 = "minLength cannot be less than 1";
            throw new IllegalArgumentException($i$a$-require-NumberPattern$52.toString());
        }
        if (!(this.minLength <= this.maxLength)) {
            boolean $i$a$-require-NumberPattern$62 = false;
            String $i$a$-require-NumberPattern$62 = "maxLength cannot be less than minLength";
            throw new IllegalArgumentException($i$a$-require-NumberPattern$62.toString());
        }
        if ((this.exclusiveMinimum || this.exclusiveMaximum) && !(this.minimum.compareTo(this.maximum) < 0)) {
            boolean $i$a$-require-NumberPattern$72 = false;
            String $i$a$-require-NumberPattern$72 = "Inappropriate minimum and maximum values set";
            throw new IllegalArgumentException($i$a$-require-NumberPattern$72.toString());
        }
        if (!(this.minimum.compareTo(this.maximum) <= 0)) {
            boolean bl = false;
            String string = "Inappropriate minimum and maximum values set";
            throw new IllegalArgumentException(string.toString());
        }
        this.typeName = "number";
        this.pattern = "(number)";
    }

    public /* synthetic */ NumberPattern(String string, int n, int n2, BigDecimal bigDecimal, boolean bl, BigDecimal bigDecimal2, boolean bl2, String string2, boolean bl3, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            string = null;
        }
        if ((n3 & 2) != 0) {
            n = 1;
        }
        if ((n3 & 4) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n3 & 8) != 0) {
            bigDecimal = LOWEST_DECIMAL;
        }
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        if ((n3 & 0x20) != 0) {
            bigDecimal2 = HIGHEST_DECIMAL;
        }
        if ((n3 & 0x40) != 0) {
            bl2 = false;
        }
        if ((n3 & 0x80) != 0) {
            string2 = null;
        }
        if ((n3 & 0x100) != 0) {
            bl3 = true;
        }
        this(string, n, n2, bigDecimal, bl, bigDecimal2, bl2, string2, bl3);
    }

    @Override
    @Nullable
    public String getTypeAlias() {
        return this.typeAlias;
    }

    public final int getMinLength() {
        return this.minLength;
    }

    public final int getMaxLength() {
        return this.maxLength;
    }

    @NotNull
    public final BigDecimal getMinimum() {
        return this.minimum;
    }

    public final boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    @NotNull
    public final BigDecimal getMaximum() {
        return this.maximum;
    }

    public final boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    @Override
    @Nullable
    public String getExample() {
        return this.example;
    }

    public final boolean isDoubleFormat() {
        return this.isDoubleFormat;
    }

    private final BigDecimal getSmallestIncValue() {
        return this.isDoubleFormat ? BIG_DECIMAL_INC : new BigDecimal(1);
    }

    private final BigDecimal getLargestValue() {
        BigDecimal bigDecimal;
        if (this.isDoubleFormat) {
            bigDecimal = new BigDecimal(Double.MAX_VALUE);
        } else {
            BigDecimal bigDecimal2 = BigDecimal.valueOf(Integer.MAX_VALUE);
            bigDecimal = bigDecimal2;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(...)");
        }
        return bigDecimal;
    }

    private final boolean eval(BigDecimal a, String operator, BigDecimal b) {
        return switch (operator) {
            case ">" -> {
                if (a.compareTo(b) > 0) {
                    yield true;
                }
                yield false;
            }
            case ">=" -> {
                if (a.compareTo(b) >= 0) {
                    yield true;
                }
                yield false;
            }
            case "<" -> {
                if (a.compareTo(b) < 0) {
                    yield true;
                }
                yield false;
            }
            case "<=" -> {
                if (a.compareTo(b) <= 0) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalArgumentException("Unsupported operator");
        };
    }

    @Override
    @NotNull
    public Result matches(@Nullable Value sampleData, @NotNull Resolver resolver) {
        String maxOp;
        String minOp;
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        if (!(sampleData instanceof NumberValue)) {
            return ResultKt.mismatchResult("number", sampleData, resolver.getMismatchMessages());
        }
        if (((NumberValue)sampleData).toStringLiteral().length() < this.minLength) {
            return ResultKt.mismatchResult("number with minLength " + this.minLength, sampleData, resolver.getMismatchMessages());
        }
        if (((NumberValue)sampleData).toStringLiteral().length() > this.maxLength) {
            return ResultKt.mismatchResult("number with maxLength " + this.maxLength, sampleData, resolver.getMismatchMessages());
        }
        BigDecimal sampleNumber = new BigDecimal(((NumberValue)sampleData).getNumber().toString());
        String string = minOp = this.exclusiveMinimum ? ">" : ">=";
        if (!this.eval(sampleNumber, minOp, this.minimum)) {
            return ResultKt.mismatchResult("number " + minOp + " " + this.minimum, sampleData, resolver.getMismatchMessages());
        }
        String string2 = maxOp = this.exclusiveMaximum ? "<" : "<=";
        if (!this.eval(sampleNumber, maxOp, this.maximum)) {
            return ResultKt.mismatchResult("number " + maxOp + " " + this.maximum, sampleData, resolver.getMismatchMessages());
        }
        return new Result.Success(null, null, 3, null);
    }

    @Override
    @NotNull
    public Value generate(@NotNull Resolver resolver) {
        BigDecimal max;
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        if (this.minAndMaxValuesNotSet()) {
            Value value2 = resolver.resolveExample(this.getExample(), (Pattern)this);
            if (value2 == null) {
                value2 = new NumberValue(this.randomNumber(this.minLength));
            }
            return value2;
        }
        if (Intrinsics.areEqual((Object)this.minimum, (Object)LOWEST_DECIMAL)) {
            if (this.maximum.compareTo(this.getSmallestIncValue()) < 0) {
                BigDecimal bigDecimal2 = this.maximum.subtract(new BigDecimal(1));
                bigDecimal = bigDecimal2;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"subtract(...)");
            } else {
                bigDecimal = this.getSmallestIncValue();
            }
        } else {
            bigDecimal = this.minimum;
        }
        BigDecimal min = bigDecimal;
        BigDecimal bigDecimal3 = max = Intrinsics.areEqual((Object)this.maximum, (Object)HIGHEST_DECIMAL) ? this.getLargestValue() : this.maximum;
        if (this.isDoubleFormat) {
            return new NumberValue(new SecureRandom().nextDouble(min.doubleValue(), max.doubleValue()));
        }
        return new NumberValue(new SecureRandom().nextInt(min.intValue(), max.intValue()));
    }

    private final int randomNumber(int minLength) {
        String first = String.valueOf(this.randomPositiveDigit());
        String rest2 = CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)1, (int)minLength)), (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<Integer, CharSequence>(this){
            final /* synthetic */ NumberPattern this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(int it) {
                return NumberPattern.access$randomDigit(this.this$0);
            }
        }), (int)30, null);
        String stringNumber = first + rest2;
        return Integer.parseInt(stringNumber);
    }

    private final String randomDigit() {
        return String.valueOf(new SecureRandom().nextInt(10));
    }

    private final int randomPositiveDigit() {
        return new SecureRandom().nextInt(9) + 1;
    }

    @Override
    @NotNull
    public Sequence<Pattern> newBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return SequencesKt.map(this.newBasedOnR(row, resolver), (Function1)newBasedOn.1.INSTANCE);
    }

    @Override
    @NotNull
    public Sequence<ReturnValue<Pattern>> newBasedOnR(@NotNull Row row, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        List values2 = new ArrayList();
        String messageForTestFromThisObject = this.minAndMaxValuesNotSet() ? "" : "value within bounds";
        values2.add(new HasValue<NumberPattern>(this, messageForTestFromThisObject));
        if (this.minValueIsSet()) {
            if (this.exclusiveMinimum) {
                BigDecimal bigDecimal = this.minimum.add(this.getSmallestIncValue());
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"add(...)");
                values2.add(new HasValue<ExactValuePattern>(new ExactValuePattern(new NumberValue(bigDecimal), null, 2, null), "value just within exclusive minimum " + this.minimum));
            } else {
                values2.add(new HasValue<ExactValuePattern>(new ExactValuePattern(new NumberValue(this.minimum), null, 2, null), "minimum value " + this.minimum));
            }
        }
        if (this.maxValueIsSet()) {
            if (this.exclusiveMaximum) {
                BigDecimal bigDecimal = this.maximum.subtract(this.getSmallestIncValue());
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"subtract(...)");
                values2.add(new HasValue<ExactValuePattern>(new ExactValuePattern(new NumberValue(bigDecimal), null, 2, null), "value just within exclusive maximum " + this.maximum));
            } else {
                values2.add(new HasValue<ExactValuePattern>(new ExactValuePattern(new NumberValue(this.maximum), null, 2, null), "maximum value " + this.maximum));
            }
        }
        return CollectionsKt.asSequence((Iterable)values2);
    }

    private final boolean minValueIsSet() {
        return !Intrinsics.areEqual((Object)this.minimum, (Object)LOWEST_DECIMAL);
    }

    private final boolean maxValueIsSet() {
        return !Intrinsics.areEqual((Object)this.maximum, (Object)HIGHEST_DECIMAL);
    }

    private final boolean minAndMaxValuesNotSet() {
        return Intrinsics.areEqual((Object)this.minimum, (Object)LOWEST_DECIMAL) && Intrinsics.areEqual((Object)this.maximum, (Object)HIGHEST_DECIMAL);
    }

    @Override
    @NotNull
    public Sequence<Pattern> newBasedOn(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Object[] objectArray = new NumberPattern[]{this};
        return SequencesKt.sequenceOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public Sequence<ReturnValue<Pattern>> negativeBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Object[] objectArray = new Pattern[]{NullPattern.INSTANCE, new BooleanPattern(null, 1, null), new StringPattern(null, null, null, null, null, 31, null)};
        Sequence dataTypeNegatives = SequencesKt.sequenceOf((Object[])objectArray);
        boolean bl = this.minValueIsSet();
        BigDecimal bigDecimal = this.minimum.subtract(this.getSmallestIncValue());
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"subtract(...)");
        Sequence<ReturnValue<Pattern>> negativeForMinimumValue = this.negativeRangeValues(bl, bigDecimal, "value less than minimum of " + this.minimum);
        boolean bl2 = this.maxValueIsSet();
        BigDecimal bigDecimal2 = this.maximum.add(this.getSmallestIncValue());
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"add(...)");
        Sequence<ReturnValue<Pattern>> negativeForMaximumValue = this.negativeRangeValues(bl2, bigDecimal2, "value greater than maximum of " + this.maximum);
        return SequencesKt.plus((Sequence)SequencesKt.plus(ScalarTypeKt.scalarAnnotation(this, (Sequence<? extends Pattern>)dataTypeNegatives), negativeForMinimumValue), negativeForMaximumValue);
    }

    private final Sequence<ReturnValue<Pattern>> negativeRangeValues(boolean condition, BigDecimal number, String message) {
        Sequence sequence;
        if (condition) {
            Object[] objectArray = new HasValue[]{new HasValue<ExactValuePattern>(new ExactValuePattern(new NumberValue(number), null, 2, null), message)};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        } else {
            sequence = SequencesKt.emptySequence();
        }
        return sequence;
    }

    @Override
    @NotNull
    public Value parse(@NotNull String value2, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return new NumberValue(TabularPatternKt.convertToNumber(value2));
    }

    @Override
    @NotNull
    public Result encompasses(@NotNull Pattern otherPattern, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        Intrinsics.checkNotNullParameter((Object)otherPattern, (String)"otherPattern");
        Intrinsics.checkNotNullParameter((Object)thisResolver, (String)"thisResolver");
        Intrinsics.checkNotNullParameter((Object)otherResolver, (String)"otherResolver");
        Intrinsics.checkNotNullParameter(typeStack, (String)"typeStack");
        return NumberPatternKt.encompasses(this, otherPattern, thisResolver, otherResolver, typeStack);
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(valueList, (String)"valueList");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return new JSONArrayValue(valueList);
    }

    @Override
    @NotNull
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @NotNull
    public Object getPattern() {
        return this.pattern;
    }

    @NotNull
    public String toString() {
        return this.getPattern().toString();
    }

    @Override
    @NotNull
    public ConsumeResult<Value, Value> matches(@NotNull List<? extends Value> sampleData, @NotNull Resolver resolver) {
        return Pattern.DefaultImpls.matches(this, sampleData, resolver);
    }

    @Override
    @NotNull
    public ConsumeResult<Pattern, Pattern> encompasses(@NotNull List<? extends Pattern> others, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull String lengthError, @NotNull Set<PairOfTypes> typeStack) {
        return Pattern.DefaultImpls.encompasses(this, others, thisResolver, otherResolver, lengthError, typeStack);
    }

    @Override
    @NotNull
    public Value generateWithAll(@NotNull Resolver resolver) {
        return Pattern.DefaultImpls.generateWithAll(this, resolver);
    }

    @Override
    @NotNull
    public List<Pattern> patternSet(@NotNull Resolver resolver) {
        return Pattern.DefaultImpls.patternSet(this, resolver);
    }

    @Override
    @NotNull
    public Pattern parseToType(@NotNull String valueString, @NotNull Resolver resolver) {
        return Pattern.DefaultImpls.parseToType(this, valueString, resolver);
    }

    @Override
    @NotNull
    public Result fitsWithin(@NotNull List<? extends Pattern> otherPatterns2, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        return Pattern.DefaultImpls.fitsWithin(this, otherPatterns2, thisResolver, otherResolver, typeStack);
    }

    @Override
    @NotNull
    public Pattern toNullable(@Nullable String defaultValue) {
        return Pattern.DefaultImpls.toNullable(this, defaultValue);
    }

    @Nullable
    public final String component1() {
        return this.typeAlias;
    }

    public final int component2() {
        return this.minLength;
    }

    public final int component3() {
        return this.maxLength;
    }

    @NotNull
    public final BigDecimal component4() {
        return this.minimum;
    }

    public final boolean component5() {
        return this.exclusiveMinimum;
    }

    @NotNull
    public final BigDecimal component6() {
        return this.maximum;
    }

    public final boolean component7() {
        return this.exclusiveMaximum;
    }

    @Nullable
    public final String component8() {
        return this.example;
    }

    public final boolean component9() {
        return this.isDoubleFormat;
    }

    @NotNull
    public final NumberPattern copy(@Nullable String typeAlias, int minLength, int maxLength, @NotNull BigDecimal minimum, boolean exclusiveMinimum, @NotNull BigDecimal maximum, boolean exclusiveMaximum, @Nullable String example, boolean isDoubleFormat) {
        Intrinsics.checkNotNullParameter((Object)minimum, (String)"minimum");
        Intrinsics.checkNotNullParameter((Object)maximum, (String)"maximum");
        return new NumberPattern(typeAlias, minLength, maxLength, minimum, exclusiveMinimum, maximum, exclusiveMaximum, example, isDoubleFormat);
    }

    public static /* synthetic */ NumberPattern copy$default(NumberPattern numberPattern, String string, int n, int n2, BigDecimal bigDecimal, boolean bl, BigDecimal bigDecimal2, boolean bl2, String string2, boolean bl3, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = numberPattern.typeAlias;
        }
        if ((n3 & 2) != 0) {
            n = numberPattern.minLength;
        }
        if ((n3 & 4) != 0) {
            n2 = numberPattern.maxLength;
        }
        if ((n3 & 8) != 0) {
            bigDecimal = numberPattern.minimum;
        }
        if ((n3 & 0x10) != 0) {
            bl = numberPattern.exclusiveMinimum;
        }
        if ((n3 & 0x20) != 0) {
            bigDecimal2 = numberPattern.maximum;
        }
        if ((n3 & 0x40) != 0) {
            bl2 = numberPattern.exclusiveMaximum;
        }
        if ((n3 & 0x80) != 0) {
            string2 = numberPattern.example;
        }
        if ((n3 & 0x100) != 0) {
            bl3 = numberPattern.isDoubleFormat;
        }
        return numberPattern.copy(string, n, n2, bigDecimal, bl, bigDecimal2, bl2, string2, bl3);
    }

    public int hashCode() {
        int result2 = this.typeAlias == null ? 0 : this.typeAlias.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.minLength);
        result2 = result2 * 31 + Integer.hashCode(this.maxLength);
        result2 = result2 * 31 + this.minimum.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.exclusiveMinimum);
        result2 = result2 * 31 + this.maximum.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.exclusiveMaximum);
        result2 = result2 * 31 + (this.example == null ? 0 : this.example.hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.isDoubleFormat);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NumberPattern)) {
            return false;
        }
        NumberPattern numberPattern = (NumberPattern)other;
        if (!Intrinsics.areEqual((Object)this.typeAlias, (Object)numberPattern.typeAlias)) {
            return false;
        }
        if (this.minLength != numberPattern.minLength) {
            return false;
        }
        if (this.maxLength != numberPattern.maxLength) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.minimum, (Object)numberPattern.minimum)) {
            return false;
        }
        if (this.exclusiveMinimum != numberPattern.exclusiveMinimum) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.maximum, (Object)numberPattern.maximum)) {
            return false;
        }
        if (this.exclusiveMaximum != numberPattern.exclusiveMaximum) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.example, (Object)numberPattern.example)) {
            return false;
        }
        return this.isDoubleFormat == numberPattern.isDoubleFormat;
    }

    public NumberPattern() {
        this(null, 0, 0, null, false, null, false, null, false, 511, null);
    }

    public static final /* synthetic */ String access$randomDigit(NumberPattern $this) {
        return $this.randomDigit();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lin/specmatic/core/pattern/NumberPattern$Companion;", "", "()V", "BIG_DECIMAL_INC", "Ljava/math/BigDecimal;", "getBIG_DECIMAL_INC", "()Ljava/math/BigDecimal;", "HIGHEST_DECIMAL", "getHIGHEST_DECIMAL", "LOWEST_DECIMAL", "getLOWEST_DECIMAL", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BigDecimal getBIG_DECIMAL_INC() {
            return BIG_DECIMAL_INC;
        }

        @NotNull
        public final BigDecimal getLOWEST_DECIMAL() {
            return LOWEST_DECIMAL;
        }

        @NotNull
        public final BigDecimal getHIGHEST_DECIMAL() {
            return HIGHEST_DECIMAL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

