/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.wsdl.parser.message;

import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.value.FullyQualifiedName;
import in.specmatic.core.value.XMLNode;
import in.specmatic.core.value.XMLNodeKt;
import in.specmatic.core.wsdl.parser.WSDL;
import in.specmatic.core.wsdl.parser.WSDLKt;
import in.specmatic.core.wsdl.parser.message.NamespaceQualification;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\t\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lin/specmatic/core/wsdl/parser/message/QualifiedNamespace;", "Lin/specmatic/core/wsdl/parser/message/NamespaceQualification;", "element", "Lin/specmatic/core/value/XMLNode;", "schema", "wsdlTypeReference", "", "wsdl", "Lin/specmatic/core/wsdl/parser/WSDL;", "(Lin/specmatic/core/value/XMLNode;Lin/specmatic/core/value/XMLNode;Ljava/lang/String;Lin/specmatic/core/wsdl/parser/WSDL;)V", "getElement", "()Lin/specmatic/core/value/XMLNode;", "namespacePrefix", "", "getNamespacePrefix", "()Ljava/util/List;", "nodeName", "getNodeName", "()Ljava/lang/String;", "getSchema", "getWsdl", "()Lin/specmatic/core/wsdl/parser/WSDL;", "core"})
public final class QualifiedNamespace
implements NamespaceQualification {
    @NotNull
    private final XMLNode element;
    @NotNull
    private final XMLNode schema;
    @NotNull
    private final String wsdlTypeReference;
    @NotNull
    private final WSDL wsdl;

    public QualifiedNamespace(@NotNull XMLNode element, @NotNull XMLNode schema, @NotNull String wsdlTypeReference, @NotNull WSDL wsdl) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)wsdlTypeReference, (String)"wsdlTypeReference");
        Intrinsics.checkNotNullParameter((Object)wsdl, (String)"wsdl");
        this.element = element;
        this.schema = schema;
        this.wsdlTypeReference = wsdlTypeReference;
        this.wsdl = wsdl;
    }

    @NotNull
    public final XMLNode getElement() {
        return this.element;
    }

    @NotNull
    public final XMLNode getSchema() {
        return this.schema;
    }

    @NotNull
    public final WSDL getWsdl() {
        return this.wsdl;
    }

    @Override
    @NotNull
    public List<String> getNamespacePrefix() {
        List list;
        if (!StringsKt.isBlank((CharSequence)XMLNodeKt.namespacePrefix(this.wsdlTypeReference))) {
            FullyQualifiedName fullyQualifiedName2 = this.element.fullyQualifiedNameFromQName(this.wsdlTypeReference);
            list = CollectionsKt.listOf((Object)this.wsdl.mapNamespaceToPrefix(fullyQualifiedName2.getNamespace()));
        } else {
            String targetNamespace = XMLNode.getAttributeValue$default(this.schema, "targetNamespace", null, 2, null);
            list = CollectionsKt.listOf((Object)this.wsdl.mapNamespaceToPrefix(targetNamespace));
        }
        return list;
    }

    @Override
    @NotNull
    public String getNodeName() {
        String nodeName = XMLNode.getAttributeValue$default(this.element, "name", null, 2, null);
        FullyQualifiedName fullyQualifiedName2 = !StringsKt.isBlank((CharSequence)this.wsdlTypeReference) ? this.element.fullyQualifiedNameFromQName(this.wsdlTypeReference) : this.element.fullyQualifiedName(this.wsdl);
        String string = WSDLKt.namespaceOrSchemaNamespace(fullyQualifiedName2.getNamespace(), this.schema);
        if (string == null) {
            throw new ContractException("Could not find namespace prefix for " + nodeName, null, null, null, false, 30, null);
        }
        String mappedPrefix = this.wsdl.mapNamespaceToPrefix(string);
        return mappedPrefix + ":" + XMLNodeKt.localName(nodeName);
    }
}

