/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.log;

import in.specmatic.core.HttpRequest;
import in.specmatic.core.HttpResponse;
import in.specmatic.core.log.CurrentDate;
import in.specmatic.core.log.LogMessage;
import in.specmatic.core.value.JSONObjectValue;
import in.specmatic.core.value.StringValue;
import in.specmatic.stub.HttpStubResponse;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001BM\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\bJ\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!J\t\u0010\"\u001a\u00020\u0003H\u00c2\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c2\u0003J\t\u0010%\u001a\u00020\bH\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JQ\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\u0006\u00100\u001a\u00020\u001cJ\b\u00101\u001a\u00020\u0003H\u0002J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020\u0003H\u0016J\t\u00105\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000e\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000e\u00a8\u00066"}, d2={"Lin/specmatic/core/log/HttpLogMessage;", "Lin/specmatic/core/log/LogMessage;", "requestTime", "", "request", "Lin/specmatic/core/HttpRequest;", "responseTime", "response", "Lin/specmatic/core/HttpResponse;", "contractPath", "targetServer", "comment", "(Ljava/lang/String;Lin/specmatic/core/HttpRequest;Ljava/lang/String;Lin/specmatic/core/HttpResponse;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getComment", "()Ljava/lang/String;", "getContractPath", "setContractPath", "(Ljava/lang/String;)V", "getRequest", "()Lin/specmatic/core/HttpRequest;", "setRequest", "(Lin/specmatic/core/HttpRequest;)V", "getResponse", "()Lin/specmatic/core/HttpResponse;", "setResponse", "(Lin/specmatic/core/HttpResponse;)V", "getTargetServer", "addRequest", "", "httpRequest", "addResponse", "httpResponse", "stubResponse", "Lin/specmatic/stub/HttpStubResponse;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "", "hashCode", "", "logStartRequestTime", "target", "toJSONObject", "Lin/specmatic/core/value/JSONObjectValue;", "toLogString", "toString", "core"})
public final class HttpLogMessage
implements LogMessage {
    @NotNull
    private String requestTime;
    @NotNull
    private HttpRequest request;
    @NotNull
    private String responseTime;
    @NotNull
    private HttpResponse response;
    @NotNull
    private String contractPath;
    @NotNull
    private final String targetServer;
    @Nullable
    private final String comment;

    public HttpLogMessage(@NotNull String requestTime, @NotNull HttpRequest request, @NotNull String responseTime, @NotNull HttpResponse response, @NotNull String contractPath, @NotNull String targetServer, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)requestTime, (String)"requestTime");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)responseTime, (String)"responseTime");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        Intrinsics.checkNotNullParameter((Object)targetServer, (String)"targetServer");
        this.requestTime = requestTime;
        this.request = request;
        this.responseTime = responseTime;
        this.response = response;
        this.contractPath = contractPath;
        this.targetServer = targetServer;
        this.comment = comment;
    }

    public /* synthetic */ HttpLogMessage(String string, HttpRequest httpRequest, String string2, HttpResponse httpResponse, String string3, String string4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            httpRequest = new HttpRequest(null, null, null, null, null, null, null, 127, null);
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            httpResponse = HttpResponse.Companion.getOK();
        }
        if ((n & 0x10) != 0) {
            string3 = "";
        }
        if ((n & 0x20) != 0) {
            string4 = "";
        }
        if ((n & 0x40) != 0) {
            string5 = null;
        }
        this(string, httpRequest, string2, httpResponse, string3, string4, string5);
    }

    @NotNull
    public final HttpRequest getRequest() {
        return this.request;
    }

    public final void setRequest(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"<set-?>");
        this.request = httpRequest;
    }

    @NotNull
    public final HttpResponse getResponse() {
        return this.response;
    }

    public final void setResponse(@NotNull HttpResponse httpResponse) {
        Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"<set-?>");
        this.response = httpResponse;
    }

    @NotNull
    public final String getContractPath() {
        return this.contractPath;
    }

    public final void setContractPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.contractPath = string;
    }

    @NotNull
    public final String getTargetServer() {
        return this.targetServer;
    }

    @Nullable
    public final String getComment() {
        return this.comment;
    }

    public final void addRequest(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        this.requestTime = new CurrentDate(null, 1, null).toLogString();
        this.request = httpRequest;
    }

    public final void addResponse(@NotNull HttpResponse httpResponse) {
        Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"httpResponse");
        this.responseTime = new CurrentDate(null, 1, null).toLogString();
        this.response = httpResponse;
    }

    private final String target() {
        return !StringsKt.isBlank((CharSequence)this.targetServer) ? "to " + this.targetServer + " " : "";
    }

    @Override
    @NotNull
    public String toLogString() {
        List list;
        List commentLines;
        String linePrefix = "  ";
        Object[] objectArray = new String[]{"", "--------------------"};
        List messagePrefix = CollectionsKt.listOf((Object[])objectArray);
        if (this.comment != null) {
            Object[] objectArray2 = new String[]{String.valueOf(linePrefix), String.valueOf(StringsKt.prependIndent((String)this.comment, (String)linePrefix)), String.valueOf(linePrefix), linePrefix + "-----", String.valueOf(linePrefix)};
            v0 = CollectionsKt.listOf((Object[])objectArray2);
        } else {
            v0 = commentLines = CollectionsKt.emptyList();
        }
        if (!StringsKt.isBlank((CharSequence)this.contractPath)) {
            Object[] objectArray3 = new String[]{linePrefix + "Contract matched: " + this.contractPath, ""};
            list = CollectionsKt.listOf((Object[])objectArray3);
        } else {
            list = CollectionsKt.emptyList();
        }
        List contractPathLines = list;
        Object[] objectArray4 = new String[]{linePrefix + "Request " + this.target() + "at " + this.requestTime, this.request.toLogString(linePrefix + linePrefix), "", linePrefix + "Response at " + this.responseTime, this.response.toLogString(linePrefix + linePrefix)};
        List mainMessage = CollectionsKt.listOf((Object[])objectArray4);
        List messageSuffix = CollectionsKt.listOf((Object)"");
        Iterable iterable = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)messagePrefix, (Iterable)commentLines), (Iterable)contractPathLines), (Iterable)mainMessage), (Iterable)messageSuffix);
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
        return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @NotNull
    public JSONObjectValue toJSONObject() {
        Map log2 = new LinkedHashMap();
        log2.put("requestTime", new StringValue(this.requestTime));
        log2.put("http-request", this.request.toJSON());
        log2.put("http-response", this.response.toJSON());
        log2.put("responseTime", new StringValue(this.responseTime));
        log2.put("contractMatched", new StringValue(this.contractPath));
        return new JSONObjectValue(MapsKt.toMap((Map)log2));
    }

    public final void addResponse(@NotNull HttpStubResponse stubResponse2) {
        Intrinsics.checkNotNullParameter((Object)stubResponse2, (String)"stubResponse");
        this.addResponse(stubResponse2.getResponse());
        this.contractPath = stubResponse2.getContractPath();
    }

    public final void logStartRequestTime() {
        this.requestTime = new CurrentDate(null, 1, null).toLogString();
    }

    private final String component1() {
        return this.requestTime;
    }

    @NotNull
    public final HttpRequest component2() {
        return this.request;
    }

    private final String component3() {
        return this.responseTime;
    }

    @NotNull
    public final HttpResponse component4() {
        return this.response;
    }

    @NotNull
    public final String component5() {
        return this.contractPath;
    }

    @NotNull
    public final String component6() {
        return this.targetServer;
    }

    @Nullable
    public final String component7() {
        return this.comment;
    }

    @NotNull
    public final HttpLogMessage copy(@NotNull String requestTime, @NotNull HttpRequest request, @NotNull String responseTime, @NotNull HttpResponse response, @NotNull String contractPath, @NotNull String targetServer, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)requestTime, (String)"requestTime");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)responseTime, (String)"responseTime");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        Intrinsics.checkNotNullParameter((Object)targetServer, (String)"targetServer");
        return new HttpLogMessage(requestTime, request, responseTime, response, contractPath, targetServer, comment);
    }

    public static /* synthetic */ HttpLogMessage copy$default(HttpLogMessage httpLogMessage, String string, HttpRequest httpRequest, String string2, HttpResponse httpResponse, String string3, String string4, String string5, int n, Object object) {
        if ((n & 1) != 0) {
            string = httpLogMessage.requestTime;
        }
        if ((n & 2) != 0) {
            httpRequest = httpLogMessage.request;
        }
        if ((n & 4) != 0) {
            string2 = httpLogMessage.responseTime;
        }
        if ((n & 8) != 0) {
            httpResponse = httpLogMessage.response;
        }
        if ((n & 0x10) != 0) {
            string3 = httpLogMessage.contractPath;
        }
        if ((n & 0x20) != 0) {
            string4 = httpLogMessage.targetServer;
        }
        if ((n & 0x40) != 0) {
            string5 = httpLogMessage.comment;
        }
        return httpLogMessage.copy(string, httpRequest, string2, httpResponse, string3, string4, string5);
    }

    @NotNull
    public String toString() {
        return "HttpLogMessage(requestTime=" + this.requestTime + ", request=" + this.request + ", responseTime=" + this.responseTime + ", response=" + this.response + ", contractPath=" + this.contractPath + ", targetServer=" + this.targetServer + ", comment=" + this.comment + ")";
    }

    public int hashCode() {
        int result2 = this.requestTime.hashCode();
        result2 = result2 * 31 + this.request.hashCode();
        result2 = result2 * 31 + this.responseTime.hashCode();
        result2 = result2 * 31 + this.response.hashCode();
        result2 = result2 * 31 + this.contractPath.hashCode();
        result2 = result2 * 31 + this.targetServer.hashCode();
        result2 = result2 * 31 + (this.comment == null ? 0 : this.comment.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpLogMessage)) {
            return false;
        }
        HttpLogMessage httpLogMessage = (HttpLogMessage)other;
        if (!Intrinsics.areEqual((Object)this.requestTime, (Object)httpLogMessage.requestTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.request, (Object)httpLogMessage.request)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.responseTime, (Object)httpLogMessage.responseTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.response, (Object)httpLogMessage.response)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contractPath, (Object)httpLogMessage.contractPath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetServer, (Object)httpLogMessage.targetServer)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.comment, (Object)httpLogMessage.comment);
    }

    public HttpLogMessage() {
        this(null, null, null, null, null, null, null, 127, null);
    }
}

