/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.pattern;

import in.specmatic.core.Resolver;
import in.specmatic.core.Result;
import in.specmatic.core.ResultKt;
import in.specmatic.core.pattern.ConsumeResult;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.pattern.DeferredPatternKt;
import in.specmatic.core.pattern.ExactValuePattern;
import in.specmatic.core.pattern.GrammarKt;
import in.specmatic.core.pattern.JSONArrayPattern;
import in.specmatic.core.pattern.JSONArrayPatternKt;
import in.specmatic.core.pattern.ListPattern;
import in.specmatic.core.pattern.MemberList;
import in.specmatic.core.pattern.NullPattern;
import in.specmatic.core.pattern.PairOfTypes;
import in.specmatic.core.pattern.Pattern;
import in.specmatic.core.pattern.RestPattern;
import in.specmatic.core.pattern.ResultWithIndex;
import in.specmatic.core.pattern.Row;
import in.specmatic.core.pattern.SequenceType;
import in.specmatic.core.pattern.TypeStackKt;
import in.specmatic.core.utilities.JSONSerialisationKt;
import in.specmatic.core.utilities.Utilities;
import in.specmatic.core.value.JSONArrayValue;
import in.specmatic.core.value.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006B!\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J%\u0010\u001a\u001a\u00020\u00002\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J2\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020#0\"j\u0002`$H\u0016J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0003J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001fH\u0016J\t\u0010,\u001a\u00020\u0016H\u00d6\u0001J\u001e\u0010-\u001a\u00020*2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020*0\b2\u0006\u0010+\u001a\u00020\u001fH\u0016J\u001a\u0010/\u001a\u00020\u001c2\b\u00100\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u001fH\u0016J\u001e\u00101\u001a\b\u0012\u0004\u0012\u00020\u0001022\u0006\u00103\u001a\u0002042\u0006\u0010+\u001a\u00020\u001fH\u0016J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u0000022\u0006\u0010+\u001a\u00020\u001fH\u0016J\u001e\u00105\u001a\b\u0012\u0004\u0012\u00020\u0000022\u0006\u00103\u001a\u0002042\u0006\u0010+\u001a\u00020\u001fH\u0016J\u0018\u00106\u001a\u00020*2\u0006\u00107\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u001fH\u0016J\t\u00108\u001a\u00020\u0004H\u00d6\u0001J\u0018\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u000bH\u0002R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006<"}, d2={"Lin/specmatic/core/pattern/JSONArrayPattern;", "Lin/specmatic/core/pattern/Pattern;", "Lin/specmatic/core/pattern/SequenceType;", "jsonString", "", "typeAlias", "(Ljava/lang/String;Ljava/lang/String;)V", "pattern", "", "(Ljava/util/List;Ljava/lang/String;)V", "memberList", "Lin/specmatic/core/pattern/MemberList;", "getMemberList", "()Lin/specmatic/core/pattern/MemberList;", "getPattern", "()Ljava/util/List;", "getTypeAlias", "()Ljava/lang/String;", "typeName", "getTypeName", "arrayLengthMismatchMessage", "expectedLength", "", "actualLength", "component1", "component2", "copy", "encompasses", "Lin/specmatic/core/Result;", "otherPattern", "thisResolver", "Lin/specmatic/core/Resolver;", "otherResolver", "typeStack", "", "Lin/specmatic/core/pattern/PairOfTypes;", "Lin/specmatic/core/pattern/TypeStack;", "equals", "", "other", "", "generate", "Lin/specmatic/core/value/Value;", "resolver", "hashCode", "listOf", "valueList", "matches", "sampleData", "negativeBasedOn", "Lkotlin/sequences/Sequence;", "row", "Lin/specmatic/core/pattern/Row;", "newBasedOn", "parse", "value", "toString", "validateInfiniteLength", "otherMembers", "theseMembers", "core"})
@SourceDebugExtension(value={"SMAP\nJSONArrayPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSONArrayPattern.kt\nin/specmatic/core/pattern/JSONArrayPattern\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,251:1\n350#2,7:252\n1549#2:260\n1620#2,3:261\n1#3:259\n*S KotlinDebug\n*F\n+ 1 JSONArrayPattern.kt\nin/specmatic/core/pattern/JSONArrayPattern\n*L\n20#1:252,7\n39#1:260\n39#1:261,3\n*E\n"})
public final class JSONArrayPattern
implements Pattern,
SequenceType {
    @NotNull
    private final List<Pattern> pattern;
    @Nullable
    private final String typeAlias;
    @NotNull
    private final String typeName;

    public JSONArrayPattern(@NotNull List<? extends Pattern> pattern2, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter(pattern2, (String)"pattern");
        this.pattern = pattern2;
        this.typeAlias = typeAlias;
        this.typeName = "json array";
    }

    public /* synthetic */ JSONArrayPattern(List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            string = null;
        }
        this(list, string);
    }

    @Override
    @NotNull
    public List<Pattern> getPattern() {
        return this.pattern;
    }

    @Override
    @Nullable
    public String getTypeAlias() {
        return this.typeAlias;
    }

    @Override
    @NotNull
    public MemberList getMemberList() {
        int n;
        block4: {
            if (this.getPattern().isEmpty()) {
                return new MemberList(CollectionsKt.emptyList(), null);
            }
            Object $this$indexOfFirst$iv = this.getPattern();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv = iterator.next();
                Pattern it = (Pattern)item$iv;
                boolean bl = false;
                if (it instanceof RestPattern) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = -1;
        }
        int it = n;
        boolean bl = false;
        boolean bl2 = it >= 0 && it < CollectionsKt.getLastIndex((List)this.getPattern());
        if (bl2) {
            throw new ContractException("A rest operator ... can only be used in the last entry of an array.", null, null, null, false, 30, null);
        }
        Pattern last = (Pattern)CollectionsKt.last((List)this.getPattern());
        boolean bl3 = false;
        return last instanceof RestPattern ? new MemberList(CollectionsKt.dropLast((List)this.getPattern(), (int)1), ((RestPattern)last).getPattern()) : new MemberList((List<? extends Pattern>)this.getPattern(), null);
    }

    public JSONArrayPattern(@NotNull String jsonString, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        this(JSONSerialisationKt.stringTooPatternArray(jsonString), typeAlias);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result matches(@Nullable Value sampleData, @NotNull Resolver resolver) throws Exception {
        Result result2;
        Iterator<Object> iterator;
        block6: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            if (!(sampleData instanceof JSONArrayValue)) {
                return ResultKt.mismatchResult((Pattern)this, sampleData, resolver.getMismatchMessages());
            }
            Resolver resolverWithNumberType = Utilities.withNumberType(Utilities.withNullPattern(resolver));
            Iterable $this$map$iv = (Iterable)this.getPattern();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pattern pattern2 = (Pattern)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DeferredPatternKt.resolvedHop((Pattern)it, resolverWithNumberType));
            }
            List resolvedPatterns = (List)destination$iv$iv;
            Pattern theOnlyPatternInTheArray = (Pattern)CollectionsKt.singleOrNull((List)resolvedPatterns);
            if (theOnlyPatternInTheArray instanceof ListPattern || theOnlyPatternInTheArray instanceof RestPattern) {
                return theOnlyPatternInTheArray.matches(sampleData, resolverWithNumberType);
            }
            if (resolvedPatterns.size() != ((JSONArrayValue)sampleData).getList().size()) {
                return new Result.Failure(this.arrayLengthMismatchMessage(resolvedPatterns.size(), ((JSONArrayValue)sampleData).getList().size()), null, null, null, 14, null);
            }
            Sequence sequence = SequencesKt.mapIndexed((Sequence)CollectionsKt.asSequence((Iterable)resolvedPatterns), (Function2)((Function2)new Function2<Integer, Pattern, Result>(sampleData, resolverWithNumberType){
                final /* synthetic */ Value $sampleData;
                final /* synthetic */ Resolver $resolverWithNumberType;
                {
                    this.$sampleData = $sampleData;
                    this.$resolverWithNumberType = $resolverWithNumberType;
                    super(2);
                }

                @NotNull
                public final Result invoke(int index, @NotNull Pattern patternValue) {
                    Intrinsics.checkNotNullParameter((Object)patternValue, (String)"patternValue");
                    Value sampleValue = ((JSONArrayValue)this.$sampleData).getList().get(index);
                    return this.$resolverWithNumberType.matchesPattern(null, patternValue, sampleValue).breadCrumb("[" + index + "]");
                }
            }));
            for (Iterator<Object> iterator2 : sequence) {
                Result it = (Result)((Object)iterator2);
                boolean bl = false;
                if (!(it instanceof Result.Failure)) continue;
                iterator = iterator2;
                break block6;
            }
            iterator = null;
        }
        if ((result2 = (Result)((Object)iterator)) == null) {
            result2 = new Result.Success(null, null, 3, null);
        }
        return result2;
    }

    private final String arrayLengthMismatchMessage(int expectedLength, int actualLength) {
        return "Expected an array of length " + expectedLength + ", actual length " + actualLength;
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(valueList, (String)"valueList");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return new JSONArrayValue(valueList);
    }

    @Override
    @NotNull
    public Value generate(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Resolver resolverWithNullType = Utilities.withNullPattern(resolver);
        return new JSONArrayValue(JSONArrayPatternKt.generate((List<? extends Pattern>)this.getPattern(), resolverWithNullType));
    }

    @NotNull
    public Sequence<JSONArrayPattern> newBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Resolver resolverWithNullType = Utilities.withNullPattern(resolver);
        return SequencesKt.map(JSONArrayPatternKt.newBasedOn((List<? extends Pattern>)this.getPattern(), row, resolverWithNullType), (Function1)newBasedOn.1.INSTANCE);
    }

    @NotNull
    public Sequence<JSONArrayPattern> newBasedOn(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Resolver resolverWithNullType = Utilities.withNullPattern(resolver);
        return SequencesKt.map(JSONArrayPatternKt.newBasedOn((List<? extends Pattern>)this.getPattern(), resolverWithNullType), (Function1)newBasedOn.2.INSTANCE);
    }

    @Override
    @NotNull
    public Sequence<Pattern> negativeBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Object[] objectArray = new NullPattern[]{NullPattern.INSTANCE};
        Sequence it = SequencesKt.sequenceOf((Object[])objectArray);
        boolean bl = false;
        return this.getPattern().size() == 1 ? SequencesKt.plus((Sequence)it, this.getPattern().get(0)) : it;
    }

    @Override
    @NotNull
    public Value parse(@NotNull String value2, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return GrammarKt.parsedJSONArray(value2, resolver.getMismatchMessages());
    }

    @Override
    @NotNull
    public Result encompasses(@NotNull Pattern otherPattern, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        Result result2;
        Intrinsics.checkNotNullParameter((Object)otherPattern, (String)"otherPattern");
        Intrinsics.checkNotNullParameter((Object)thisResolver, (String)"thisResolver");
        Intrinsics.checkNotNullParameter((Object)otherResolver, (String)"otherResolver");
        Intrinsics.checkNotNullParameter(typeStack, (String)"typeStack");
        Resolver thisResolverWithNullType = Utilities.withNullPattern(thisResolver);
        Resolver otherResolverWithNullType = Utilities.withNullPattern(otherResolver);
        Pattern pattern2 = otherPattern;
        if (pattern2 instanceof ExactValuePattern) {
            result2 = otherPattern.fitsWithin(CollectionsKt.listOf((Object)this), otherResolverWithNullType, thisResolverWithNullType, typeStack);
        } else if (pattern2 instanceof SequenceType) {
            Result result3;
            try {
                MemberList otherMembers = ((SequenceType)((Object)otherPattern)).getMemberList();
                MemberList theseMembers = this.getMemberList();
                result3 = this.validateInfiniteLength(otherMembers, theseMembers).ifSuccess((Function0<? extends Result>)((Function0)new Function0<Result>(otherMembers, this, otherResolverWithNullType, theseMembers, thisResolverWithNullType, typeStack){
                    final /* synthetic */ MemberList $otherMembers;
                    final /* synthetic */ JSONArrayPattern this$0;
                    final /* synthetic */ Resolver $otherResolverWithNullType;
                    final /* synthetic */ MemberList $theseMembers;
                    final /* synthetic */ Resolver $thisResolverWithNullType;
                    final /* synthetic */ Set<PairOfTypes> $typeStack;
                    {
                        this.$otherMembers = $otherMembers;
                        this.this$0 = $receiver;
                        this.$otherResolverWithNullType = $otherResolverWithNullType;
                        this.$theseMembers = $theseMembers;
                        this.$thisResolverWithNullType = $thisResolverWithNullType;
                        this.$typeStack = $typeStack;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Result invoke() {
                        Object object;
                        Object v0;
                        Object object2;
                        Object object3;
                        block5: {
                            void $this$mapIndexedTo$iv$iv;
                            void $this$mapIndexed$iv;
                            List<Pattern> otherEncompassables = this.$otherMembers.getEncompassableList(this.this$0.getPattern().size(), this.$otherResolverWithNullType);
                            List<Pattern> encompassables = otherEncompassables.size() > this.this$0.getPattern().size() ? this.$theseMembers.getEncompassableList(otherEncompassables.size(), this.$thisResolverWithNullType) : this.this$0.getMemberList().getEncompassables(this.$thisResolverWithNullType);
                            object3 = CollectionsKt.zip((Iterable)encompassables, (Iterable)otherEncompassables);
                            object2 = this.$thisResolverWithNullType;
                            Object object4 = this.$otherResolverWithNullType;
                            Object object5 = this.$typeStack;
                            boolean $i$f$mapIndexed2 = false;
                            void var9_10 = $this$mapIndexed$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                            boolean $i$f$mapIndexedTo = false;
                            int index$iv$iv = 0;
                            for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                                void index;
                                int n;
                                if ((n = index$iv$iv++) < 0) {
                                    CollectionsKt.throwIndexOverflow();
                                }
                                Pair pair = (Pair)item$iv$iv;
                                int n2 = n;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                Pattern bigger = (Pattern)pair.component1();
                                Pattern smaller = (Pattern)pair.component2();
                                collection.add(new ResultWithIndex((int)index, TypeStackKt.biggerEncompassesSmaller(bigger, smaller, (Resolver)object2, (Resolver)object4, (Set<PairOfTypes>)object5)));
                            }
                            List results2 = (List)destination$iv$iv;
                            object4 = results2;
                            object5 = object4.iterator();
                            while (object5.hasNext()) {
                                E $i$f$mapIndexed2 = object5.next();
                                ResultWithIndex it = (ResultWithIndex)$i$f$mapIndexed2;
                                boolean bl = false;
                                if (!(it.getResult() instanceof Result.Failure)) continue;
                                v0 = $i$f$mapIndexed2;
                                break block5;
                            }
                            v0 = null;
                        }
                        object3 = v0;
                        if (object3 != null) {
                            Object result2 = object3;
                            boolean bl = false;
                            object2 = ((ResultWithIndex)result2).getResult().breadCrumb("[" + ((ResultWithIndex)result2).getIndex() + "]");
                            if (object2 != null) {
                                object = object2;
                                return object;
                            }
                        }
                        object = new Result.Success(null, null, 3, null);
                        return object;
                    }
                }));
            }
            catch (ContractException e) {
                result3 = new Result.Failure(e.report(), null, null, null, 14, null);
            }
            result2 = result3;
        } else {
            result2 = new Result.Failure("Expected array or list, got " + otherPattern.getTypeName(), null, null, null, 14, null);
        }
        return result2;
    }

    private final Result validateInfiniteLength(MemberList otherMembers, MemberList theseMembers) {
        return otherMembers.isEndless() && !theseMembers.isEndless() ? (Result)new Result.Failure("Finite list is not a superset of an infinite list.", null, null, null, 14, null) : (Result)new Result.Success(null, null, 3, null);
    }

    @Override
    @NotNull
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @NotNull
    public ConsumeResult<Value, Value> matches(@NotNull List<? extends Value> sampleData, @NotNull Resolver resolver) {
        return Pattern.DefaultImpls.matches(this, sampleData, resolver);
    }

    @Override
    @NotNull
    public ConsumeResult<Pattern, Pattern> encompasses(@NotNull List<? extends Pattern> others, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull String lengthError, @NotNull Set<PairOfTypes> typeStack) {
        return Pattern.DefaultImpls.encompasses(this, others, thisResolver, otherResolver, lengthError, typeStack);
    }

    @Override
    @NotNull
    public Value generateWithAll(@NotNull Resolver resolver) {
        return Pattern.DefaultImpls.generateWithAll(this, resolver);
    }

    @Override
    @NotNull
    public List<Pattern> patternSet(@NotNull Resolver resolver) {
        return Pattern.DefaultImpls.patternSet(this, resolver);
    }

    @Override
    @NotNull
    public Pattern parseToType(@NotNull String valueString, @NotNull Resolver resolver) {
        return Pattern.DefaultImpls.parseToType(this, valueString, resolver);
    }

    @Override
    @NotNull
    public Result fitsWithin(@NotNull List<? extends Pattern> otherPatterns, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        return Pattern.DefaultImpls.fitsWithin(this, otherPatterns, thisResolver, otherResolver, typeStack);
    }

    @Override
    @NotNull
    public Pattern toNullable(@Nullable String defaultValue) {
        return Pattern.DefaultImpls.toNullable(this, defaultValue);
    }

    @NotNull
    public final List<Pattern> component1() {
        return this.pattern;
    }

    @Nullable
    public final String component2() {
        return this.typeAlias;
    }

    @NotNull
    public final JSONArrayPattern copy(@NotNull List<? extends Pattern> pattern2, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter(pattern2, (String)"pattern");
        return new JSONArrayPattern(pattern2, typeAlias);
    }

    public static /* synthetic */ JSONArrayPattern copy$default(JSONArrayPattern jSONArrayPattern, List list, String string, int n, Object object) {
        if ((n & 1) != 0) {
            list = jSONArrayPattern.pattern;
        }
        if ((n & 2) != 0) {
            string = jSONArrayPattern.typeAlias;
        }
        return jSONArrayPattern.copy(list, string);
    }

    @NotNull
    public String toString() {
        return "JSONArrayPattern(pattern=" + this.pattern + ", typeAlias=" + this.typeAlias + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.pattern).hashCode();
        result2 = result2 * 31 + (this.typeAlias == null ? 0 : this.typeAlias.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JSONArrayPattern)) {
            return false;
        }
        JSONArrayPattern jSONArrayPattern = (JSONArrayPattern)other;
        if (!Intrinsics.areEqual(this.pattern, jSONArrayPattern.pattern)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.typeAlias, (Object)jSONArrayPattern.typeAlias);
    }

    public JSONArrayPattern() {
        this(null, null, 3, null);
    }
}

