/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.utilities;

import in.specmatic.core.SpecmaticConfigKt;
import in.specmatic.core.git.SystemGit;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.utilities.ContractPathData;
import in.specmatic.core.utilities.ContractSource;
import in.specmatic.core.utilities.ContractsSelectorPredicate;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00032\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0016J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0016J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006$"}, d2={"Lin/specmatic/core/utilities/WebSource;", "Lin/specmatic/core/utilities/ContractSource;", "testContracts", "", "", "stubContracts", "(Ljava/util/List;Ljava/util/List;)V", "getStubContracts", "()Ljava/util/List;", "getTestContracts", "type", "getType", "()Ljava/lang/String;", "directoryRelativeTo", "Ljava/io/File;", "workingDirectory", "download", "url", "Ljava/net/URL;", "specificationFile", "findFreePort", "", "getLatest", "", "sourceGit", "Lin/specmatic/core/git/SystemGit;", "install", "loadContracts", "Lin/specmatic/core/utilities/ContractPathData;", "selector", "Lin/specmatic/core/utilities/ContractsSelectorPredicate;", "configFilePath", "pathDescriptor", "path", "pushUpdates", "toSpecificationPath", "core"})
@SourceDebugExtension(value={"SMAP\nWebSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSource.kt\nin/specmatic/core/utilities/WebSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1#2:93\n1549#3:94\n1620#3,3:95\n*S KotlinDebug\n*F\n+ 1 WebSource.kt\nin/specmatic/core/utilities/WebSource\n*L\n41#1:94\n41#1:95,3\n*E\n"})
public final class WebSource
implements ContractSource {
    @NotNull
    private final List<String> testContracts;
    @NotNull
    private final List<String> stubContracts;
    @NotNull
    private final String type;

    public WebSource(@NotNull List<String> testContracts, @NotNull List<String> stubContracts) {
        Intrinsics.checkNotNullParameter(testContracts, (String)"testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, (String)"stubContracts");
        this.testContracts = testContracts;
        this.stubContracts = stubContracts;
        this.type = "web";
    }

    @Override
    @NotNull
    public List<String> getTestContracts() {
        return this.testContracts;
    }

    @Override
    @NotNull
    public List<String> getStubContracts() {
        return this.stubContracts;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String pathDescriptor(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return "";
    }

    @Override
    public void install(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        LoggingKt.getLogger().log("Install is not currently supported for web sources");
    }

    @Override
    @NotNull
    public File directoryRelativeTo(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        return new File(".");
    }

    @Override
    public void getLatest(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
        LoggingKt.getLogger().log("No need to get latest as this source is a URL");
    }

    @Override
    public void pushUpdates(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
        LoggingKt.getLogger().log("No need to push updates as this source is a URL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int findFreePort() {
        int n;
        Closeable closeable = new ServerSocket(0);
        Throwable throwable = null;
        try {
            ServerSocket it = (ServerSocket)closeable;
            boolean bl = false;
            n = it.getLocalPort();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ContractPathData> loadContracts(@NotNull ContractsSelectorPredicate selector, @NotNull String workingDirectory, @NotNull String configFilePath) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        File resolvedPath = FilesKt.resolve((File)new File(workingDirectory), (String)"web");
        Iterable $this$map$iv = selector.select(this);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void url;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String path2 = this.toSpecificationPath(new URL((String)url));
            File initialDownloadPath = FilesKt.resolve((File)resolvedPath, (String)path2).getCanonicalFile();
            initialDownloadPath.getParentFile().mkdirs();
            URL uRL = new URL((String)url);
            Intrinsics.checkNotNull((Object)initialDownloadPath);
            File actualDownloadPath = this.download(uRL, initialDownloadPath);
            String string2 = resolvedPath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            String string3 = actualDownloadPath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
            collection.add(new ContractPathData(string2, string3, this.getType(), null, null, initialDownloadPath.getCanonicalPath(), 24, null));
        }
        return (List)destination$iv$iv;
    }

    private final String toSpecificationPath(URL url) {
        String string = url.getHost();
        String string2 = url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        String path2 = string + "/" + StringsKt.removePrefix((String)string2, (CharSequence)"/");
        return path2;
    }

    private final File download(URL url, File specificationFile) {
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("User-Agent", "Mozilla/5.0");
        connection.connect();
        InputStream inputStream = connection.getInputStream();
        FileOutputStream outputStream = new FileOutputStream(specificationFile);
        Intrinsics.checkNotNull((Object)inputStream);
        ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream, (int)0, (int)2, null);
        inputStream.close();
        outputStream.close();
        if (SpecmaticConfigKt.getCONTRACT_EXTENSIONS().contains(FilesKt.getExtension((File)specificationFile))) {
            return specificationFile;
        }
        String text = ((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)specificationFile, null, (int)1, null))).toString();
        String extension = StringsKt.startsWith$default((String)text, (String)"{", (boolean)false, (int)2, null) ? "json" : "yaml";
        File renamedFile = new File(specificationFile.getPath() + "." + extension);
        if (!specificationFile.renameTo(renamedFile)) {
            throw new ContractException("Could not rename file " + specificationFile + " to " + renamedFile, null, null, null, false, 30, null);
        }
        return renamedFile;
    }
}

