/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.app;

import android.app.Activity;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import in.srain.cube.app.CubeFragmentActivity;
import in.srain.cube.app.ICubeFragment;
import in.srain.cube.app.lifecycle.IComponentContainer;
import in.srain.cube.app.lifecycle.LifeCycleComponent;
import in.srain.cube.app.lifecycle.LifeCycleComponentManager;
import in.srain.cube.util.CLog;
import in.srain.cube.util.CubeDebug;

public abstract class CubeFragment
extends Fragment
implements ICubeFragment,
IComponentContainer {
    private static final boolean DEBUG = CubeDebug.DEBUG_LIFE_CYCLE;
    protected Object mDataIn;
    private boolean mFirstResume = true;
    private LifeCycleComponentManager mComponentContainer = new LifeCycleComponentManager();

    protected abstract View createView(LayoutInflater var1, ViewGroup var2, Bundle var3);

    public CubeFragmentActivity getContext() {
        return (CubeFragmentActivity)this.getActivity();
    }

    @Override
    public void onEnter(Object data) {
        this.mDataIn = data;
        if (DEBUG) {
            this.showStatus("onEnter");
        }
    }

    @Override
    public void onLeave() {
        if (DEBUG) {
            this.showStatus("onLeave");
        }
        this.mComponentContainer.onBecomesTotallyInvisible();
    }

    @Override
    public void onBackWithData(Object data) {
        if (DEBUG) {
            this.showStatus("onBackWithData");
        }
        this.mComponentContainer.onBecomesVisibleFromTotallyInvisible();
    }

    @Override
    public boolean processBackPressed() {
        return false;
    }

    @Override
    public void onBack() {
        if (DEBUG) {
            this.showStatus("onBack");
        }
        this.mComponentContainer.onBecomesVisibleFromTotallyInvisible();
    }

    @Override
    public void addComponent(LifeCycleComponent component) {
        this.mComponentContainer.addComponent(component);
    }

    public void onStop() {
        super.onStop();
        if (DEBUG) {
            this.showStatus("onStop");
        }
        this.onLeave();
    }

    public void onResume() {
        super.onResume();
        if (!this.mFirstResume) {
            this.onBack();
        }
        if (this.mFirstResume) {
            this.mFirstResume = false;
        }
        if (DEBUG) {
            this.showStatus("onResume");
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (DEBUG) {
            this.showStatus("onAttach");
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (DEBUG) {
            this.showStatus("onCreate");
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (DEBUG) {
            this.showStatus("onActivityCreated");
        }
    }

    public void onStart() {
        super.onStart();
        if (DEBUG) {
            this.showStatus("onStart");
        }
    }

    public void onPause() {
        super.onPause();
        if (DEBUG) {
            this.showStatus("onPause");
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (DEBUG) {
            this.showStatus("onDestroyView");
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (DEBUG) {
            this.showStatus("onDestroy");
        }
        this.mComponentContainer.onDestroy();
    }

    public void onDetach() {
        super.onDetach();
        if (DEBUG) {
            this.showStatus("onDetach");
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (DEBUG) {
            this.showStatus("onCreateView");
        }
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    private void showStatus(String status) {
        String[] className = this.getClass().getName().split("\\.");
        CLog.d((String)"cube-lifecycle", (String)"%s %s", (Object[])new Object[]{className[className.length - 1], status});
    }
}

