/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.app;

import android.content.Context;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Toast;
import in.srain.cube.app.CubeFragment;
import in.srain.cube.app.FragmentParam;
import in.srain.cube.util.CLog;

public abstract class CubeFragmentActivity
extends FragmentActivity {
    private static final String LOG_TAG = "cube-fragment";
    public static boolean DEBUG = true;
    protected CubeFragment mCurrentFragment;
    private boolean mCloseWarned;

    protected abstract String getCloseWarning();

    protected abstract int getFragmentContainerId();

    public void pushFragmentToBackStack(Class<?> cls, Object data) {
        FragmentParam param = new FragmentParam();
        param.cls = cls;
        param.data = data;
        this.goToThisFragment(param);
    }

    protected String getFragmentTag(FragmentParam param) {
        StringBuilder sb = new StringBuilder(param.cls.toString());
        return sb.toString();
    }

    private void goToThisFragment(FragmentParam param) {
        int containerId = this.getFragmentContainerId();
        Class<?> cls = param.cls;
        if (cls == null) {
            return;
        }
        try {
            CubeFragment fragment;
            String fragmentTag = this.getFragmentTag(param);
            FragmentManager fm = this.getSupportFragmentManager();
            if (DEBUG) {
                CLog.d((String)LOG_TAG, (String)"before operate, stack entry count: %s", (Object[])new Object[]{fm.getBackStackEntryCount()});
            }
            if ((fragment = (CubeFragment)fm.findFragmentByTag(fragmentTag)) == null) {
                fragment = (CubeFragment)cls.newInstance();
            }
            if (this.mCurrentFragment != null && this.mCurrentFragment != fragment) {
                this.mCurrentFragment.onLeave();
            }
            fragment.onEnter(param.data);
            FragmentTransaction ft = fm.beginTransaction();
            if (fragment.isAdded()) {
                if (DEBUG) {
                    CLog.d((String)LOG_TAG, (String)"%s has been added, will be shown again.", (Object[])new Object[]{fragmentTag});
                }
                ft.show((Fragment)fragment);
            } else {
                if (DEBUG) {
                    CLog.d((String)LOG_TAG, (String)"%s is added.", (Object[])new Object[]{fragmentTag});
                }
                ft.add(containerId, (Fragment)fragment, fragmentTag);
            }
            this.mCurrentFragment = fragment;
            ft.addToBackStack(fragmentTag);
            ft.commitAllowingStateLoss();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.mCloseWarned = false;
    }

    public void goToFragment(Class<?> cls, Object data) {
        if (cls == null) {
            return;
        }
        CubeFragment fragment = (CubeFragment)this.getSupportFragmentManager().findFragmentByTag(cls.toString());
        if (fragment != null) {
            this.mCurrentFragment = fragment;
            fragment.onBackWithData(data);
        }
        this.getSupportFragmentManager().popBackStackImmediate(cls.toString(), 0);
    }

    public void popTopFragment(Object data) {
        FragmentManager fm = this.getSupportFragmentManager();
        fm.popBackStackImmediate();
        if (this.tryToUpdateCurrentAfterPop() && this.mCurrentFragment != null) {
            this.mCurrentFragment.onBackWithData(data);
        }
    }

    public void popToRoot(Object data) {
        FragmentManager fm = this.getSupportFragmentManager();
        while (fm.getBackStackEntryCount() > 1) {
            fm.popBackStackImmediate();
        }
        this.popTopFragment(data);
    }

    protected boolean processBackPressed() {
        return false;
    }

    public void onBackPressed() {
        if (this.processBackPressed()) {
            return;
        }
        boolean enableBackPressed = true;
        if (this.mCurrentFragment != null) {
            boolean bl = enableBackPressed = !this.mCurrentFragment.processBackPressed();
        }
        if (enableBackPressed) {
            int cnt = this.getSupportFragmentManager().getBackStackEntryCount();
            if (cnt <= 1 && this.isTaskRoot()) {
                String closeWarningHint = this.getCloseWarning();
                if (!this.mCloseWarned && !TextUtils.isEmpty((CharSequence)closeWarningHint)) {
                    Toast toast = Toast.makeText((Context)this, (CharSequence)closeWarningHint, (int)0);
                    toast.show();
                    this.mCloseWarned = true;
                } else {
                    this.doReturnBack();
                }
            } else {
                this.mCloseWarned = false;
                this.doReturnBack();
            }
        }
    }

    private boolean tryToUpdateCurrentAfterPop() {
        FragmentManager fm = this.getSupportFragmentManager();
        int cnt = fm.getBackStackEntryCount();
        if (cnt > 0) {
            String name = fm.getBackStackEntryAt(cnt - 1).getName();
            Fragment fragment = fm.findFragmentByTag(name);
            if (fragment != null && fragment instanceof CubeFragment) {
                this.mCurrentFragment = (CubeFragment)fragment;
            }
            return true;
        }
        return false;
    }

    protected void doReturnBack() {
        int count = this.getSupportFragmentManager().getBackStackEntryCount();
        if (count <= 1) {
            this.finish();
        } else {
            this.getSupportFragmentManager().popBackStackImmediate();
            if (this.tryToUpdateCurrentAfterPop() && this.mCurrentFragment != null) {
                this.mCurrentFragment.onBack();
            }
        }
    }

    public void hideKeyboardForCurrentFocus() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getSystemService("input_method");
        if (this.getCurrentFocus() != null) {
            inputMethodManager.hideSoftInputFromWindow(this.getCurrentFocus().getWindowToken(), 0);
        }
    }

    public void showKeyboardAtView(View view) {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getSystemService("input_method");
        inputMethodManager.showSoftInput(view, 1);
    }

    protected void exitFullScreen() {
        this.getWindow().clearFlags(1024);
        this.getWindow().addFlags(2048);
    }
}

