/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.app.lifecycle;

import in.srain.cube.app.lifecycle.IComponentContainer;
import in.srain.cube.app.lifecycle.LifeCycleComponent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LifeCycleComponentManager
implements IComponentContainer {
    private HashMap<String, LifeCycleComponent> mComponentList;

    public static void tryAddComponentToContainer(LifeCycleComponent component, Object matrixContainer) {
        LifeCycleComponentManager.tryAddComponentToContainer(component, matrixContainer, true);
    }

    public static boolean tryAddComponentToContainer(LifeCycleComponent component, Object matrixContainer, boolean throwEx) {
        if (matrixContainer instanceof IComponentContainer) {
            ((IComponentContainer)matrixContainer).addComponent(component);
            return true;
        }
        if (throwEx) {
            throw new IllegalArgumentException("componentContainerContext should implements IComponentContainer");
        }
        return false;
    }

    @Override
    public void addComponent(LifeCycleComponent component) {
        if (component != null) {
            if (this.mComponentList == null) {
                this.mComponentList = new HashMap();
            }
            this.mComponentList.put(component.toString(), component);
        }
    }

    public void onBecomesVisibleFromTotallyInvisible() {
        if (this.mComponentList == null) {
            return;
        }
        Iterator<Map.Entry<String, LifeCycleComponent>> it = this.mComponentList.entrySet().iterator();
        while (it.hasNext()) {
            LifeCycleComponent component = it.next().getValue();
            if (component == null) continue;
            component.onBecomesVisibleFromTotallyInvisible();
        }
    }

    public void onBecomesTotallyInvisible() {
        if (this.mComponentList == null) {
            return;
        }
        Iterator<Map.Entry<String, LifeCycleComponent>> it = this.mComponentList.entrySet().iterator();
        while (it.hasNext()) {
            LifeCycleComponent component = it.next().getValue();
            if (component == null) continue;
            component.onBecomesTotallyInvisible();
        }
    }

    public void onBecomesPartiallyInvisible() {
        if (this.mComponentList == null) {
            return;
        }
        Iterator<Map.Entry<String, LifeCycleComponent>> it = this.mComponentList.entrySet().iterator();
        while (it.hasNext()) {
            LifeCycleComponent component = it.next().getValue();
            if (component == null) continue;
            component.onBecomesPartiallyInvisible();
        }
    }

    public void onBecomesVisibleFromPartiallyInvisible() {
        if (this.mComponentList == null) {
            return;
        }
        Iterator<Map.Entry<String, LifeCycleComponent>> it = this.mComponentList.entrySet().iterator();
        while (it.hasNext()) {
            LifeCycleComponent component = it.next().getValue();
            if (component == null) continue;
            component.onBecomesVisible();
        }
    }

    public void onDestroy() {
        if (this.mComponentList == null) {
            return;
        }
        Iterator<Map.Entry<String, LifeCycleComponent>> it = this.mComponentList.entrySet().iterator();
        while (it.hasNext()) {
            LifeCycleComponent component = it.next().getValue();
            if (component == null) continue;
            component.onDestroy();
        }
    }
}

