/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.cache;

import android.content.Context;
import android.support.v4.util.LruCache;
import android.text.TextUtils;
import in.srain.cube.cache.CacheMetaData;
import in.srain.cube.cache.CacheResultType;
import in.srain.cube.cache.DiskCacheProvider;
import in.srain.cube.cache.DiskFileUtils;
import in.srain.cube.cache.ICacheAble;
import in.srain.cube.concurrent.SimpleExecutor;
import in.srain.cube.concurrent.SimpleTask;
import in.srain.cube.request.JsonData;
import in.srain.cube.util.CLog;
import in.srain.cube.util.CubeDebug;
import java.io.IOException;

public class CacheManager {
    private static final boolean DEBUG = CubeDebug.DEBUG_CACHE;
    private static final String LOG_TAG = "cube-cache-manager";
    private static final byte AFTER_READ_FROM_FILE = 1;
    private static final byte AFTER_READ_FROM_ASSERT = 2;
    private static final byte AFTER_CONVERT = 4;
    private static final byte DO_READ_FROM_FILE = 1;
    private static final byte DO_READ_FROM_ASSERT = 2;
    private static final byte DO_CONVERT = 4;
    private static final byte CONVERT_FOR_MEMORY = 3;
    private static final byte CONVERT_FOR_FILE = 1;
    private static final byte CONVERT_FOR_ASSERT = 2;
    private static final byte CONVERT_FOR_CREATE = 4;
    private LruCache<String, CacheMetaData> mMemoryCache;
    private DiskCacheProvider mFileCache;
    private Context mContext;

    public CacheManager(Context content, String cacheDir, int memoryCacheSizeInKB, int fileCacheSizeInKB) {
        this.mContext = content;
        if (TextUtils.isEmpty((CharSequence)cacheDir)) {
            throw new IllegalArgumentException("cacheDir can not be empty");
        }
        if (memoryCacheSizeInKB <= 0) {
            throw new IllegalArgumentException("memoryCacheSizeInKB <= 0");
        }
        if (fileCacheSizeInKB <= 0) {
            throw new IllegalArgumentException("fileCacheSizeInKB <= 0");
        }
        this.mMemoryCache = new LruCache<String, CacheMetaData>(memoryCacheSizeInKB * 1024){

            protected int sizeOf(String key, CacheMetaData value) {
                return value.getSize() + key.getBytes().length;
            }
        };
        DiskFileUtils.CacheDirInfo cacheDirInfo = DiskFileUtils.getDiskCacheDir(content, cacheDir, fileCacheSizeInKB, null);
        this.mFileCache = DiskCacheProvider.createLru(content, cacheDirInfo.path, cacheDirInfo.realSize);
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"CacheManger: cache dir: %s => %s, size: %s => %s", (Object[])new Object[]{cacheDir, cacheDirInfo.path, cacheDirInfo.requireSize, cacheDirInfo.realSize});
        }
    }

    public <T> void requestCache(ICacheAble<T> cacheAble) {
        InnerCacheTask<T> task = new InnerCacheTask<T>(cacheAble);
        task.beginQuery();
    }

    public <T> void continueAfterCreateData(ICacheAble<T> cacheAble, String data) {
        this.setCacheData(cacheAble.getCacheKey(), data);
        InnerCacheTask<T> task = new InnerCacheTask<T>(cacheAble);
        ((InnerCacheTask)task).beginConvertDataAsync((byte)4);
    }

    public void setCacheData(final String cacheKey, final String data) {
        if (TextUtils.isEmpty((CharSequence)cacheKey) || TextUtils.isEmpty((CharSequence)data)) {
            return;
        }
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"key: %s, setCacheData", (Object[])new Object[]{cacheKey});
        }
        SimpleExecutor.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                CacheMetaData cacheMetaData = CacheMetaData.createForNow(data);
                CacheManager.this.putDataToMemoryCache(cacheKey, cacheMetaData);
                CacheManager.this.mFileCache.write(cacheKey, cacheMetaData.getCacheData());
                CacheManager.this.mFileCache.flushDiskCacheAsyncWithDelay(1000);
            }
        });
    }

    private void putDataToMemoryCache(String key, CacheMetaData data) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"key: %s, set cache to runtime cache list", (Object[])new Object[]{key});
        }
        this.mMemoryCache.put((Object)key, (Object)data);
    }

    public void invalidateCache(String key) {
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"key: %s, invalidateCache", (Object[])new Object[]{key});
        }
        try {
            this.mFileCache.getDiskCache().delete(key);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mMemoryCache.remove((Object)key);
    }

    public void clearMemoryCache() {
        if (this.mMemoryCache != null) {
            this.mMemoryCache.evictAll();
        }
    }

    public int getMemoryCacheUsedSpace() {
        return this.mMemoryCache.size();
    }

    public int getMemoryCacheMaxSpace() {
        return this.mMemoryCache.maxSize();
    }

    public void clearDiskCache() {
        if (null != this.mFileCache) {
            try {
                this.mFileCache.getDiskCache().clear();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getFileCachePath() {
        if (null != this.mFileCache) {
            return this.mFileCache.getDiskCache().getDirectory().getAbsolutePath();
        }
        return null;
    }

    public long getFileCacheUsedSpace() {
        return null != this.mFileCache ? this.mFileCache.getDiskCache().getSize() : 0L;
    }

    public long getFileCacheMaxSpace() {
        if (null != this.mFileCache) {
            return this.mFileCache.getDiskCache().getCapacity();
        }
        return 0L;
    }

    public <T> T requestCacheSync(ICacheAble<T> cacheAble) {
        String assertInitDataPath;
        String cacheContent;
        boolean hasFileCache;
        if (cacheAble.cacheIsDisabled()) {
            return null;
        }
        String cacheKey = cacheAble.getCacheKey();
        CacheMetaData mRawData = (CacheMetaData)this.mMemoryCache.get((Object)cacheKey);
        if (mRawData != null && DEBUG) {
            CLog.d((String)LOG_TAG, (String)"key: %s, exist in list", (Object[])new Object[]{cacheKey});
        }
        if (mRawData == null && (hasFileCache = this.mFileCache.getDiskCache().has(cacheKey))) {
            cacheContent = this.mFileCache.read(cacheKey);
            JsonData jsonData = JsonData.create(cacheContent);
            mRawData = CacheMetaData.createFromJson(jsonData);
        }
        if (mRawData == null && (assertInitDataPath = cacheAble.getAssertInitDataPath()) != null && assertInitDataPath.length() > 0) {
            cacheContent = DiskFileUtils.readAssert(this.mContext, assertInitDataPath);
            mRawData = CacheMetaData.createInvalidated(cacheContent);
            this.putDataToMemoryCache(cacheKey, mRawData);
        }
        if (mRawData != null) {
            boolean outOfDate = mRawData.isOutOfDateFor(cacheAble);
            if (outOfDate && !cacheAble.useCacheAnyway()) {
                return null;
            }
            JsonData data = JsonData.create(mRawData.getData());
            T ret = cacheAble.processRawDataFromCache(data);
            cacheAble.onCacheData(CacheResultType.FROM_INIT_FILE, ret, outOfDate);
            return ret;
        }
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"key: %s, cache file not exist", (Object[])new Object[]{cacheKey});
        }
        return null;
    }

    public DiskCacheProvider getDiskCacheProvider() {
        return this.mFileCache;
    }

    private class InnerCacheTask<T1>
    extends SimpleTask {
        private ICacheAble<T1> mCacheAble;
        private CacheMetaData mRawData;
        private T1 mResult;
        private byte mWorkType = 0;
        private byte mConvertFor = 0;
        private byte mCurrentStatus = 0;

        public InnerCacheTask(ICacheAble<T1> cacheAble) {
            this.mCacheAble = cacheAble;
        }

        void beginQuery() {
            String cacheKey = this.mCacheAble.getCacheKey();
            if (this.mCacheAble.cacheIsDisabled()) {
                if (DEBUG) {
                    CLog.d((String)CacheManager.LOG_TAG, (String)"key: %s, Cache is disabled, query from server", (Object[])new Object[]{cacheKey});
                }
                this.mCacheAble.onNoCacheData(CacheManager.this);
                return;
            }
            this.mRawData = (CacheMetaData)CacheManager.this.mMemoryCache.get((Object)cacheKey);
            if (this.mRawData != null) {
                if (DEBUG) {
                    CLog.d((String)CacheManager.LOG_TAG, (String)"key: %s, exist in list", (Object[])new Object[]{cacheKey});
                }
                this.beginConvertDataAsync((byte)3);
                return;
            }
            boolean hasFileCache = CacheManager.this.mFileCache.getDiskCache().has(cacheKey);
            if (hasFileCache) {
                this.beginQueryFromCacheFileAsync();
                return;
            }
            String assertInitDataPath = this.mCacheAble.getAssertInitDataPath();
            if (assertInitDataPath != null && assertInitDataPath.length() > 0) {
                this.beginQueryFromAssertCacheFileAsync();
                return;
            }
            if (DEBUG) {
                CLog.d((String)CacheManager.LOG_TAG, (String)"key: %s, cache file not exist", (Object[])new Object[]{this.mCacheAble.getCacheKey()});
            }
            this.mCacheAble.onNoCacheData(CacheManager.this);
        }

        @Override
        public void doInBackground() {
            if (DEBUG) {
                CLog.d((String)CacheManager.LOG_TAG, (String)"key: %s, doInBackground: mWorkType: %s", (Object[])new Object[]{this.mCacheAble.getCacheKey(), this.mWorkType});
            }
            switch (this.mWorkType) {
                case 1: {
                    this.doQueryFromCacheFileInBackground();
                    this.setCurrentStatus((byte)1);
                    break;
                }
                case 2: {
                    this.doQueryFromAssertCacheFileInBackground();
                    this.setCurrentStatus((byte)2);
                    break;
                }
                case 4: {
                    this.doConvertDataInBackground();
                    this.setCurrentStatus((byte)4);
                    break;
                }
            }
        }

        @Override
        public void onFinish(boolean canceled) {
            switch (this.mCurrentStatus) {
                case 1: {
                    this.beginConvertDataAsync((byte)1);
                    break;
                }
                case 2: {
                    this.beginConvertDataAsync((byte)2);
                    break;
                }
                case 4: {
                    this.done();
                    break;
                }
            }
        }

        private void beginQueryFromCacheFileAsync() {
            if (DEBUG) {
                CLog.d((String)CacheManager.LOG_TAG, (String)"key: %s, beginQueryFromCacheFileAsync", (Object[])new Object[]{this.mCacheAble.getCacheKey()});
            }
            this.mWorkType = 1;
            this.restart();
            SimpleExecutor.getInstance().execute(this);
        }

        private void beginQueryFromAssertCacheFileAsync() {
            if (DEBUG) {
                CLog.d((String)CacheManager.LOG_TAG, (String)"key: %s, beginQueryFromAssertCacheFileAsync", (Object[])new Object[]{this.mCacheAble.getCacheKey()});
            }
            this.mWorkType = (byte)2;
            this.restart();
            SimpleExecutor.getInstance().execute(this);
        }

        private void beginConvertDataAsync(byte convertFor) {
            if (DEBUG) {
                CLog.d((String)CacheManager.LOG_TAG, (String)"key: %s, beginConvertDataAsync", (Object[])new Object[]{this.mCacheAble.getCacheKey()});
            }
            this.mConvertFor = convertFor;
            this.mWorkType = (byte)4;
            this.restart();
            SimpleExecutor.getInstance().execute(this);
        }

        private void doQueryFromCacheFileInBackground() {
            if (DEBUG) {
                CLog.d((String)CacheManager.LOG_TAG, (String)"key: %s, try read cache data from file", (Object[])new Object[]{this.mCacheAble.getCacheKey()});
            }
            String cacheContent = CacheManager.this.mFileCache.read(this.mCacheAble.getCacheKey());
            JsonData jsonData = JsonData.create(cacheContent);
            this.mRawData = CacheMetaData.createFromJson(jsonData);
        }

        private void doQueryFromAssertCacheFileInBackground() {
            if (DEBUG) {
                CLog.d((String)CacheManager.LOG_TAG, (String)"key: %s, try read cache data from assert file", (Object[])new Object[]{this.mCacheAble.getCacheKey()});
            }
            String cacheContent = DiskFileUtils.readAssert(CacheManager.this.mContext, this.mCacheAble.getAssertInitDataPath());
            this.mRawData = CacheMetaData.createInvalidated(cacheContent);
            CacheManager.this.putDataToMemoryCache(this.mCacheAble.getCacheKey(), this.mRawData);
        }

        private void doConvertDataInBackground() {
            if (DEBUG) {
                CLog.d((String)CacheManager.LOG_TAG, (String)"key: %s, doConvertDataInBackground", (Object[])new Object[]{this.mCacheAble.getCacheKey()});
            }
            JsonData data = JsonData.create(this.mRawData.getData());
            this.mResult = this.mCacheAble.processRawDataFromCache(data);
        }

        private void setCurrentStatus(byte status) {
            this.mCurrentStatus = status;
            if (DEBUG) {
                CLog.d((String)CacheManager.LOG_TAG, (String)"key: %s, setCurrentStatus: %s", (Object[])new Object[]{this.mCacheAble.getCacheKey(), status});
            }
        }

        private void done() {
            boolean outOfDate = this.mRawData.isOutOfDateFor(this.mCacheAble);
            if (this.mResult != null) {
                switch (this.mConvertFor) {
                    case 2: {
                        this.mCacheAble.onCacheData(CacheResultType.FROM_INIT_FILE, this.mResult, outOfDate);
                        break;
                    }
                    case 4: {
                        this.mCacheAble.onCacheData(CacheResultType.FROM_CREATED, this.mResult, outOfDate);
                        break;
                    }
                    case 1: {
                        this.mCacheAble.onCacheData(CacheResultType.FROM_INIT_FILE, this.mResult, outOfDate);
                        break;
                    }
                    case 3: {
                        this.mCacheAble.onCacheData(CacheResultType.FROM_CACHE_FILE, this.mResult, outOfDate);
                    }
                }
            }
            if (this.mResult == null || outOfDate) {
                this.mCacheAble.onNoCacheData(CacheManager.this);
            }
        }
    }
}

