/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.cache;

import android.content.Context;
import android.text.TextUtils;
import in.srain.cube.Cube;
import in.srain.cube.cache.CacheManager;

public class CacheManagerFactory {
    private static CacheManager sDefault;
    private static final String DEFAULT_CACHE_DIR = "cube-default-cache";
    private static final int DEFAULT_CACHE_MEMORY_CACHE_SIZE = 1024;
    private static final int DEFAULT_CACHE_DISK_CACHE_SIZE = 10240;

    public static CacheManager getDefault() {
        if (sDefault == null) {
            CacheManagerFactory.initDefaultCache(Cube.getInstance().getContext(), DEFAULT_CACHE_DIR, 1024, 10240);
        }
        return sDefault;
    }

    public static void initDefaultCache(Context content, String cacheDir, int memoryCacheSizeInKB, int fileCacheSizeInKB) {
        if (TextUtils.isEmpty((CharSequence)cacheDir)) {
            cacheDir = DEFAULT_CACHE_DIR;
        }
        if (memoryCacheSizeInKB <= 0) {
            memoryCacheSizeInKB = 1024;
        }
        if (fileCacheSizeInKB <= 0) {
            fileCacheSizeInKB = 10240;
        }
        sDefault = new CacheManager(content, cacheDir, memoryCacheSizeInKB, fileCacheSizeInKB);
    }
}

