/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.cache;

import in.srain.cube.cache.ICacheAble;
import in.srain.cube.request.JsonData;
import org.json.JSONObject;

public class CacheMetaData {
    private String mData;
    private long mTime;
    private int mSize;

    public static CacheMetaData createForNow(String data) {
        CacheMetaData info = new CacheMetaData(data);
        info.mTime = (int)(System.currentTimeMillis() / 1000L);
        return info;
    }

    public static CacheMetaData createInvalidated(String data) {
        return CacheMetaData.create(data, -2L);
    }

    public static CacheMetaData createFromJson(JsonData jsonData) {
        return CacheMetaData.create(jsonData.optString("data"), jsonData.optInt("time"));
    }

    private static CacheMetaData create(String data, long time) {
        CacheMetaData cacheMetaData = new CacheMetaData(data);
        cacheMetaData.mTime = time;
        return cacheMetaData;
    }

    private CacheMetaData(String data) {
        this.mData = data;
        this.mSize = data.getBytes().length + 8;
    }

    public int getSize() {
        return this.mSize;
    }

    public long getTime() {
        return this.mTime;
    }

    public boolean isOutOfDateFor(ICacheAble<?> cacheAble) {
        long lastTime = this.getTime();
        long timeInterval = System.currentTimeMillis() / 1000L - lastTime;
        boolean outOfDate = timeInterval > cacheAble.getCacheTime() || timeInterval < 0L;
        return outOfDate;
    }

    public String getData() {
        return this.mData;
    }

    public String getCacheData() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("time", this.mTime);
            jsonObject.put("data", (Object)this.mData);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonObject.toString();
    }
}

