/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.cache;

import android.content.Context;
import in.srain.cube.concurrent.SimpleExecutor;
import in.srain.cube.concurrent.SimpleTask;
import in.srain.cube.diskcache.CacheEntry;
import in.srain.cube.diskcache.DiskCache;
import in.srain.cube.diskcache.lru.SimpleDiskLruCache;
import in.srain.cube.util.CLog;
import java.io.File;
import java.io.IOException;

public class DiskCacheProvider {
    public static final boolean DEBUG = true;
    protected static final String LOG_TAG = "cube-disk-cache-provider";
    public static final byte TASK_INIT_CACHE = 1;
    public static final byte TASK_CLOSE_CACHE = 2;
    public static final byte TASK_FLUSH_CACHE = 3;
    protected DiskCache mDiskCache;
    private boolean mIsDelayFlushing = false;
    private final Object mDiskCacheLock = new Object();
    private boolean mDiskCacheStarting = true;
    private boolean mDiskCacheReady = false;
    private AsyncTaskEventHandler mAsyncTaskEventHandler;

    public void setAsyncTaskEventHandler(AsyncTaskEventHandler handler) {
        this.mAsyncTaskEventHandler = handler;
    }

    public DiskCacheProvider(DiskCache diskCache) {
        this.mDiskCache = diskCache;
    }

    public static DiskCacheProvider createLru(Context context, File path, long size) {
        SimpleDiskLruCache simpleDiskLruCache = new SimpleDiskLruCache(path, 1, size);
        DiskCacheProvider provider = new DiskCacheProvider(simpleDiskLruCache);
        return provider;
    }

    public void write(String key, String str) {
        if (key == null) {
            return;
        }
        try {
            CacheEntry cacheEntry = this.getDiskCache().beginEdit(key);
            cacheEntry.setString(str);
            cacheEntry.commit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String read(String fileCacheKey) {
        try {
            CacheEntry cacheEntry = this.getDiskCache().getEntry(fileCacheKey);
            if (cacheEntry != null) {
                return cacheEntry.getString();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDiskCacheAsync() {
        CLog.d((String)LOG_TAG, (String)"%s: initDiskCacheAsync", (Object[])new Object[]{this.mDiskCache});
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            this.mDiskCacheStarting = true;
            new FileCacheTask(1).executeNow();
        }
    }

    public void closeDiskCacheAsync() {
        CLog.d((String)LOG_TAG, (String)"%s: closeDiskCacheAsync", (Object[])new Object[]{this.mDiskCache});
        new FileCacheTask(2).executeNow();
    }

    public void flushDiskCacheAsync() {
        CLog.d((String)LOG_TAG, (String)"%s, flushDishCacheAsync", (Object[])new Object[]{this.mDiskCache});
        new FileCacheTask(3).executeNow();
    }

    public void flushDiskCacheAsyncWithDelay(int delay) {
        CLog.d((String)LOG_TAG, (String)"%s, flushDiskCacheAsyncWithDelay", (Object[])new Object[]{delay});
        if (this.mIsDelayFlushing) {
            return;
        }
        this.mIsDelayFlushing = true;
        new FileCacheTask(3).executeAfter(delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskCache getDiskCache() {
        if (!this.mDiskCacheReady) {
            CLog.d((String)LOG_TAG, (String)"%s, try to access disk cache, but it is not open, try to open it.", (Object[])new Object[]{this.mDiskCache});
            this.openDiskCacheAsync();
        }
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            while (this.mDiskCacheStarting) {
                try {
                    CLog.d((String)LOG_TAG, (String)"%s, try to access, but disk cache is not ready, wait", (Object[])new Object[]{this.mDiskCache});
                    this.mDiskCacheLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.mDiskCache;
    }

    private class FileCacheTask
    extends SimpleTask {
        private byte mTaskType;

        private FileCacheTask(byte taskType) {
            this.mTaskType = taskType;
        }

        @Override
        public void doInBackground() {
            try {
                this.doWork();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doWork() throws IOException {
            switch (this.mTaskType) {
                case 1: {
                    Object object = DiskCacheProvider.this.mDiskCacheLock;
                    synchronized (object) {
                        CLog.d((String)DiskCacheProvider.LOG_TAG, (String)("begin open disk cache: " + DiskCacheProvider.this.mDiskCache));
                        DiskCacheProvider.this.mDiskCache.open();
                        DiskCacheProvider.this.mDiskCacheReady = true;
                        DiskCacheProvider.this.mDiskCacheStarting = false;
                        CLog.d((String)DiskCacheProvider.LOG_TAG, (String)("disk cache open successfully, notify all lock: " + DiskCacheProvider.this.mDiskCache));
                        DiskCacheProvider.this.mDiskCacheLock.notifyAll();
                        break;
                    }
                }
                case 2: {
                    DiskCacheProvider.this.mDiskCache.close();
                    break;
                }
                case 3: {
                    DiskCacheProvider.this.mDiskCache.flush();
                    break;
                }
            }
        }

        @Override
        public void onFinish(boolean canceled) {
            if (DiskCacheProvider.this.mAsyncTaskEventHandler != null) {
                DiskCacheProvider.this.mAsyncTaskEventHandler.onEvent(this.mTaskType);
            }
        }

        void executeNow() {
            SimpleExecutor.getInstance().execute(this);
        }

        void executeAfter(int delay) {
            FileCacheTask.postDelay(new Runnable(){

                @Override
                public void run() {
                    FileCacheTask.this.executeNow();
                }
            }, delay);
        }
    }

    public static interface AsyncTaskEventHandler {
        public void onEvent(int var1);
    }
}

