/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.cache;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;
import android.os.StatFs;
import android.text.TextUtils;
import in.srain.cube.util.CLog;
import in.srain.cube.util.Version;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;

public class DiskFileUtils {
    public static CacheDirInfo getDiskCacheDir(Context context, String absolutePath, int sizeInKB, String fallbackRelativePath) {
        File cachePath;
        long size = (long)sizeInKB * 1024L;
        boolean done = false;
        CacheDirInfo dirInfo = new CacheDirInfo();
        dirInfo.requireSize = size;
        if (!TextUtils.isEmpty((CharSequence)absolutePath) && ((cachePath = new File(absolutePath)).exists() || cachePath.mkdirs())) {
            long free = DiskFileUtils.getUsableSpace(cachePath);
            dirInfo.realSize = size = Math.min(size, free);
            dirInfo.path = cachePath;
            done = true;
        }
        if (!done) {
            if (TextUtils.isEmpty((CharSequence)fallbackRelativePath)) {
                fallbackRelativePath = absolutePath;
            }
            dirInfo = DiskFileUtils.getDiskCacheDir(context, fallbackRelativePath, size);
        }
        return dirInfo;
    }

    public static CacheDirInfo getDiskCacheDir(Context context, String uniqueName, long requireSpace) {
        File sdPath = null;
        File internalPath = null;
        Long sdCardFree = 0L;
        boolean usingInternal = false;
        if (DiskFileUtils.hasSDCardMounted()) {
            sdPath = DiskFileUtils.getExternalCacheDir(context);
            if (!sdPath.exists()) {
                sdPath.mkdirs();
            }
            sdCardFree = DiskFileUtils.getUsableSpace(sdPath);
        }
        CacheDirInfo cacheDirInfo = new CacheDirInfo();
        cacheDirInfo.requireSize = requireSpace;
        if (sdPath == null || sdCardFree < requireSpace) {
            internalPath = context.getCacheDir();
            long internalFree = DiskFileUtils.getUsableSpace(internalPath);
            if (internalFree < requireSpace) {
                if (internalFree > sdCardFree) {
                    usingInternal = true;
                    cacheDirInfo.realSize = internalFree;
                } else {
                    usingInternal = false;
                    cacheDirInfo.realSize = sdCardFree;
                }
                cacheDirInfo.isNotEnough = true;
            } else {
                usingInternal = true;
                cacheDirInfo.realSize = requireSpace;
            }
        } else {
            usingInternal = false;
            cacheDirInfo.realSize = requireSpace;
        }
        cacheDirInfo.isInternal = usingInternal;
        cacheDirInfo.path = usingInternal ? new File(internalPath.getPath() + File.separator + uniqueName) : new File(sdPath.getPath() + File.separator + uniqueName);
        if (!cacheDirInfo.path.exists() && !cacheDirInfo.path.mkdirs()) {
            CLog.e((String)"cube-cache", (String)"can not create directory for: %s", (Object[])new Object[]{cacheDirInfo.path});
        }
        return cacheDirInfo;
    }

    @TargetApi(value=8)
    public static File getExternalCacheDir(Context context) {
        File path;
        if (Version.hasFroyo() && (path = context.getExternalCacheDir()) != null) {
            return path;
        }
        String cacheDir = "/Android/data/" + context.getPackageName() + "/cache/";
        return new File(Environment.getExternalStorageDirectory().getPath() + cacheDir);
    }

    @TargetApi(value=9)
    public static long getUsableSpace(File path) {
        if (path == null) {
            return -1L;
        }
        if (Version.hasGingerbread()) {
            return path.getUsableSpace();
        }
        if (!path.exists()) {
            return 0L;
        }
        StatFs stats = new StatFs(path.getPath());
        return (long)stats.getBlockSize() * (long)stats.getAvailableBlocks();
    }

    @TargetApi(value=9)
    public static long getUsedSpace(File path) {
        if (path == null) {
            return -1L;
        }
        if (Version.hasGingerbread()) {
            return path.getTotalSpace() - path.getUsableSpace();
        }
        if (!path.exists()) {
            return -1L;
        }
        StatFs stats = new StatFs(path.getPath());
        return (long)stats.getBlockSize() * (long)(stats.getBlockCount() - stats.getAvailableBlocks());
    }

    @TargetApi(value=9)
    public static long getTotalSpace(File path) {
        if (path == null) {
            return -1L;
        }
        if (Version.hasGingerbread()) {
            return path.getTotalSpace();
        }
        if (!path.exists()) {
            return 0L;
        }
        StatFs stats = new StatFs(path.getPath());
        return (long)stats.getBlockSize() * (long)stats.getBlockCount();
    }

    public static boolean hasSDCardMounted() {
        String state = Environment.getExternalStorageState();
        return state != null && state.equals("mounted");
    }

    public static String wantFilesPath(Context context, boolean externalStorageFirst) {
        String path = null;
        File f = null;
        path = externalStorageFirst && DiskFileUtils.hasSDCardMounted() && (f = context.getExternalFilesDir("xxx")) != null ? f.getAbsolutePath() : context.getFilesDir().getAbsolutePath();
        return path;
    }

    public static String readAssert(Context context, String filePath) {
        try {
            if (filePath.startsWith(File.separator)) {
                filePath = filePath.substring(File.separator.length());
            }
            AssetManager assetManager = context.getAssets();
            InputStream inputStream = assetManager.open(filePath);
            DataInputStream stream = new DataInputStream(inputStream);
            int length = stream.available();
            byte[] buffer = new byte[length];
            stream.readFully(buffer);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(buffer);
            stream.close();
            return byteArrayOutputStream.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class CacheDirInfo {
        public File path;
        public boolean isInternal = false;
        public boolean isNotEnough = false;
        public long realSize;
        public long requireSize;
    }
}

