/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.cache;

import android.text.TextUtils;
import in.srain.cube.cache.CacheManager;
import in.srain.cube.cache.CacheResultType;
import in.srain.cube.cache.ICacheAble;
import in.srain.cube.cache.QueryHandler;
import in.srain.cube.request.JsonData;

public class Query<T>
implements ICacheAble<T> {
    private QueryHandler mHandler;
    private CacheManager mCacheManager;
    private long mCacheTime = 86400L;
    private String mCacheKey;
    private boolean mUseCacheAnyway = false;
    private boolean mDisable = false;
    private String mInitAssertPath = null;

    public Query(CacheManager cacheManager) {
        this.mCacheManager = cacheManager;
    }

    public void continueAfterCreateData(String data) {
        if (!TextUtils.isEmpty((CharSequence)data)) {
            this.mCacheManager.continueAfterCreateData(this, data);
        } else {
            this.queryFail();
        }
    }

    @Override
    public Query<T> setCacheTime(long time) {
        this.mCacheTime = time;
        return this;
    }

    private void queryFail() {
        this.mHandler.onQueryFinish(RequestType.FAIL, null, true);
    }

    public <T> void setHandler(QueryHandler<T> handler) {
        this.mHandler = handler;
    }

    public void query() {
        this.mCacheManager.requestCache(this);
    }

    @Override
    public long getCacheTime() {
        return this.mCacheTime;
    }

    @Override
    public String getCacheKey() {
        return this.mCacheKey;
    }

    @Override
    public Query<T> setCacheKey(String key) {
        this.mCacheKey = key;
        return this;
    }

    @Override
    public Query<T> setUseCacheAnyway(boolean use) {
        this.mUseCacheAnyway = use;
        return this;
    }

    @Override
    public boolean useCacheAnyway() {
        return this.mUseCacheAnyway;
    }

    @Override
    public Query<T> setAssertInitDataPath(String path) {
        this.mInitAssertPath = path;
        return this;
    }

    @Override
    public String getAssertInitDataPath() {
        return this.mInitAssertPath;
    }

    @Override
    public T processRawDataFromCache(JsonData rawData) {
        if (this.mHandler != null) {
            return this.mHandler.processRawDataFromCache(rawData);
        }
        return null;
    }

    @Override
    public void onCacheData(CacheResultType cacheResultType, T cacheData, boolean outOfDate) {
        switch (cacheResultType) {
            case FROM_CACHE_FILE: {
                break;
            }
            case FROM_INIT_FILE: {
                break;
            }
            case FROM_MEMORY: {
                break;
            }
        }
        if (outOfDate) {
            if (this.mHandler != null && this.mUseCacheAnyway) {
                this.mHandler.onQueryFinish(RequestType.USE_CACHE_ANYWAY, cacheData, outOfDate);
            }
        } else {
            switch (cacheResultType) {
                case FROM_CACHE_FILE: {
                    break;
                }
                case FROM_INIT_FILE: {
                    break;
                }
                case FROM_MEMORY: {
                    break;
                }
            }
            this.mHandler.onQueryFinish(RequestType.USE_CACHE_NOT_EXPIRED, cacheData, true);
        }
    }

    @Override
    public void onNoCacheData(CacheManager cacheManager) {
        if (this.mHandler != null) {
            this.continueAfterCreateData(this.mHandler.createDataForCache(this));
        } else {
            this.queryFail();
        }
    }

    @Override
    public Query<T> setDisableCache(boolean disable) {
        this.mDisable = disable;
        return this;
    }

    @Override
    public boolean cacheIsDisabled() {
        return this.mHandler != null && this.mDisable;
    }

    public static enum RequestType {
        USE_CACHE_NOT_EXPIRED,
        USE_DATA_CREATED,
        USE_CACHE_ANYWAY,
        FAIL;

    }
}

