/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.diskcache;

import in.srain.cube.diskcache.DiskCache;
import in.srain.cube.diskcache.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public class CacheEntry {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final String mKey;
    private DiskCache mDiskCache;
    private long mOldSize;
    private long mSize;
    private boolean mIsUnderEdit;
    private boolean hasErrors;

    public CacheEntry(DiskCache diskCache, String key) {
        this.mDiskCache = diskCache;
        this.mKey = key;
    }

    private static String inputStreamToString(InputStream in) throws IOException {
        return FileUtils.readFully(new InputStreamReader(in, UTF_8));
    }

    public boolean isUnderEdit() {
        return this.mIsUnderEdit;
    }

    public String getKey() {
        return this.mKey;
    }

    public File getCacheFile() {
        return new File(this.mDiskCache.getDirectory(), this.mKey);
    }

    public long getSize() {
        return this.mSize;
    }

    public void setSize(long size) {
        this.mSize = size;
    }

    public long getLastSize() {
        return this.mOldSize;
    }

    public File getTempFile() {
        return new File(this.mDiskCache.getDirectory(), this.mKey + ".tmp");
    }

    public boolean isReadable() {
        return this.getCacheFile().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        DiskCache diskCache = this.mDiskCache;
        synchronized (diskCache) {
            if (!this.isReadable()) {
                return null;
            }
            return new FileInputStream(this.getCacheFile());
        }
    }

    public String getString() throws IOException {
        InputStream in = this.getInputStream();
        return in != null ? CacheEntry.inputStreamToString(in) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntry setString(String value) throws IOException {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(this.newOutputStream(), UTF_8);
            writer.write(value);
        }
        catch (Throwable throwable) {
            FileUtils.closeQuietly(writer);
            throw throwable;
        }
        FileUtils.closeQuietly(writer);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream newOutputStream() throws IOException {
        DiskCache diskCache = this.mDiskCache;
        synchronized (diskCache) {
            if (this.mIsUnderEdit) {
                throw new IllegalStateException();
            }
            this.mIsUnderEdit = true;
            File tempFile = this.getTempFile();
            File parent = tempFile.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new IOException("Can not make sure the parent directory exist.");
            }
            return new FaultHidingOutputStream(new FileOutputStream(tempFile));
        }
    }

    public boolean delete() throws IOException {
        if (this.mIsUnderEdit) {
            throw new IOException("Try to delete an cache entry that has been being editing.");
        }
        FileUtils.deleteIfExists(this.getCacheFile());
        FileUtils.deleteIfExists(this.getTempFile());
        return true;
    }

    public void commit() throws IOException {
        if (!this.mIsUnderEdit) {
            throw new IOException("CacheEntry has been closed.");
        }
        if (this.hasErrors) {
            this.mDiskCache.delete(this.mKey);
        } else {
            File dirty = this.getTempFile();
            if (dirty.exists()) {
                File clean = this.getCacheFile();
                dirty.renameTo(clean);
                this.mOldSize = this.mSize;
                this.mSize = clean.length();
                this.mDiskCache.commitEdit(this);
            } else {
                this.abortEdit();
            }
        }
        this.mIsUnderEdit = false;
    }

    public synchronized void abortEdit() throws IOException {
        if (!this.mIsUnderEdit) {
            return;
        }
        this.mIsUnderEdit = false;
        FileUtils.deleteIfExists(this.getTempFile());
        this.mDiskCache.abortEdit(this);
    }

    private class FaultHidingOutputStream
    extends FilterOutputStream {
        private FaultHidingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int oneByte) {
            try {
                this.out.write(oneByte);
            }
            catch (IOException e) {
                CacheEntry.this.hasErrors = true;
            }
        }

        @Override
        public void write(byte[] buffer, int offset, int length) {
            try {
                this.out.write(buffer, offset, length);
            }
            catch (IOException e) {
                CacheEntry.this.hasErrors = true;
            }
        }

        @Override
        public void close() {
            try {
                this.out.close();
            }
            catch (IOException e) {
                CacheEntry.this.hasErrors = true;
            }
        }

        @Override
        public void flush() {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                CacheEntry.this.hasErrors = true;
            }
        }
    }
}

