/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.diskcache.lru;

import in.srain.cube.diskcache.CacheEntry;
import in.srain.cube.diskcache.DiskCache;
import in.srain.cube.diskcache.FileUtils;
import in.srain.cube.diskcache.lru.SimpleDiskLruCache;
import in.srain.cube.set.hash.SimpleHashSet;
import in.srain.cube.util.CLog;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class LruActionTracer
implements Runnable {
    static final int REDUNDANT_OP_COMPACT_THRESHOLD = 2000;
    static final String JOURNAL_FILE = "journal";
    static final String JOURNAL_FILE_TMP = "journal.tmp";
    static final String MAGIC = "lru-tracer";
    static final String VERSION_1 = "1";
    private static final byte ACTION_CLEAN = 1;
    private static final byte ACTION_DIRTY = 2;
    private static final byte ACTION_DELETE = 3;
    private static final byte ACTION_READ = 4;
    private static final byte ACTION_PENDING_DELETE = 5;
    private static final byte ACTION_FLUSH = 6;
    private static final String[] sACTION_LIST = new String[]{"UN_KNOW", "CLEAN", "DIRTY", "DELETE", "READ", "DELETE_PENDING", "FLUSH"};
    private static final int IO_BUFFER_SIZE = 8192;
    private static final byte[] sPoolSync = new byte[0];
    private static final int MAX_POOL_SIZE = 50;
    private static ActionMessage sPoolHeader;
    private static int sPoolSize;
    private final LinkedHashMap<String, CacheEntry> mLruEntries = new LinkedHashMap(0, 0.75f, true);
    private final ExecutorService mExecutorService = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final File mJournalFile;
    private final File mJournalFileTmp;
    private boolean mIsRunning = false;
    private DiskCache mDiskCache;
    private long mSize = 0L;
    private ConcurrentLinkedQueue<ActionMessage> mActionQueue;
    private File mDirectory;
    private long mCapacity;
    private int mAppVersion;
    private SimpleHashSet mNewCreateList;
    private Object mLock = new Object();
    private Writer mJournalWriter;
    private int mRedundantOpCount;
    private HashMap<String, CacheEntry> mEditList;

    public LruActionTracer(DiskCache diskCache, File directory, int appVersion, long capacity) {
        this.mDiskCache = diskCache;
        this.mJournalFile = new File(directory, JOURNAL_FILE);
        this.mJournalFileTmp = new File(directory, JOURNAL_FILE_TMP);
        this.mDirectory = directory;
        this.mAppVersion = appVersion;
        this.mCapacity = capacity;
        this.mNewCreateList = new SimpleHashSet();
        this.mEditList = new HashMap();
        this.mActionQueue = new ConcurrentLinkedQueue();
    }

    private static void validateKey(String key) {
        if (key.contains(" ") || key.contains("\n") || key.contains("\r")) {
            throw new IllegalArgumentException("keys must not contain spaces or newlines: \"" + key + "\"");
        }
    }

    public void tryToResume() throws IOException {
        if (this.mJournalFile.exists()) {
            try {
                this.readJournal();
                this.processJournal();
                this.mJournalWriter = new BufferedWriter(new FileWriter(this.mJournalFile, true), 8192);
                if (SimpleDiskLruCache.DEBUG) {
                    CLog.d((String)"cube-disk-cache-simple-lru", (String)"open success");
                }
            }
            catch (IOException journalIsCorrupt) {
                journalIsCorrupt.printStackTrace();
                if (SimpleDiskLruCache.DEBUG) {
                    CLog.d((String)"cube-disk-cache-simple-lru", (String)"clear old cache");
                }
                this.clear();
            }
        } else {
            if (SimpleDiskLruCache.DEBUG) {
                CLog.d((String)"cube-disk-cache-simple-lru", (String)"create new cache");
            }
            if (this.mDirectory.exists()) {
                this.mDirectory.delete();
            }
            this.mDirectory.mkdirs();
            this.rebuildJournal();
        }
    }

    public synchronized void clear() throws IOException {
        for (CacheEntry cacheEntry : new ArrayList<CacheEntry>(this.mLruEntries.values())) {
            if (!cacheEntry.isUnderEdit()) continue;
            cacheEntry.abortEdit();
        }
        this.mLruEntries.clear();
        this.mSize = 0L;
        if (SimpleDiskLruCache.DEBUG) {
            CLog.d((String)"cube-disk-cache-simple-lru", (String)"delete directory");
        }
        this.waitJobDone();
        FileUtils.deleteDirectoryQuickly(this.mDirectory);
        this.rebuildJournal();
    }

    public synchronized CacheEntry getEntry(String key) throws IOException {
        this.checkNotClosed();
        LruActionTracer.validateKey(key);
        CacheEntry cacheEntry = this.mLruEntries.get(key);
        if (cacheEntry == null) {
            return null;
        }
        this.trimToSize();
        this.addActionLog((byte)4, cacheEntry);
        return cacheEntry;
    }

    public synchronized CacheEntry beginEdit(String key) throws IOException {
        CacheEntry cacheEntry;
        this.checkNotClosed();
        LruActionTracer.validateKey(key);
        if (SimpleDiskLruCache.DEBUG) {
            CLog.d((String)"cube-disk-cache-simple-lru", (String)"beginEdit: %s", (Object[])new Object[]{key});
        }
        if ((cacheEntry = this.mLruEntries.get(key)) == null) {
            cacheEntry = new CacheEntry(this.mDiskCache, key);
            this.mNewCreateList.add(key);
            this.mLruEntries.put(key, cacheEntry);
        }
        this.mEditList.put(key, cacheEntry);
        this.addActionLog((byte)2, cacheEntry);
        return cacheEntry;
    }

    public void abortEdit(String key) {
        CacheEntry cacheEntry = this.mEditList.get(key);
        if (cacheEntry != null) {
            try {
                cacheEntry.abortEdit();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void abortEdit(CacheEntry cacheEntry) {
        String cacheKey = cacheEntry.getKey();
        if (SimpleDiskLruCache.DEBUG) {
            CLog.d((String)"cube-disk-cache-simple-lru", (String)"abortEdit: %s", (Object[])new Object[]{cacheKey});
        }
        if (this.mNewCreateList.contains(cacheKey)) {
            this.mLruEntries.remove(cacheKey);
            this.mNewCreateList.remove(cacheKey);
        }
        this.mEditList.remove(cacheKey);
    }

    public void commitEdit(CacheEntry cacheEntry) throws IOException {
        if (SimpleDiskLruCache.DEBUG) {
            CLog.d((String)"cube-disk-cache-simple-lru", (String)"commitEdit: %s", (Object[])new Object[]{cacheEntry.getKey()});
        }
        this.mNewCreateList.remove(cacheEntry.getKey());
        this.mEditList.remove(cacheEntry.getKey());
        this.mSize += cacheEntry.getSize() - cacheEntry.getLastSize();
        this.addActionLog((byte)1, cacheEntry);
        this.trimToSize();
    }

    private void readJournalLine(String line) throws IOException {
        String[] parts = line.split(" ");
        if (parts.length < 2) {
            throw new IOException("unexpected journal line: " + line);
        }
        if (parts.length != 3) {
            throw new IOException("unexpected journal line: " + line);
        }
        String key = parts[1];
        if (parts[0].equals(sACTION_LIST[3])) {
            this.mLruEntries.remove(key);
            return;
        }
        CacheEntry cacheEntry = this.mLruEntries.get(key);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(this.mDiskCache, key);
            this.mLruEntries.put(key, cacheEntry);
        }
        if (parts[0].equals(sACTION_LIST[1])) {
            cacheEntry.setSize(Long.parseLong(parts[2]));
        } else if (!parts[0].equals(sACTION_LIST[2]) && !parts[0].equals(sACTION_LIST[4])) {
            throw new IOException("unexpected journal line: " + line);
        }
    }

    private void processJournal() throws IOException {
        FileUtils.deleteIfExists(this.mJournalFileTmp);
        Iterator<CacheEntry> i = this.mLruEntries.values().iterator();
        while (i.hasNext()) {
            CacheEntry cacheEntry = i.next();
            if (!cacheEntry.isUnderEdit()) {
                this.mSize += cacheEntry.getSize();
                continue;
            }
            cacheEntry.delete();
            i.remove();
        }
    }

    private synchronized void rebuildJournal() throws IOException {
        if (this.mJournalWriter != null) {
            this.mJournalWriter.close();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.mJournalFileTmp), 8192);
        writer.write(MAGIC);
        writer.write("\n");
        writer.write(VERSION_1);
        writer.write("\n");
        writer.write(Integer.toString(this.mAppVersion));
        writer.write("\n");
        writer.write("\n");
        for (CacheEntry cacheEntry : this.mLruEntries.values()) {
            if (cacheEntry.isUnderEdit()) {
                writer.write(sACTION_LIST[2] + ' ' + cacheEntry.getKey() + " " + cacheEntry.getSize() + '\n');
                continue;
            }
            writer.write(sACTION_LIST[1] + ' ' + cacheEntry.getKey() + " " + cacheEntry.getSize() + '\n');
        }
        ((Writer)writer).close();
        this.mJournalFileTmp.renameTo(this.mJournalFile);
        this.mJournalWriter = new BufferedWriter(new FileWriter(this.mJournalFile, true), 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readJournal() throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.mJournalFile), 8192);
        try {
            String magic = FileUtils.readAsciiLine(in);
            String version = FileUtils.readAsciiLine(in);
            String appVersionString = FileUtils.readAsciiLine(in);
            String blank = FileUtils.readAsciiLine(in);
            if (!(MAGIC.equals(magic) && VERSION_1.equals(version) && Integer.toString(this.mAppVersion).equals(appVersionString) && "".equals(blank))) {
                throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + blank + "]");
            }
            try {
                while (true) {
                    this.readJournalLine(FileUtils.readAsciiLine(in));
                }
            }
            catch (EOFException endOfJournal) {
                FileUtils.closeQuietly(in);
            }
        }
        catch (Throwable throwable) {
            FileUtils.closeQuietly(in);
            throw throwable;
        }
    }

    private void checkNotClosed() {
        if (this.mJournalFile == null) {
            throw new IllegalStateException("cache is closed");
        }
    }

    public synchronized void flush() throws IOException {
        this.checkNotClosed();
        this.trimToSize();
        this.addActionLog((byte)6, null);
        this.waitJobDone();
    }

    private void writeActionLog(byte action, CacheEntry cacheEntry) throws IOException {
        this.mJournalWriter.write(sACTION_LIST[action] + ' ' + cacheEntry.getKey() + ' ' + cacheEntry.getSize() + '\n');
        ++this.mRedundantOpCount;
        if (this.mRedundantOpCount >= 2000 && this.mRedundantOpCount >= this.mLruEntries.size()) {
            this.mRedundantOpCount = 0;
            this.rebuildJournal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doJob() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            while (!this.mActionQueue.isEmpty()) {
                ActionMessage message = this.mActionQueue.poll();
                CacheEntry cacheEntry = message.mCacheEntry;
                byte action = message.mAction;
                message.recycle();
                if (SimpleDiskLruCache.DEBUG) {
                    CLog.d((String)"cube-disk-cache-simple-lru", (String)"doAction: %s,\tkey: %s", (Object[])new Object[]{sACTION_LIST[action], cacheEntry != null ? cacheEntry.getKey() : null});
                }
                switch (action) {
                    case 4: {
                        this.writeActionLog(action, cacheEntry);
                        break;
                    }
                    case 2: {
                        this.writeActionLog(action, cacheEntry);
                        break;
                    }
                    case 1: {
                        this.writeActionLog(action, cacheEntry);
                        break;
                    }
                    case 3: {
                        this.writeActionLog(action, cacheEntry);
                        break;
                    }
                    case 5: {
                        this.writeActionLog(action, cacheEntry);
                        if (this.mLruEntries.containsKey(cacheEntry.getKey())) break;
                        cacheEntry.delete();
                        break;
                    }
                    case 6: {
                        this.mJournalWriter.flush();
                    }
                }
            }
            this.mLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitJobDone() {
        if (SimpleDiskLruCache.DEBUG) {
            CLog.d((String)"cube-disk-cache-simple-lru", (String)"waitJobDone");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsRunning) {
                while (!this.mActionQueue.isEmpty()) {
                    try {
                        this.mLock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (SimpleDiskLruCache.DEBUG) {
            CLog.d((String)"cube-disk-cache-simple-lru", (String)"job is done");
        }
    }

    private void addActionLog(byte action, CacheEntry cacheEntry) {
        this.mActionQueue.add(ActionMessage.obtain(action, cacheEntry));
        if (!this.mIsRunning) {
            this.mIsRunning = true;
            this.mExecutorService.submit(this);
        }
    }

    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        for (CacheEntry cacheEntry : new ArrayList<CacheEntry>(this.mLruEntries.values())) {
            if (!cacheEntry.isUnderEdit()) continue;
            cacheEntry.abortEdit();
        }
        this.trimToSize();
        this.waitJobDone();
        this.rebuildJournal();
        this.mJournalWriter.close();
        this.mJournalWriter = null;
    }

    private boolean isClosed() {
        return this.mJournalWriter == null;
    }

    @Override
    public void run() {
        try {
            this.doJob();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mIsRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimToSize() throws IOException {
        LruActionTracer lruActionTracer = this;
        synchronized (lruActionTracer) {
            if (this.mSize > this.mCapacity && SimpleDiskLruCache.DEBUG) {
                CLog.d((String)"cube-disk-cache-simple-lru", (String)"should trim, current is: %s", (Object[])new Object[]{this.mSize});
            }
            while (this.mSize > this.mCapacity) {
                Map.Entry<String, CacheEntry> toEvict = this.mLruEntries.entrySet().iterator().next();
                String key = toEvict.getKey();
                CacheEntry cacheEntry = toEvict.getValue();
                this.mLruEntries.remove(key);
                this.mSize -= cacheEntry.getSize();
                this.addActionLog((byte)5, cacheEntry);
                if (!SimpleDiskLruCache.DEBUG) continue;
                CLog.d((String)"cube-disk-cache-simple-lru", (String)"pending remove: %s, size: %s, after remove total: %s", (Object[])new Object[]{key, cacheEntry.getSize(), this.mSize});
            }
        }
    }

    public synchronized boolean delete(String key) throws IOException {
        if (SimpleDiskLruCache.DEBUG) {
            CLog.d((String)"cube-disk-cache-simple-lru", (String)"delete: %s", (Object[])new Object[]{key});
        }
        this.checkNotClosed();
        LruActionTracer.validateKey(key);
        CacheEntry cacheEntry = this.mLruEntries.get(key);
        if (cacheEntry == null) {
            return false;
        }
        cacheEntry.delete();
        this.mSize -= cacheEntry.getSize();
        cacheEntry.setSize(0L);
        this.mLruEntries.remove(key);
        this.addActionLog((byte)3, cacheEntry);
        return true;
    }

    public long getSize() {
        return this.mSize;
    }

    public long getCapacity() {
        return this.mCapacity;
    }

    public File getDirectory() {
        return this.mDirectory;
    }

    public boolean has(String key) {
        return this.mLruEntries.containsKey(key) && !this.mNewCreateList.contains(key);
    }

    static {
        sPoolSize = 0;
    }

    private static class ActionMessage {
        private byte mAction;
        private CacheEntry mCacheEntry;
        private ActionMessage mNext;

        public ActionMessage(byte action, CacheEntry cacheEntry) {
            this.mAction = action;
            this.mCacheEntry = cacheEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ActionMessage obtain(byte action, CacheEntry cacheEntry) {
            byte[] byArray = sPoolSync;
            synchronized (byArray) {
                if (sPoolHeader != null) {
                    ActionMessage m = sPoolHeader;
                    sPoolHeader = m.mNext;
                    m.mNext = null;
                    sPoolSize--;
                    m.mAction = action;
                    m.mCacheEntry = cacheEntry;
                    return m;
                }
            }
            return new ActionMessage(action, cacheEntry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle() {
            this.mAction = 0;
            this.mCacheEntry = null;
            byte[] byArray = sPoolSync;
            synchronized (byArray) {
                if (sPoolSize < 50) {
                    this.mNext = sPoolHeader;
                    sPoolHeader = this;
                    sPoolSize++;
                }
            }
        }
    }
}

