/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.diskcache.lru;

import in.srain.cube.diskcache.CacheEntry;
import in.srain.cube.diskcache.DiskCache;
import in.srain.cube.diskcache.lru.LruActionTracer;
import in.srain.cube.util.CLog;
import java.io.File;
import java.io.IOException;

public final class SimpleDiskLruCache
implements DiskCache {
    public static final String LOG_TAG = "cube-disk-cache-simple-lru";
    public static boolean DEBUG = false;
    private String mString;
    private LruActionTracer mActionTracer;

    public SimpleDiskLruCache(File directory, int appVersion, long capacity) {
        if (capacity <= 0L) {
            throw new IllegalArgumentException("capacity <= 0");
        }
        this.mActionTracer = new LruActionTracer(this, directory, appVersion, capacity);
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"Construct: path: %s version: %s capacity: %s", (Object[])new Object[]{directory, appVersion, capacity});
        }
    }

    @Override
    public synchronized void clear() throws IOException {
        this.mActionTracer.clear();
    }

    @Override
    public boolean has(String key) {
        return this.mActionTracer.has(key);
    }

    @Override
    public synchronized void open() throws IOException {
        this.mActionTracer.tryToResume();
    }

    @Override
    public synchronized CacheEntry getEntry(String key) throws IOException {
        return this.mActionTracer.getEntry(key);
    }

    @Override
    public synchronized CacheEntry beginEdit(String key) throws IOException {
        return this.mActionTracer.beginEdit(key);
    }

    @Override
    public void abortEdit(CacheEntry cacheEntry) {
        this.mActionTracer.abortEdit(cacheEntry);
    }

    @Override
    public void abortEdit(String key) {
        this.mActionTracer.abortEdit(key);
    }

    @Override
    public void commitEdit(CacheEntry cacheEntry) throws IOException {
        this.mActionTracer.commitEdit(cacheEntry);
    }

    @Override
    public synchronized boolean delete(String key) throws IOException {
        return this.mActionTracer.delete(key);
    }

    @Override
    public long getCapacity() {
        return this.mActionTracer.getCapacity();
    }

    @Override
    public synchronized long getSize() {
        return this.mActionTracer.getSize();
    }

    @Override
    public File getDirectory() {
        return this.mActionTracer.getDirectory();
    }

    @Override
    public synchronized void flush() throws IOException {
        this.mActionTracer.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.mActionTracer.close();
    }

    public String toString() {
        if (this.mString == null) {
            this.mString = String.format("[SimpleDiskLruCache/%s@%s]", this.getDirectory().getName(), Integer.toHexString(this.hashCode()));
        }
        return this.mString;
    }
}

