/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image;

import android.graphics.Bitmap;
import in.srain.cube.cache.DiskCacheProvider;
import in.srain.cube.diskcache.CacheEntry;
import in.srain.cube.diskcache.DiskCache;
import in.srain.cube.diskcache.lru.SimpleDiskLruCache;
import in.srain.cube.image.ImageTask;
import in.srain.cube.image.iface.ImageDownloader;
import in.srain.cube.image.impl.SimpleDownloader;
import in.srain.cube.util.CLog;
import in.srain.cube.util.CubeDebug;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageDiskCacheProvider
extends DiskCacheProvider {
    protected static final boolean DEBUG = CubeDebug.DEBUG_IMAGE;
    protected static final String LOG_TAG = CubeDebug.DEBUG_IMAGE_LOG_TAG_PROVIDER;
    private static final Bitmap.CompressFormat DEFAULT_COMPRESS_FORMAT = Bitmap.CompressFormat.JPEG;
    private static final int DEFAULT_COMPRESS_QUALITY = 70;

    public ImageDiskCacheProvider(DiskCache diskCache) {
        super(diskCache);
    }

    public static ImageDiskCacheProvider createLru(long size, File path) {
        SimpleDiskLruCache simpleDiskLruCache = new SimpleDiskLruCache(path, 1, size);
        ImageDiskCacheProvider provider = new ImageDiskCacheProvider(simpleDiskLruCache);
        return provider;
    }

    public long getSize(String key) {
        if (!this.mDiskCache.has(key)) {
            return -1L;
        }
        try {
            CacheEntry cacheEntry = this.mDiskCache.getEntry(key);
            return cacheEntry.getSize();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public FileInputStream getInputStream(String key) {
        if (!this.mDiskCache.has(key)) {
            return null;
        }
        try {
            CacheEntry cacheEntry = this.mDiskCache.getEntry(key);
            return (FileInputStream)cacheEntry.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public FileInputStream downloadAndGetInputStream(ImageDownloader imageDownloader, ImageTask imageTask, String fileCacheKey, String url) {
        if (imageDownloader == null) {
            imageDownloader = SimpleDownloader.getInstance();
        }
        try {
            CacheEntry cacheEntry = this.mDiskCache.beginEdit(fileCacheKey);
            if (cacheEntry != null) {
                OutputStream outputStream = cacheEntry.newOutputStream();
                boolean ret = imageDownloader.downloadToStream(imageTask, url, outputStream, null);
                if (DEBUG) {
                    CLog.i((String)LOG_TAG, (String)"download: %s %s %s", (Object[])new Object[]{ret, fileCacheKey, url});
                }
                if (ret) {
                    cacheEntry.commit();
                    InputStream inputStream = cacheEntry.getInputStream();
                    if (inputStream instanceof FileInputStream) {
                        return (FileInputStream)inputStream;
                    }
                } else {
                    cacheEntry.abortEdit();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String key, Bitmap bitmap) {
        if (key == null || bitmap == null) {
            return;
        }
        OutputStream out = null;
        try {
            CacheEntry cacheEntry = this.mDiskCache.beginEdit(key);
            if (cacheEntry != null) {
                out = cacheEntry.newOutputStream();
                bitmap.compress(DEFAULT_COMPRESS_FORMAT, 70, out);
                cacheEntry.commit();
                out.close();
            }
        }
        catch (IOException e) {
            CLog.e((String)LOG_TAG, (String)("addBitmapToCache - " + e));
        }
        catch (Exception e) {
            CLog.e((String)LOG_TAG, (String)("addBitmapToCache - " + e));
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

