/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import in.srain.cube.app.CubeFragment;
import in.srain.cube.app.lifecycle.LifeCycleComponent;
import in.srain.cube.app.lifecycle.LifeCycleComponentManager;
import in.srain.cube.concurrent.SimpleTask;
import in.srain.cube.image.CubeImageView;
import in.srain.cube.image.ImageProvider;
import in.srain.cube.image.ImageReuseInfo;
import in.srain.cube.image.ImageTask;
import in.srain.cube.image.iface.ImageDownloader;
import in.srain.cube.image.iface.ImageLoadHandler;
import in.srain.cube.image.iface.ImageLoadProgressHandler;
import in.srain.cube.image.iface.ImageReSizer;
import in.srain.cube.image.iface.ImageTaskExecutor;
import in.srain.cube.util.CLog;
import in.srain.cube.util.CubeDebug;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ImageLoader
implements LifeCycleComponent {
    private static final Object sPoolSync = new Object();
    private static LoadImageTask sTopLoadImageTask;
    private static int sPoolSize;
    private static final int MAX_POOL_SIZE = 0;
    private static final String MSG_ATTACK_TO_RUNNING_TASK = "%s attach to running: %s";
    private static final String MSG_TASK_DO_IN_BACKGROUND = "%s, %s LoadImageTask.doInBackground";
    private static final String MSG_TASK_WAITING = "%s, %s LoadImageTask.waiting";
    private static final String MSG_TASK_FINISH = "%s, %s LoadImageTask.onFinish, mExitTasksEarly? %s";
    private static final String MSG_TASK_AFTER_fetchBitmapData = "%s, %s LoadImageTask.afterFetchBitmapData, canceled? %s";
    private static final String MSG_TASK_CANCEL = "%s, %s LoadImageTask.onCancel";
    private static final String MSG_TASK_RECYCLE = "%s, %s LoadImageTask.removeAndRecycle";
    private static final String MSG_HIT_CACHE = "%s hit cache %s %s";
    protected static final boolean DEBUG;
    protected static final String LOG_TAG;
    protected ImageTaskExecutor mImageTaskExecutor;
    protected ImageReSizer mImageReSizer;
    protected ImageProvider mImageProvider;
    protected ImageLoadHandler mImageLoadHandler;
    protected ImageLoadProgressHandler mLoadImageLoadProgressHandler;
    protected ImageDownloader mImageDownloader;
    protected boolean mPauseWork = false;
    protected boolean mExitTasksEarly = false;
    private final Object mPauseWorkLock = new Object();
    private ConcurrentHashMap<String, LoadImageTask> mLoadWorkList;
    protected Context mContext;
    protected Resources mResources;
    public static final int TASK_ORDER_FIRST_IN_FIRST_OUT = 1;
    public static final int TASK_ORDER_LAST_IN_FIRST_OUT = 2;

    public ImageLoader(Context context, ImageProvider imageProvider, ImageTaskExecutor imageTaskExecutor, ImageReSizer imageReSizer, ImageLoadHandler imageLoadHandler) {
        this.mContext = context;
        this.mResources = context.getResources();
        this.mImageProvider = imageProvider;
        this.mImageTaskExecutor = imageTaskExecutor;
        this.mImageReSizer = imageReSizer;
        this.mImageLoadHandler = imageLoadHandler;
        this.mLoadWorkList = new ConcurrentHashMap();
    }

    public void setImageLoadHandler(ImageLoadHandler imageLoadHandler) {
        this.mImageLoadHandler = imageLoadHandler;
    }

    public ImageLoadHandler getImageLoadHandler() {
        return this.mImageLoadHandler;
    }

    public ImageDownloader getImageDownloader() {
        return this.mImageDownloader;
    }

    public void setImageDownloader(ImageDownloader imageDownloader) {
        this.mImageDownloader = imageDownloader;
    }

    public void setImageReSizer(ImageReSizer reSizer) {
        this.mImageReSizer = reSizer;
    }

    public ImageReSizer getImageReSizer() {
        return this.mImageReSizer;
    }

    public ImageProvider getImageProvider() {
        return this.mImageProvider;
    }

    public void preLoadImages(String[] urls) {
        int len = urls.length;
        for (int i = 0; i < len; ++i) {
            ImageTask imageTask = this.createImageTask(urls[i], 0, 0, null);
            imageTask.setIsPreLoad();
            this.addImageTask(imageTask, null);
        }
    }

    public ImageTask createImageTask(String url, int requestWidth, int requestHeight, ImageReuseInfo imageReuseInfo) {
        ImageTask imageTask = ImageTask.obtain();
        if (imageTask == null) {
            imageTask = new ImageTask();
        }
        imageTask.renew().setOriginUrl(url).setRequestSize(requestWidth, requestHeight).setReuseInfo(imageReuseInfo);
        return imageTask;
    }

    public void detachImageViewFromImageTask(ImageTask imageTask, CubeImageView imageView) {
        imageTask.removeImageView(imageView);
        if (imageTask.isLoading() && !imageTask.isPreLoad() && !imageTask.stillHasRelatedImageView()) {
            LoadImageTask task = this.mLoadWorkList.get(imageTask.getIdentityKey());
            if (task != null) {
                task.cancel();
            }
            if (DEBUG) {
                CLog.d((String)LOG_TAG, (String)"%s previous work is cancelled.", (Object[])new Object[]{imageTask});
            }
        }
        if (!imageTask.stillHasRelatedImageView()) {
            imageTask.tryToRecycle();
        }
    }

    public void addImageTask(ImageTask imageTask, CubeImageView imageView) {
        LoadImageTask runningTask = this.mLoadWorkList.get(imageTask.getIdentityKey());
        if (runningTask != null) {
            if (imageView != null) {
                if (DEBUG) {
                    CLog.d((String)LOG_TAG, (String)MSG_ATTACK_TO_RUNNING_TASK, (Object[])new Object[]{imageTask, runningTask.getImageTask()});
                }
                runningTask.getImageTask().addImageView(imageView);
                runningTask.getImageTask().notifyLoading(this.mImageLoadHandler, imageView);
            }
            return;
        }
        imageTask.addImageView(imageView);
        imageTask.onLoading(this.mImageLoadHandler);
        LoadImageTask loadImageTask = this.createLoadImageTask(imageTask);
        this.mLoadWorkList.put(imageTask.getIdentityKey(), loadImageTask);
        this.mImageTaskExecutor.execute(loadImageTask);
    }

    public boolean queryCache(ImageTask imageTask, CubeImageView imageView) {
        if (null == this.mImageProvider) {
            return false;
        }
        BitmapDrawable drawable = this.mImageProvider.getBitmapFromMemCache(imageTask);
        if (imageTask.getStatistics() != null) {
            imageTask.getStatistics().s0_afterCheckMemoryCache(drawable != null);
        }
        if (drawable == null) {
            return false;
        }
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)MSG_HIT_CACHE, (Object[])new Object[]{imageTask, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight()});
        }
        imageTask.addImageView(imageView);
        imageTask.onLoadTaskFinish(drawable, this.mImageLoadHandler);
        return true;
    }

    public void setTaskOrder(int order) {
        if (null != this.mImageTaskExecutor) {
            this.mImageTaskExecutor.setTaskOrder(order);
        }
    }

    public void flushFileCache() {
        if (this.mImageProvider != null) {
            this.mImageProvider.flushFileCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadImageTask createLoadImageTask(ImageTask imageTask) {
        Object object = sPoolSync;
        synchronized (object) {
            if (sTopLoadImageTask != null) {
                LoadImageTask m = sTopLoadImageTask;
                m.mNextImageTask = null;
                m.renew(this, imageTask);
                sTopLoadImageTask = m.mNextImageTask;
                --sPoolSize;
                return m;
            }
        }
        return new LoadImageTask().renew(this, imageTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPause(boolean pause) {
        Object object = this.mPauseWorkLock;
        synchronized (object) {
            this.mPauseWork = pause;
            if (!pause) {
                this.mPauseWorkLock.notifyAll();
            }
        }
    }

    public void pauseWork() {
        this.mExitTasksEarly = false;
        this.setPause(true);
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"work_status: pauseWork %s", (Object[])new Object[]{this});
        }
    }

    public void resumeWork() {
        this.mExitTasksEarly = false;
        this.setPause(false);
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"work_status: resumeWork %s", (Object[])new Object[]{this});
        }
    }

    public void recoverWork() {
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"work_status: recoverWork %s", (Object[])new Object[]{this});
        }
        this.mExitTasksEarly = false;
        this.setPause(false);
        for (Map.Entry<String, LoadImageTask> item : this.mLoadWorkList.entrySet()) {
            LoadImageTask task = item.getValue();
            task.restart();
            this.mImageTaskExecutor.execute(task);
        }
    }

    public void stopWork() {
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"work_status: stopWork %s", (Object[])new Object[]{this});
        }
        this.mExitTasksEarly = true;
        this.setPause(false);
        this.flushFileCache();
    }

    public void destroy() {
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"work_status: destroy %s", (Object[])new Object[]{this});
        }
        this.mExitTasksEarly = true;
        this.setPause(false);
        Iterator<Map.Entry<String, LoadImageTask>> it = this.mLoadWorkList.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, LoadImageTask> item = it.next();
            LoadImageTask task = item.getValue();
            it.remove();
            if (task == null) continue;
            task.cancel();
        }
        this.mLoadWorkList.clear();
    }

    @Override
    public void onBecomesPartiallyInvisible() {
        this.pauseWork();
    }

    @Override
    public void onBecomesVisible() {
        this.resumeWork();
    }

    @Override
    public void onBecomesTotallyInvisible() {
        this.stopWork();
    }

    @Override
    public void onBecomesVisibleFromTotallyInvisible() {
        this.recoverWork();
    }

    @Override
    public void onDestroy() {
        this.destroy();
    }

    public ImageLoader tryToAttachToContainer(Object object) {
        this.tryToAttachToContainer(object, true);
        return this;
    }

    public ImageLoader tryToAttachToContainer(Object object, boolean throwEx) {
        LifeCycleComponentManager.tryAddComponentToContainer(this, object, throwEx);
        return this;
    }

    public ImageLoader attachToCubeFragment(CubeFragment fragment) {
        if (fragment != null) {
            LifeCycleComponentManager.tryAddComponentToContainer(this, fragment);
        }
        return this;
    }

    static {
        sPoolSize = 0;
        DEBUG = CubeDebug.DEBUG_IMAGE;
        LOG_TAG = CubeDebug.DEBUG_IMAGE_LOG_TAG;
    }

    private static class LoadImageTask
    extends SimpleTask {
        private ImageTask mImageTask;
        private BitmapDrawable mDrawable;
        private LoadImageTask mNextImageTask;
        private ImageLoader mImageLoader;

        private LoadImageTask() {
        }

        public ImageTask getImageTask() {
            return this.mImageTask;
        }

        public LoadImageTask renew(ImageLoader imageLoader, ImageTask imageTask) {
            this.mImageLoader = imageLoader;
            this.mImageTask = imageTask;
            this.restart();
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doInBackground() {
            if (DEBUG) {
                CLog.d((String)LOG_TAG, (String)ImageLoader.MSG_TASK_DO_IN_BACKGROUND, (Object[])new Object[]{this, this.mImageTask});
            }
            if (this.mImageTask.getStatistics() != null) {
                this.mImageTask.getStatistics().s1_beginLoad();
            }
            Bitmap bitmap = null;
            Object object = this.mImageLoader.mPauseWorkLock;
            synchronized (object) {
                while (this.mImageLoader.mPauseWork && !this.isCancelled()) {
                    try {
                        if (DEBUG) {
                            CLog.d((String)LOG_TAG, (String)ImageLoader.MSG_TASK_WAITING, (Object[])new Object[]{this, this.mImageTask});
                        }
                        this.mImageLoader.mPauseWorkLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.isCancelled() && !this.mImageLoader.mExitTasksEarly && (this.mImageTask.isPreLoad() || this.mImageTask.stillHasRelatedImageView())) {
                try {
                    bitmap = this.mImageLoader.mImageProvider.fetchBitmapData(this.mImageLoader, this.mImageTask, this.mImageLoader.mImageReSizer);
                    if (DEBUG) {
                        CLog.d((String)LOG_TAG, (String)ImageLoader.MSG_TASK_AFTER_fetchBitmapData, (Object[])new Object[]{this, this.mImageTask, this.isCancelled()});
                    }
                    this.mDrawable = this.mImageLoader.mImageProvider.createBitmapDrawable(this.mImageLoader.mResources, bitmap);
                    this.mImageLoader.mImageProvider.addBitmapToMemCache(this.mImageTask.getIdentityKey(), this.mDrawable);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                catch (OutOfMemoryError e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void onFinish(boolean canceled) {
            if (DEBUG) {
                CLog.d((String)LOG_TAG, (String)ImageLoader.MSG_TASK_FINISH, (Object[])new Object[]{this, this.mImageTask, this.mImageLoader.mExitTasksEarly});
            }
            if (this.mImageLoader.mExitTasksEarly) {
                return;
            }
            if (!this.isCancelled() && !this.mImageLoader.mExitTasksEarly) {
                this.mImageTask.onLoadTaskFinish(this.mDrawable, this.mImageLoader.mImageLoadHandler);
            }
            this.mImageLoader.mLoadWorkList.remove(this.mImageTask.getIdentityKey());
        }

        @Override
        public void onCancel() {
            if (DEBUG) {
                CLog.d((String)LOG_TAG, (String)ImageLoader.MSG_TASK_CANCEL, (Object[])new Object[]{this, this.mImageTask});
            }
            this.mImageLoader.getImageProvider().cancelTask(this.mImageTask);
            this.mImageTask.onLoadTaskCancel();
            this.mImageLoader.mLoadWorkList.remove(this.mImageTask.getIdentityKey());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeAndRecycle() {
            if (DEBUG) {
                CLog.d((String)LOG_TAG, (String)ImageLoader.MSG_TASK_RECYCLE, (Object[])new Object[]{this, this.mImageTask});
            }
            this.mImageLoader = null;
            this.mImageTask = null;
            this.mDrawable = null;
            Object object = sPoolSync;
            synchronized (object) {
                if (sPoolSize < 0) {
                    this.mNextImageTask = sTopLoadImageTask;
                    sTopLoadImageTask = this;
                    sPoolSize++;
                }
            }
        }

        public String toString() {
            return "[LoadImageTask@" + Integer.toHexString(this.hashCode()) + ']';
        }
    }
}

