/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image;

import android.content.Context;
import android.text.TextUtils;
import in.srain.cube.cache.DiskFileUtils;
import in.srain.cube.image.ImageDiskCacheProvider;
import in.srain.cube.image.ImageLoader;
import in.srain.cube.image.ImageProvider;
import in.srain.cube.image.iface.ImageDownloader;
import in.srain.cube.image.iface.ImageLoadHandler;
import in.srain.cube.image.iface.ImageMemoryCache;
import in.srain.cube.image.iface.ImageReSizer;
import in.srain.cube.image.iface.ImageTaskExecutor;
import in.srain.cube.image.impl.DefaultImageLoadHandler;
import in.srain.cube.image.impl.DefaultImageReSizer;
import in.srain.cube.image.impl.DefaultImageTaskExecutor;
import in.srain.cube.image.impl.DefaultMemoryCache;

public class ImageLoaderFactory {
    public static int DEFAULT_FILE_CACHE_SIZE_IN_KB = 10240;
    private static String DEFAULT_FILE_CACHE_DIR = "cube-image";
    private static String STABLE_FILE_CACHE_DIR = "cube-image-stable";
    private static ImageProvider sDefaultImageProvider;
    private static ImageProvider sStableImageProvider;
    private static ImageReSizer sDefaultImageReSizer;
    private static ImageTaskExecutor sDefaultImageTaskExecutor;
    private static ImageLoadHandler sDefaultImageLoadHandler;
    private static ImageMemoryCache sDefaultImageMemoryCache;
    private static ImageDownloader sImageDownloader;

    public static int getDefaultMemoryCacheSizeInKB() {
        float percent = 0.2f;
        int memoryCacheSizeInKB = Math.round(percent * (float)Runtime.getRuntime().maxMemory() / 1024.0f);
        return memoryCacheSizeInKB;
    }

    public static void customizeCache(Context context, int memoryCacheSizeInKB, int defaultDiskCacheSizeInKB) {
        ImageLoaderFactory.customizeCache(context, memoryCacheSizeInKB, defaultDiskCacheSizeInKB, 0);
    }

    public static void customizeCache(Context context, int memoryCacheSizeInKB, String defaultDiskCachePath, int defaultDiskCacheSizeInKB) {
        ImageLoaderFactory.customizeCache(context, memoryCacheSizeInKB, defaultDiskCachePath, defaultDiskCacheSizeInKB, null, 0);
    }

    public static void customizeCache(Context context, int memoryCacheSizeInKB, int defaultDiskCacheSizeInKB, int stableDiskCacheSizeInKB) {
        ImageLoaderFactory.customizeCache(context, memoryCacheSizeInKB, null, defaultDiskCacheSizeInKB, null, stableDiskCacheSizeInKB);
    }

    public static void customizeCache(Context context, int memoryCacheSizeInKB, String defaultDiskCachePath, int defaultDiskCacheSizeInKB, String stableDiskCachePath, int stableDiskCacheSizeInKB) {
        ImageDiskCacheProvider imageFileProvider;
        if (memoryCacheSizeInKB > 0) {
            int maxCacheSizeInKB = Math.round(0.5f * (float)Runtime.getRuntime().maxMemory() / 1024.0f);
            memoryCacheSizeInKB = Math.min(memoryCacheSizeInKB, maxCacheSizeInKB);
            sDefaultImageMemoryCache = new DefaultMemoryCache(memoryCacheSizeInKB);
        }
        if (defaultDiskCacheSizeInKB > 0 && !TextUtils.isEmpty((CharSequence)defaultDiskCachePath) && (imageFileProvider = ImageLoaderFactory.getImageFileProvider(context, defaultDiskCachePath, defaultDiskCacheSizeInKB, DEFAULT_FILE_CACHE_DIR)) != null) {
            sDefaultImageProvider = new ImageProvider(context, ImageLoaderFactory.getDefaultImageMemoryCache(), imageFileProvider);
        }
        if (stableDiskCacheSizeInKB > 0 && !TextUtils.isEmpty((CharSequence)stableDiskCachePath) && (imageFileProvider = ImageLoaderFactory.getImageFileProvider(context, stableDiskCachePath, stableDiskCacheSizeInKB, STABLE_FILE_CACHE_DIR)) != null) {
            sStableImageProvider = new ImageProvider(context, ImageLoaderFactory.getDefaultImageMemoryCache(), imageFileProvider);
        }
    }

    private static ImageDiskCacheProvider getImageFileProvider(Context context, String path, int sizeInKB, String fallbackCachePath) {
        if (sizeInKB <= 0) {
            sizeInKB = DEFAULT_FILE_CACHE_SIZE_IN_KB;
        }
        DiskFileUtils.CacheDirInfo dirInfo = DiskFileUtils.getDiskCacheDir(context, path, sizeInKB, fallbackCachePath);
        ImageDiskCacheProvider imageFileProvider = ImageDiskCacheProvider.createLru(dirInfo.realSize, dirInfo.path);
        if (imageFileProvider != null) {
            imageFileProvider.openDiskCacheAsync();
        }
        return imageFileProvider;
    }

    public static ImageLoader createStableImageLoader(Context context) {
        return ImageLoaderFactory.createInner(context, ImageLoaderFactory.getStableImageProvider(context), sDefaultImageLoadHandler);
    }

    public static ImageLoader createStableImageLoader(Context context, ImageLoadHandler imageLoadHandler) {
        return ImageLoaderFactory.createInner(context, ImageLoaderFactory.getStableImageProvider(context), imageLoadHandler);
    }

    public static ImageLoader create(Context context) {
        return ImageLoaderFactory.createInner(context, ImageLoaderFactory.getDefaultImageProvider(context), sDefaultImageLoadHandler);
    }

    public static ImageLoader create(Context context, ImageLoadHandler imageLoadHandler) {
        return ImageLoaderFactory.createInner(context, ImageLoaderFactory.getDefaultImageProvider(context), imageLoadHandler);
    }

    private static ImageLoader createInner(Context context, ImageProvider imageProvider, ImageLoadHandler imageLoadHandler) {
        return ImageLoaderFactory.create(context, imageProvider, sDefaultImageTaskExecutor, sDefaultImageReSizer, imageLoadHandler);
    }

    private static ImageLoader create(Context context, ImageProvider imageProvider, ImageTaskExecutor imageTaskExecutor, ImageReSizer imageReSizer, ImageLoadHandler imageLoadHandler) {
        if (imageProvider == null) {
            imageProvider = ImageLoaderFactory.getDefaultImageProvider(context);
        }
        if (imageTaskExecutor == null) {
            imageTaskExecutor = DefaultImageTaskExecutor.getInstance();
        }
        if (imageReSizer == null) {
            imageReSizer = DefaultImageReSizer.getInstance();
        }
        if (imageLoadHandler == null) {
            imageLoadHandler = new DefaultImageLoadHandler(context);
        }
        ImageLoader imageLoader = new ImageLoader(context, imageProvider, imageTaskExecutor, imageReSizer, imageLoadHandler);
        if (sImageDownloader != null) {
            imageLoader.setImageDownloader(sImageDownloader);
        }
        return imageLoader;
    }

    public static void setDefaultImageDownloader(ImageDownloader imageDownloader) {
        sImageDownloader = imageDownloader;
    }

    public static void setDefaultImageReSizer(ImageReSizer imageReSizer) {
        sDefaultImageReSizer = imageReSizer;
    }

    public static void setDefaultImageTaskExecutor(ImageTaskExecutor imageTaskExecutor) {
        sDefaultImageTaskExecutor = imageTaskExecutor;
    }

    public static void setDefaultImageLoadHandler(ImageLoadHandler imageLoadHandler) {
        sDefaultImageLoadHandler = imageLoadHandler;
    }

    public static void setDefaultImageProvider(ImageProvider imageProvider) {
        sDefaultImageProvider = imageProvider;
    }

    public static void setStableImageProvider(ImageProvider imageProvider) {
        sStableImageProvider = imageProvider;
    }

    public static ImageProvider getDefaultImageProvider(Context context) {
        if (null == sDefaultImageProvider) {
            ImageDiskCacheProvider imageFileProvider = ImageLoaderFactory.getImageFileProvider(context, null, 0, DEFAULT_FILE_CACHE_DIR);
            sDefaultImageProvider = new ImageProvider(context, ImageLoaderFactory.getDefaultImageMemoryCache(), imageFileProvider);
        }
        return sDefaultImageProvider;
    }

    public static ImageProvider getStableImageProvider(Context context) {
        if (null == sStableImageProvider) {
            ImageDiskCacheProvider imageFileProvider = ImageLoaderFactory.getImageFileProvider(context, null, 0, STABLE_FILE_CACHE_DIR);
            sStableImageProvider = new ImageProvider(context, ImageLoaderFactory.getDefaultImageMemoryCache(), imageFileProvider);
        }
        return sStableImageProvider;
    }

    private static ImageMemoryCache getDefaultImageMemoryCache() {
        if (sDefaultImageMemoryCache == null) {
            sDefaultImageMemoryCache = new DefaultMemoryCache(ImageLoaderFactory.getDefaultMemoryCacheSizeInKB());
        }
        return sDefaultImageMemoryCache;
    }
}

