/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.util.Log;
import in.srain.cube.image.ImageDiskCacheProvider;
import in.srain.cube.image.ImageLoader;
import in.srain.cube.image.ImageReuseInfo;
import in.srain.cube.image.ImageTask;
import in.srain.cube.image.drawable.RecyclingBitmapDrawable;
import in.srain.cube.image.iface.ImageMemoryCache;
import in.srain.cube.image.iface.ImageReSizer;
import in.srain.cube.util.CLog;
import in.srain.cube.util.CubeDebug;
import in.srain.cube.util.Version;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ImageProvider {
    protected static final boolean DEBUG = CubeDebug.DEBUG_IMAGE;
    protected static final String TAG = CubeDebug.DEBUG_IMAGE_LOG_TAG_PROVIDER;
    private static final String MSG_FETCH_BEGIN = "%s fetchBitmapData";
    private static final String MSG_FETCH_BEGIN_IDENTITY_KEY = "%s identityKey: %s";
    private static final String MSG_FETCH_BEGIN_FILE_CACHE_KEY = "%s fileCacheKey: %s";
    private static final String MSG_FETCH_BEGIN_IDENTITY_URL = "%s identityUrl: %s";
    private static final String MSG_FETCH_BEGIN_ORIGIN_URL = "%s originUrl: %s";
    private static final String MSG_FETCH_TRY_REUSE = "%s Disk Cache not hit. Try to reuse";
    private static final String MSG_FETCH_HIT_DISK_CACHE = "%s Disk Cache hit";
    private static final String MSG_FETCH_REUSE_SUCCESS = "%s reuse size: %s";
    private static final String MSG_FETCH_REUSE_FAIL = "%s reuse fail: %s, %s";
    private static final String MSG_FETCH_DOWNLOAD = "%s downloading: %s";
    private static final String MSG_DECODE = "%s decode: %sx%s inSampleSize:%s";
    private ImageMemoryCache mMemoryCache;
    private ImageDiskCacheProvider mDiskCacheProvider;

    public ImageProvider(Context context, ImageMemoryCache memoryCache, ImageDiskCacheProvider fileProvider) {
        this.mMemoryCache = memoryCache;
        this.mDiskCacheProvider = fileProvider;
    }

    private static int getBytesPerPixel(Bitmap.Config config) {
        if (config == Bitmap.Config.ARGB_8888) {
            return 4;
        }
        if (config == Bitmap.Config.RGB_565) {
            return 2;
        }
        if (config == Bitmap.Config.ARGB_4444) {
            return 2;
        }
        if (config == Bitmap.Config.ALPHA_8) {
            return 1;
        }
        return 1;
    }

    @TargetApi(value=19)
    public static long getBitmapSize(BitmapDrawable value) {
        if (null == value) {
            return 0L;
        }
        Bitmap bitmap = value.getBitmap();
        if (Version.hasKitKat()) {
            return bitmap.getAllocationByteCount();
        }
        if (Version.hasHoneycombMR1()) {
            return bitmap.getByteCount();
        }
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    public BitmapDrawable createBitmapDrawable(Resources resources, Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        Object drawable = null;
        if (bitmap != null) {
            drawable = Version.hasHoneycomb() ? new BitmapDrawable(resources, bitmap) : new RecyclingBitmapDrawable(resources, bitmap);
        }
        return drawable;
    }

    public BitmapDrawable getBitmapFromMemCache(ImageTask imageTask) {
        BitmapDrawable memValue = null;
        if (this.mMemoryCache != null) {
            memValue = this.mMemoryCache.get(imageTask.getIdentityKey());
        }
        return memValue;
    }

    public void addBitmapToMemCache(String key, BitmapDrawable drawable) {
        if (key == null || drawable == null || !Version.hasHoneycomb()) {
            return;
        }
        if (this.mMemoryCache != null) {
            this.mMemoryCache.set(key, drawable);
        }
    }

    public void cancelTask(ImageTask task) {
        this.mDiskCacheProvider.getDiskCache().abortEdit(task.getFileCacheKey());
    }

    public Bitmap fetchBitmapData(ImageLoader imageLoader, ImageTask imageTask, ImageReSizer imageReSizer) {
        Bitmap bitmap = null;
        if (this.mDiskCacheProvider == null) {
            return null;
        }
        FileInputStream inputStream = null;
        String fileCacheKey = imageTask.getFileCacheKey();
        ImageReuseInfo reuseInfo = imageTask.getImageReuseInfo();
        if (DEBUG) {
            Log.d((String)TAG, (String)String.format(MSG_FETCH_BEGIN, imageTask));
            Log.d((String)TAG, (String)String.format(MSG_FETCH_BEGIN_IDENTITY_KEY, imageTask, imageTask.getIdentityKey()));
            Log.d((String)TAG, (String)String.format(MSG_FETCH_BEGIN_FILE_CACHE_KEY, imageTask, fileCacheKey));
            Log.d((String)TAG, (String)String.format(MSG_FETCH_BEGIN_ORIGIN_URL, imageTask, imageTask.getOriginUrl()));
            Log.d((String)TAG, (String)String.format(MSG_FETCH_BEGIN_IDENTITY_URL, imageTask, imageTask.getIdentityUrl()));
        }
        if ((inputStream = this.mDiskCacheProvider.getInputStream(fileCacheKey)) == null) {
            if (reuseInfo != null && reuseInfo.getReuseSizeList() != null && reuseInfo.getReuseSizeList().length > 0) {
                if (DEBUG) {
                    Log.d((String)TAG, (String)String.format(MSG_FETCH_TRY_REUSE, imageTask));
                }
                String[] sizeKeyList = reuseInfo.getReuseSizeList();
                for (int i = 0; i < sizeKeyList.length; ++i) {
                    String size = sizeKeyList[i];
                    String key = imageTask.generateFileCacheKeyForReuse(size);
                    inputStream = this.mDiskCacheProvider.getInputStream(key);
                    if (inputStream != null) {
                        if (DEBUG) {
                            Log.d((String)TAG, (String)String.format(MSG_FETCH_REUSE_SUCCESS, imageTask, size));
                        }
                        break;
                    }
                    if (!DEBUG) continue;
                    Log.d((String)TAG, (String)String.format(MSG_FETCH_REUSE_FAIL, imageTask, size, key));
                }
            }
        } else if (DEBUG) {
            Log.d((String)TAG, (String)String.format(MSG_FETCH_HIT_DISK_CACHE, imageTask));
        }
        if (imageTask.getStatistics() != null) {
            imageTask.getStatistics().s2_afterCheckFileCache(inputStream != null);
        }
        if (inputStream == null) {
            String url = imageReSizer.getRemoteUrl(imageTask);
            if (DEBUG) {
                Log.d((String)TAG, (String)String.format(MSG_FETCH_DOWNLOAD, imageTask, url));
            }
            inputStream = this.mDiskCacheProvider.downloadAndGetInputStream(imageLoader.getImageDownloader(), imageTask, fileCacheKey, url);
            if (imageTask.getStatistics() != null) {
                imageTask.getStatistics().s3_afterDownload();
            }
            if (inputStream == null) {
                imageTask.setError(1);
                CLog.e((String)TAG, (String)"%s download fail: %s %s", (Object[])new Object[]{imageTask, fileCacheKey, url});
            }
        }
        if (inputStream != null) {
            try {
                bitmap = this.decodeSampledBitmapFromDescriptor(inputStream.getFD(), imageTask, imageReSizer);
                if (bitmap == null) {
                    imageTask.setError(2);
                    CLog.e((String)TAG, (String)"%s decode bitmap fail, bad format. %s, %s", (Object[])new Object[]{imageTask, fileCacheKey, imageReSizer.getRemoteUrl(imageTask)});
                }
            }
            catch (IOException e) {
                CLog.e((String)TAG, (String)"%s decode bitmap fail, may be out of memory. %s, %s", (Object[])new Object[]{imageTask, fileCacheKey, imageReSizer.getRemoteUrl(imageTask)});
                e.printStackTrace();
            }
        } else {
            CLog.e((String)TAG, (String)"%s fetch bitmap fail. %s, %s", (Object[])new Object[]{imageTask, fileCacheKey, imageReSizer.getRemoteUrl(imageTask)});
        }
        if (imageTask != null && imageTask.getStatistics() != null) {
            imageTask.getStatistics().s4_afterDecode(this.mDiskCacheProvider.getSize(fileCacheKey));
        }
        return bitmap;
    }

    private Bitmap decodeSampledBitmapFromDescriptor(FileDescriptor fileDescriptor, ImageTask imageTask, ImageReSizer imageReSizer) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
        imageTask.setBitmapOriginSize(options.outWidth, options.outHeight);
        options.inSampleSize = imageReSizer.getInSampleSize(imageTask);
        options.inJustDecodeBounds = false;
        if (DEBUG) {
            Log.d((String)TAG, (String)String.format(MSG_DECODE, imageTask, imageTask.getBitmapOriginSize().x, imageTask.getBitmapOriginSize().y, options.inSampleSize));
        }
        Bitmap bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
        return bitmap;
    }

    private Bitmap decodeSampledBitmapFromInputStream(InputStream stream, ImageTask imageTask, ImageReSizer imageReSizer) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
        imageTask.setBitmapOriginSize(options.outWidth, options.outHeight);
        options.inSampleSize = imageReSizer.getInSampleSize(imageTask);
        options.inJustDecodeBounds = false;
        if (DEBUG) {
            Log.d((String)TAG, (String)String.format(MSG_DECODE, imageTask, imageTask.getBitmapOriginSize().x, imageTask.getBitmapOriginSize().y, options.inSampleSize));
        }
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
        return bitmap;
    }

    public void flushFileCache() {
        if (null != this.mDiskCacheProvider) {
            this.mDiskCacheProvider.flushDiskCacheAsync();
        }
    }

    public void clearMemoryCache() {
        if (this.mMemoryCache != null) {
            this.mMemoryCache.clear();
        }
    }

    public void clearDiskCache() {
        if (null != this.mDiskCacheProvider) {
            try {
                this.mDiskCacheProvider.getDiskCache().clear();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public long getMemoryCacheMaxSpace() {
        return this.mMemoryCache.getMaxSize();
    }

    public long getMemoryCacheUsedSpace() {
        return this.mMemoryCache.getUsedSpace();
    }

    public String getFileCachePath() {
        if (null != this.mDiskCacheProvider) {
            return this.mDiskCacheProvider.getDiskCache().getDirectory().getAbsolutePath();
        }
        return null;
    }

    public long getFileCacheUsedSpace() {
        return null != this.mDiskCacheProvider ? this.mDiskCacheProvider.getDiskCache().getSize() : 0L;
    }

    public long getFileCacheMaxSpace() {
        if (null != this.mDiskCacheProvider) {
            return this.mDiskCacheProvider.getDiskCache().getCapacity();
        }
        return 0L;
    }
}

