/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image;

import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import in.srain.cube.image.CubeImageView;
import in.srain.cube.image.ImagePerformanceStatistics;
import in.srain.cube.image.ImageProvider;
import in.srain.cube.image.ImageReuseInfo;
import in.srain.cube.image.ImageTaskStatistics;
import in.srain.cube.image.iface.ImageLoadHandler;
import in.srain.cube.util.CLog;
import in.srain.cube.util.CubeDebug;
import in.srain.cube.util.Encrypt;
import java.lang.ref.WeakReference;

public class ImageTask {
    protected static final String LOG_TAG = CubeDebug.DEBUG_IMAGE_LOG_TAG_TASK;
    private static final Object sPoolSync = new Object();
    private static ImageTask sTop;
    private static int sPoolSize;
    private static final int MAX_POOL_SIZE = 20;
    private static boolean USE_POOL;
    private static int sId;
    private static final String SIZE_SP = "_";
    private static final int ERROR_CODE_MASK = 7;
    public static final int ERROR_NETWORK = 1;
    public static final int ERROR_BAD_FORMAT = 2;
    private static final int STATUS_LOADING = 8;
    private static final int STATUS_PRE_LOAD = 16;
    private int mFlag = 0;
    protected int mId = 0;
    protected String mOriginUrl;
    private String mIdentityUrl;
    private String mIdentityKey;
    private String mStr;
    protected Point mRequestSize = new Point();
    protected Point mBitmapOriginSize = new Point();
    protected ImageReuseInfo mReuseInfo;
    protected ImageViewHolder mFirstImageViewHolder;
    protected ImageTaskStatistics mImageTaskStatistics;
    ImageTask next;
    private boolean mHasRecycled = false;

    protected void clearForRecycle() {
        this.mHasRecycled = true;
        this.mFlag = 0;
        this.mOriginUrl = null;
        this.mIdentityUrl = null;
        this.mIdentityKey = null;
        this.mStr = null;
        this.mRequestSize.set(0, 0);
        this.mBitmapOriginSize.set(0, 0);
        this.mReuseInfo = null;
        this.mFirstImageViewHolder = null;
        this.mImageTaskStatistics = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageTask obtain() {
        if (!USE_POOL) {
            return null;
        }
        Object object = sPoolSync;
        synchronized (object) {
            if (sTop != null) {
                ImageTask m = sTop;
                sTop = m.next;
                m.next = null;
                --sPoolSize;
                m.mHasRecycled = false;
                if (CubeDebug.DEBUG_IMAGE) {
                    CLog.d((String)LOG_TAG, (String)"%s, obtain reused, pool remain: %d", (Object[])new Object[]{m, sPoolSize});
                }
                return m;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryToRecycle() {
        if (!USE_POOL) {
            return;
        }
        this.clearForRecycle();
        Object object = sPoolSync;
        synchronized (object) {
            if (sPoolSize < 20) {
                this.next = sTop;
                sTop = this;
                ++sPoolSize;
                if (CubeDebug.DEBUG_IMAGE) {
                    CLog.d((String)LOG_TAG, (String)"%s is put to recycle poll, pool size: %d", (Object[])new Object[]{this, sPoolSize});
                } else if (CubeDebug.DEBUG_IMAGE) {
                    CLog.d((String)LOG_TAG, (String)"%s is not recycled, the poll is full: %d", (Object[])new Object[]{this, sPoolSize});
                }
            }
        }
    }

    public ImageTask renew() {
        if (CubeDebug.DEBUG_IMAGE) {
            int lastId = this.mId;
            this.mId = ++sId;
            CLog.d((String)LOG_TAG, (String)"%s, renew: %s => %s", (Object[])new Object[]{this, lastId, this.mId});
        } else {
            this.mId = ++sId;
        }
        this.mStr = null;
        if (ImagePerformanceStatistics.sample(this.mId)) {
            this.mImageTaskStatistics = new ImageTaskStatistics();
        }
        return this;
    }

    public ImageTask setOriginUrl(String originUrl) {
        this.mOriginUrl = originUrl;
        return this;
    }

    public ImageTask setRequestSize(int requestWidth, int requestHeight) {
        this.mRequestSize.set(requestWidth, requestHeight);
        return this;
    }

    public ImageTask setReuseInfo(ImageReuseInfo imageReuseInfo) {
        this.mReuseInfo = imageReuseInfo;
        return this;
    }

    public String getIdentityUrl() {
        if (null == this.mIdentityUrl) {
            this.mIdentityUrl = this.generateIdentityUrl(this.mOriginUrl);
        }
        return this.mIdentityUrl;
    }

    protected String generateIdentityUrl(String originUrl) {
        return originUrl;
    }

    protected String generateIdentityKey() {
        if (this.mReuseInfo == null) {
            return ImageTask.joinSizeInfoToKey(this.getIdentityUrl(), this.mRequestSize.x, this.mRequestSize.y);
        }
        return ImageTask.joinSizeTagToKey(this.getIdentityUrl(), this.mReuseInfo.getIdentitySize());
    }

    public boolean isPreLoad() {
        return (this.mFlag & 0x10) == 16;
    }

    public void setIsPreLoad() {
        this.mFlag |= 0x10;
    }

    public boolean isLoading() {
        return (this.mFlag & 8) != 0;
    }

    public boolean isLoadingThisUrl(String url) {
        return this.getIdentityUrl().equals(this.generateIdentityUrl(url));
    }

    public void addImageView(CubeImageView imageView) {
        if (null == imageView) {
            return;
        }
        if (null == this.mFirstImageViewHolder) {
            this.mFirstImageViewHolder = new ImageViewHolder(imageView);
            return;
        }
        ImageViewHolder holder = this.mFirstImageViewHolder;
        while (true) {
            if (holder.contains(imageView)) {
                return;
            }
            if (holder.mNext == null) break;
            holder = holder.mNext;
        }
        ImageViewHolder newHolder = new ImageViewHolder(imageView);
        newHolder.mPrev = holder;
        holder.mNext = newHolder;
    }

    public void removeImageView(CubeImageView imageView) {
        if (null == imageView || null == this.mFirstImageViewHolder) {
            return;
        }
        ImageViewHolder holder = this.mFirstImageViewHolder;
        do {
            if (!holder.contains(imageView)) continue;
            if (holder == this.mFirstImageViewHolder) {
                this.mFirstImageViewHolder = holder.mNext;
            }
            if (null != holder.mNext) {
                holder.mNext.mPrev = holder.mPrev;
            }
            if (null == holder.mPrev) continue;
            holder.mPrev.mNext = holder.mNext;
        } while ((holder = holder.mNext) != null);
    }

    public boolean stillHasRelatedImageView() {
        return null != this.mFirstImageViewHolder && this.mFirstImageViewHolder.getImageView() != null;
    }

    public void onLoading(ImageLoadHandler handler) {
        this.mFlag |= 8;
        if (null == handler) {
            return;
        }
        if (this.mFirstImageViewHolder == null) {
            handler.onLoading(this, null);
        } else {
            ImageViewHolder holder = this.mFirstImageViewHolder;
            do {
                CubeImageView imageView;
                if (null == (imageView = holder.getImageView())) continue;
                handler.onLoading(this, imageView);
            } while ((holder = holder.mNext) != null);
        }
    }

    public void notifyLoading(ImageLoadHandler handler, CubeImageView imageView) {
        if (handler == null || imageView == null) {
            return;
        }
        handler.onLoading(this, imageView);
    }

    public void onLoadTaskFinish(BitmapDrawable drawable, ImageLoadHandler handler) {
        this.mFlag &= 0xFFFFFFF7;
        if (null == handler) {
            return;
        }
        int errorCode = this.mFlag & 7;
        if (errorCode > 0) {
            this.onLoadError(errorCode, handler);
            return;
        }
        if (null != this.mImageTaskStatistics) {
            this.mImageTaskStatistics.s5_beforeShow();
        }
        if (this.mFirstImageViewHolder == null) {
            handler.onLoadFinish(this, null, drawable);
        } else {
            ImageViewHolder holder = this.mFirstImageViewHolder;
            do {
                CubeImageView imageView;
                if (null == (imageView = holder.getImageView())) continue;
                imageView.onLoadFinish();
                handler.onLoadFinish(this, imageView, drawable);
            } while ((holder = holder.mNext) != null);
        }
        if (null != this.mImageTaskStatistics) {
            this.mImageTaskStatistics.s6_afterShow(ImageProvider.getBitmapSize(drawable));
            ImagePerformanceStatistics.onImageLoaded(this, this.mImageTaskStatistics);
        }
    }

    public void onLoadTaskCancel() {
    }

    public void setError(int errorCode) {
        if (errorCode > 7) {
            throw new IllegalArgumentException("error code undefined.");
        }
        this.mFlag &= 0xFFFFFFF8;
        this.mFlag |= errorCode;
    }

    private void onLoadError(int reason, ImageLoadHandler handler) {
        if (this.mFirstImageViewHolder == null) {
            handler.onLoadError(this, null, reason);
        } else {
            ImageViewHolder holder = this.mFirstImageViewHolder;
            do {
                CubeImageView imageView;
                if (null == (imageView = holder.getImageView())) continue;
                imageView.onLoadFinish();
                handler.onLoadError(this, imageView, reason);
            } while ((holder = holder.mNext) != null);
        }
    }

    public String getRemoteUrl() {
        return this.mOriginUrl;
    }

    public String getOriginUrl() {
        return this.mOriginUrl;
    }

    public void setBitmapOriginSize(int width, int height) {
        this.mBitmapOriginSize.set(width, height);
    }

    public Point getBitmapOriginSize() {
        return this.mBitmapOriginSize;
    }

    public Point getRequestSize() {
        return this.mRequestSize;
    }

    public String getIdentityKey() {
        if (this.mIdentityKey == null) {
            this.mIdentityKey = this.generateIdentityKey();
        }
        return this.mIdentityKey;
    }

    public static String joinSizeInfoToKey(String key, int w, int h) {
        if (w > 0 && h != Integer.MAX_VALUE && h > 0 && h != Integer.MAX_VALUE) {
            return key + SIZE_SP + w + SIZE_SP + h;
        }
        return key;
    }

    public static String joinSizeTagToKey(String key, String tag) {
        return key + SIZE_SP + tag;
    }

    public String getFileCacheKey() {
        return Encrypt.md5(this.getIdentityKey());
    }

    public String generateFileCacheKeyForReuse(String sizeKey) {
        return Encrypt.md5(ImageTask.joinSizeTagToKey(this.getIdentityUrl(), sizeKey));
    }

    public ImageReuseInfo getImageReuseInfo() {
        return this.mReuseInfo;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ImageTask) {
            return ((ImageTask)object).getIdentityKey().equals(this.getIdentityKey());
        }
        return false;
    }

    public String toString() {
        if (this.mStr == null) {
            this.mStr = String.format("[ImageTask@%s %s %sx%s %s]", Integer.toHexString(this.hashCode()), this.mId, this.mRequestSize.x, this.mRequestSize.y, this.mHasRecycled);
        }
        return this.mStr;
    }

    public ImageTaskStatistics getStatistics() {
        return this.mImageTaskStatistics;
    }

    static {
        sPoolSize = 0;
        USE_POOL = false;
        sId = 0;
    }

    private static class ImageViewHolder {
        private WeakReference<CubeImageView> mImageViewRef;
        private ImageViewHolder mNext;
        private ImageViewHolder mPrev;

        public ImageViewHolder(CubeImageView imageView) {
            this.mImageViewRef = new WeakReference<CubeImageView>(imageView);
        }

        boolean contains(CubeImageView imageView) {
            return this.mImageViewRef != null && imageView == this.mImageViewRef.get();
        }

        CubeImageView getImageView() {
            if (null == this.mImageViewRef) {
                return null;
            }
            return (CubeImageView)((Object)this.mImageViewRef.get());
        }
    }
}

