/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image;

public class ImageTaskStatistics {
    private long m0Start = System.currentTimeMillis();
    private long m1BeginLoad;
    private long m2AfterCheckFileCache;
    private long m3AfterDownload;
    private long m4AfterDecode;
    private long m5ShowStart;
    private long m6ShowComplete;
    private long mImageFileSize;
    private long mBitmapDrawableSize;
    private boolean mHitMemoryCache;
    private boolean mHitFileCache;

    public void s0_afterCheckMemoryCache(boolean hasCache) {
        this.mHitMemoryCache = hasCache;
        if (hasCache) {
            this.m3AfterDownload = this.m4AfterDecode = System.currentTimeMillis();
            this.m2AfterCheckFileCache = this.m4AfterDecode;
            this.m1BeginLoad = this.m4AfterDecode;
        }
    }

    public void s1_beginLoad() {
        this.m1BeginLoad = System.currentTimeMillis();
    }

    public void s2_afterCheckFileCache(boolean hasCache) {
        this.mHitFileCache = hasCache;
        this.m2AfterCheckFileCache = System.currentTimeMillis();
        if (hasCache) {
            this.m3AfterDownload = this.m2AfterCheckFileCache;
        }
    }

    public void s3_afterDownload() {
        this.m3AfterDownload = System.currentTimeMillis();
    }

    public void s4_afterDecode(long imageFileSize) {
        this.mImageFileSize = imageFileSize;
        this.m4AfterDecode = System.currentTimeMillis();
    }

    public void s5_beforeShow() {
        this.m5ShowStart = System.currentTimeMillis();
    }

    public void s6_afterShow(long s) {
        this.mBitmapDrawableSize = s;
        this.m6ShowComplete = System.currentTimeMillis();
    }

    public long getBitmapDrawableSize() {
        return this.mBitmapDrawableSize;
    }

    public int getDecodeTime() {
        return (int)(this.m4AfterDecode - this.m3AfterDownload);
    }

    public int getDownloadTime() {
        return (int)(this.m3AfterDownload - this.m2AfterCheckFileCache);
    }

    public int getCheckFileCacheTime() {
        return (int)(this.m2AfterCheckFileCache - this.m1BeginLoad);
    }

    public long getImageFileSize() {
        return this.mImageFileSize;
    }

    public int getDownLoadSpeed() {
        if ((long)this.getDownloadTime() * this.mImageFileSize == 0L) {
            return -1;
        }
        return (int)((this.mImageFileSize >> 10) * 1000L / (long)this.getDownloadTime());
    }

    public String getStatisticsInfo() {
        return String.format("mc=%d, fc=%d, wait_to_load=%d, check_file_cache=%d, download=%d/%dKB/s, decode=%d, wait_ui=%s, all=%d, size=%d/%d", this.mHitMemoryCache ? 1 : 0, this.mHitFileCache ? 1 : 0, this.getWaitForLoadTime(), this.getCheckFileCacheTime(), this.getDownloadTime(), this.getDownLoadSpeed(), this.getDecodeTime(), this.getWaitToPostMessage(), this.getTotalLoadTime(), this.mBitmapDrawableSize, this.mImageFileSize);
    }

    public int getTotalLoadTime() {
        return (int)(this.m6ShowComplete - this.m0Start);
    }

    public int getWaitForLoadTime() {
        return (int)(this.m1BeginLoad - this.m0Start);
    }

    public int getWaitToPostMessage() {
        return (int)(this.m5ShowStart - this.m4AfterDecode);
    }

    public boolean hitFileCache() {
        return this.mHitFileCache;
    }

    public boolean hitMemoryCache() {
        return this.mHitMemoryCache;
    }
}

