/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image.drawable;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.text.TextUtils;
import in.srain.cube.util.CLog;

public class CircleProgress
extends Drawable {
    private String prefixText = "";
    private String suffixText = "%";
    private Paint mTextPaint;
    private RectF rectF = new RectF();
    private float mTextSize;
    private int textColor = -1;
    private int progress = 0;
    private int mMax = 100;
    private int mFinishedColor = Color.rgb((int)66, (int)145, (int)241);
    private int mUnfinishedColor = Color.rgb((int)204, (int)204, (int)204);
    private Paint mPaint = new Paint();
    private int mSize;

    public CircleProgress(int textSize) {
        this.mTextSize = textSize;
        this.mTextPaint = new TextPaint();
        this.mTextPaint.setAntiAlias(true);
        this.mPaint.setAntiAlias(true);
        this.setPainters();
    }

    public void setSize(int size) {
        this.mSize = size;
    }

    public void setPainters() {
        this.mTextPaint.setColor(this.textColor);
        this.mTextPaint.setTextSize(this.mTextSize);
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        if (this.progress > this.getMax()) {
            this.progress %= this.getMax();
        }
        this.setPainters();
    }

    public int getMax() {
        return this.mMax;
    }

    public void setMax(int max) {
        if (max > 0 && this.mMax != max) {
            this.mMax = max;
            this.setPainters();
        }
    }

    public float getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(float textSize) {
        if (textSize != this.mTextSize) {
            this.mTextSize = textSize;
            this.setPainters();
        }
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        if (this.textColor != textColor) {
            this.textColor = textColor;
            this.setPainters();
        }
    }

    public int getFinishedColor() {
        return this.mFinishedColor;
    }

    public void setFinishedColor(int finishedColor) {
        if (this.mFinishedColor != finishedColor) {
            this.mFinishedColor = finishedColor;
            this.setPainters();
        }
    }

    public int getUnfinishedColor() {
        return this.mUnfinishedColor;
    }

    public void setUnfinishedColor(int unfinishedColor) {
        this.mUnfinishedColor = unfinishedColor;
        this.setPainters();
    }

    public String getPrefixText() {
        return this.prefixText;
    }

    public void setPrefixText(String prefixText) {
        this.prefixText = prefixText;
        this.setPainters();
    }

    public String getSuffixText() {
        return this.suffixText;
    }

    public void setSuffixText(String suffixText) {
        this.suffixText = suffixText;
        this.setPainters();
    }

    public String getDrawText() {
        return this.getPrefixText() + this.getProgress() + this.getSuffixText();
    }

    public float getProgressPercentage() {
        return (float)this.getProgress() / (float)this.getMax();
    }

    public void draw(Canvas canvas) {
        CLog.d((String)"test", (String)"draw");
        float yHeight = (float)this.getProgress() / (float)this.getMax() * (float)this.mSize;
        float radius = (float)this.mSize / 2.0f;
        float angle = (float)(Math.acos((radius - yHeight) / radius) * 180.0 / Math.PI);
        float startAngle = 90.0f + angle;
        float sweepAngle = 360.0f - angle * 2.0f;
        this.mPaint.setColor(this.getUnfinishedColor());
        canvas.drawArc(this.rectF, startAngle, sweepAngle, false, this.mPaint);
        canvas.save();
        canvas.rotate(180.0f, (float)(this.mSize / 2), (float)(this.mSize / 2));
        this.mPaint.setColor(this.getFinishedColor());
        canvas.drawArc(this.rectF, 270.0f - angle, angle * 2.0f, false, this.mPaint);
        canvas.restore();
        String text = this.getDrawText();
        if (!TextUtils.isEmpty((CharSequence)text)) {
            float textHeight = this.mTextPaint.descent() + this.mTextPaint.ascent();
            canvas.drawText(text, ((float)this.mSize - this.mTextPaint.measureText(text)) / 2.0f, ((float)this.mSize - textHeight) / 2.0f, this.mTextPaint);
        }
    }

    public void setAlpha(int i) {
        this.mTextPaint.setAlpha(i);
        this.mPaint.setAlpha(i);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mTextPaint.setColorFilter(colorFilter);
        this.mPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }
}

