/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image.drawable;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;

public class RoundedDrawable
extends Drawable {
    protected final float mCornerRadius;
    protected final RectF mRect = new RectF();
    protected final BitmapShader mBitmapShader;
    protected final Paint mPaint;
    private int mBitmapWidth;
    private int mBitmapHeight;

    public RoundedDrawable(Bitmap bitmap, float cornerRadius) {
        this.mCornerRadius = cornerRadius;
        this.mBitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.mBitmapWidth = bitmap.getWidth();
        this.mBitmapHeight = bitmap.getHeight();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setShader((Shader)this.mBitmapShader);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mRect.set(0.0f, 0.0f, (float)bounds.width(), (float)bounds.height());
        Matrix shaderMatrix = new Matrix();
        shaderMatrix.setRectToRect(new RectF(0.0f, 0.0f, (float)this.mBitmapWidth, (float)this.mBitmapHeight), this.mRect, Matrix.ScaleToFit.FILL);
        this.mBitmapShader.setLocalMatrix(shaderMatrix);
    }

    public void draw(Canvas canvas) {
        canvas.drawRoundRect(this.mRect, this.mCornerRadius, this.mCornerRadius, this.mPaint);
    }

    public static Bitmap transform(Bitmap source, float margin, float radius) {
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        Bitmap output = Bitmap.createBitmap((int)source.getWidth(), (int)source.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        canvas.drawRoundRect(new RectF(margin, margin, (float)source.getWidth() - margin, (float)source.getHeight() - margin), radius, radius, paint);
        if (source != output) {
            source.recycle();
        }
        return output;
    }

    public int getOpacity() {
        return -3;
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }
}

