/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image.drawable;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;

public class TextDrawable
extends Drawable {
    private final String mText;
    private final Paint mPaint;
    private int mBackgroundColor = -921103;
    private int mTextColor = -16777216;
    private float mX = 0.0f;
    private float mY = 0.0f;
    private float mTextSize = 40.0f;

    public TextDrawable(String text) {
        this.mText = text;
        this.mPaint = new Paint();
        this.mPaint.setTextSize(this.mTextSize);
        this.mPaint.setAntiAlias(true);
        this.setUp();
    }

    public void setTextSize(float size) {
        if (this.mTextSize != size) {
            this.mTextSize = size;
            this.setUp();
        }
    }

    private void setUp() {
        float width = this.mPaint.measureText(this.mText);
        float height = this.mPaint.descent() + this.mPaint.ascent();
        this.mX = ((float)this.getBounds().width() - width) / 2.0f;
        this.mY = ((float)this.getBounds().height() - height) / 2.0f;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.setUp();
    }

    public void draw(Canvas canvas) {
        this.mPaint.setColor(this.mBackgroundColor);
        canvas.drawRect(this.getBounds(), this.mPaint);
        this.mPaint.setColor(this.mTextColor);
        canvas.drawText(this.mText, this.mX, this.mY, this.mPaint);
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }
}

