/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image.impl;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.view.ViewGroup;
import in.srain.cube.image.CubeImageView;
import in.srain.cube.image.ImageTask;
import in.srain.cube.image.drawable.RoundedDrawable;
import in.srain.cube.image.iface.ImageLoadHandler;
import in.srain.cube.util.CLog;
import in.srain.cube.util.CubeDebug;
import in.srain.cube.util.Version;

public class DefaultImageLoadHandler
implements ImageLoadHandler {
    private static final boolean DEBUG = CubeDebug.DEBUG_IMAGE;
    private static final String LOG_TAG = CubeDebug.DEBUG_IMAGE_LOG_TAG;
    private static final String MSG_LOADING = "%s => %s handler on loading";
    private static final String MSG_LOAD_ERROR = "%s => %s handler on load error";
    private static final String MSG_LOAD_FINISH = "%s => %s handler on load finish: %s %s %s %s";
    private Context mContext;
    private static final int DISPLAY_FADE_IN = 1;
    private static final int DISPLAY_ROUNDED = 2;
    private int mDisplayTag = 1;
    private Drawable mLoadingDrawable;
    private Drawable mErrorDrawable;
    private int mLoadingColor = -1;
    private float mCornerRadius = 10.0f;
    private boolean mResizeImageViewAfterLoad = false;

    public DefaultImageLoadHandler(Context context) {
        this.mContext = context;
        this.mLoadingDrawable = new ColorDrawable(-921103);
        this.mErrorDrawable = new ColorDrawable(-65536);
    }

    public void setImageFadeIn(boolean fadeIn) {
        this.mDisplayTag = fadeIn ? (this.mDisplayTag |= 1) : (this.mDisplayTag &= 0xFFFFFFFE);
    }

    public void setImageRounded(boolean rounded, float cornerRadius) {
        if (rounded) {
            this.mDisplayTag |= 2;
            this.mCornerRadius = cornerRadius;
        } else {
            this.mDisplayTag &= 0xFFFFFFFD;
        }
    }

    public void setResizeImageViewAfterLoad(boolean resize) {
        this.mResizeImageViewAfterLoad = resize;
    }

    public void setLoadingBitmap(Bitmap loadingBitmap) {
        if (Version.hasHoneycomb()) {
            this.mLoadingDrawable = new BitmapDrawable(this.mContext.getResources(), loadingBitmap);
        }
    }

    public void setLoadingResources(int loadingBitmap) {
        this.setLoadingBitmap(BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)loadingBitmap));
    }

    public void setErrorBitmap(Bitmap bitmap) {
        if (Version.hasHoneycomb()) {
            this.mErrorDrawable = new BitmapDrawable(this.mContext.getResources(), bitmap);
        }
    }

    public void setErrorResources(int resId) {
        this.setErrorBitmap(BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)resId));
    }

    public void setLoadingImageColor(int color) {
        this.mLoadingColor = color;
        this.mLoadingDrawable = new ColorDrawable(color);
    }

    public void setLoadingImageColor(String colorString) {
        this.setLoadingImageColor(Color.parseColor((String)colorString));
    }

    @Override
    public void onLoading(ImageTask imageTask, CubeImageView imageView) {
        if (imageView == null) {
            return;
        }
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)MSG_LOADING, (Object[])new Object[]{imageTask, imageView});
        }
        if (Version.hasHoneycomb()) {
            if (this.mLoadingDrawable != null && imageView != null && imageView.getDrawable() != this.mLoadingDrawable) {
                imageView.setImageDrawable(this.mLoadingDrawable);
            }
        } else {
            imageView.setImageDrawable(null);
        }
    }

    @Override
    public void onLoadError(ImageTask imageTask, CubeImageView imageView, int errorCode) {
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)MSG_LOAD_ERROR, (Object[])new Object[]{imageTask, imageView});
        }
        if (imageView != null) {
            if (Version.hasHoneycomb()) {
                if (this.mErrorDrawable != null && imageView != null && imageView.getDrawable() != this.mErrorDrawable) {
                    imageView.setImageDrawable(this.mErrorDrawable);
                }
            } else {
                imageView.setImageDrawable(null);
            }
            imageView.setImageDrawable(this.mErrorDrawable);
        }
    }

    @Override
    public void onLoadFinish(ImageTask imageTask, CubeImageView imageView, BitmapDrawable drawable) {
        if (imageView == null) {
            return;
        }
        Object d = drawable;
        if (drawable != null) {
            if (this.mResizeImageViewAfterLoad) {
                ViewGroup.LayoutParams lyp;
                int w = drawable.getBitmap().getWidth();
                int h = drawable.getBitmap().getHeight();
                if (w > 0 && h > 0 && (lyp = imageView.getLayoutParams()) != null) {
                    lyp.width = w;
                    lyp.height = h;
                    imageView.setLayoutParams(lyp);
                }
            }
            if ((this.mDisplayTag & 2) == 2 && Version.hasHoneycomb()) {
                d = new RoundedDrawable(drawable.getBitmap(), this.mCornerRadius);
            }
            if ((this.mDisplayTag & 1) == 1) {
                int loadingColor = 17170445;
                if (this.mLoadingColor != -1 && (this.mDisplayTag & 2) != 2) {
                    loadingColor = this.mLoadingColor;
                }
                TransitionDrawable td = new TransitionDrawable(new Drawable[]{new ColorDrawable(loadingColor), d});
                imageView.setImageDrawable((Drawable)td);
                td.startTransition(200);
            } else {
                if (DEBUG) {
                    Drawable oldDrawable = imageView.getDrawable();
                    int w = 0;
                    int h = 0;
                    if (oldDrawable != null) {
                        w = oldDrawable.getIntrinsicWidth();
                        h = oldDrawable.getIntrinsicHeight();
                    }
                    CLog.d((String)LOG_TAG, (String)MSG_LOAD_FINISH, (Object[])new Object[]{imageTask, imageView, w, h, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight()});
                }
                imageView.setImageDrawable((Drawable)drawable);
            }
        }
    }
}

