/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image.impl;

import in.srain.cube.image.ImageTask;
import in.srain.cube.image.iface.ImageReSizer;

public class DefaultImageReSizer
implements ImageReSizer {
    private static DefaultImageReSizer sInstance;

    public static DefaultImageReSizer getInstance() {
        if (sInstance == null) {
            sInstance = new DefaultImageReSizer();
        }
        return sInstance;
    }

    @Override
    public int getInSampleSize(ImageTask imageTask) {
        int size = DefaultImageReSizer.calculateInSampleSize(imageTask.getBitmapOriginSize().x, imageTask.getBitmapOriginSize().y, imageTask.getRequestSize().x, imageTask.getRequestSize().y);
        return size;
    }

    @Override
    public String getRemoteUrl(ImageTask imageTask) {
        return imageTask.getRemoteUrl();
    }

    public static int calculateInSampleSize(int originWidth, int originHeight, int reqWidth, int reqHeight) {
        int inSampleSize = 1;
        if (reqHeight <= 0 || reqHeight <= 0 || reqHeight == Integer.MAX_VALUE || reqWidth == Integer.MAX_VALUE) {
            return inSampleSize;
        }
        if (originWidth > reqHeight || originHeight > reqWidth) {
            int halfHeight = originWidth / 2;
            int halfWidth = originHeight / 2;
            while (halfHeight / inSampleSize > reqHeight && halfWidth / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }
}

