/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image.impl;

import android.annotation.TargetApi;
import in.srain.cube.concurrent.LinkedBlockingDeque;
import in.srain.cube.image.iface.ImageTaskExecutor;
import in.srain.cube.util.Version;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultImageTaskExecutor
implements ImageTaskExecutor {
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT;
    private static final int KEEP_ALIVE_TIME = 1;
    private static int sNUMBER_OF_CORES;
    private static DefaultImageTaskExecutor sInstance;
    private final ThreadPoolExecutor mThreadPool;
    private final LinkedBlockingStack<Runnable> mTaskWorkQueue = new LinkedBlockingStack();

    public static DefaultImageTaskExecutor getInstance() {
        return sInstance;
    }

    @TargetApi(value=9)
    private DefaultImageTaskExecutor() {
        this.mThreadPool = new ThreadPoolExecutor(sNUMBER_OF_CORES, sNUMBER_OF_CORES, 1L, KEEP_ALIVE_TIME_UNIT, this.mTaskWorkQueue, new DefaultThreadFactory());
        if (Version.hasGingerbread()) {
            this.mThreadPool.allowCoreThreadTimeOut(true);
        }
    }

    @Override
    public void execute(Runnable command) {
        this.mThreadPool.execute(command);
    }

    @Override
    public void setTaskOrder(int order) {
        this.mTaskWorkQueue.setTaskOrder(order);
    }

    static {
        sNUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();
        sInstance = null;
        KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
        sInstance = new DefaultImageTaskExecutor();
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private static final String sPre = "image-executor-pool-";
        private static final String sPost = "-thread-";

        DefaultThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = sPre + poolNumber.getAndIncrement() + sPost;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    public static class LinkedBlockingStack<T>
    extends LinkedBlockingDeque<T> {
        private static final long serialVersionUID = -4114786347960826192L;
        private int mImageTaskOrder = 1;

        public void setTaskOrder(int order) {
            this.mImageTaskOrder = order;
        }

        @Override
        public boolean offer(T e) {
            if (this.mImageTaskOrder == 1) {
                return super.offerFirst(e);
            }
            return super.offer(e);
        }

        @Override
        public T remove() {
            if (this.mImageTaskOrder == 2) {
                return (T)super.removeFirst();
            }
            return (T)super.remove();
        }
    }
}

