/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image.impl;

import android.os.Build;
import in.srain.cube.image.ImageTask;
import in.srain.cube.image.iface.ImageDownloader;
import in.srain.cube.image.iface.ProgressUpdateHandler;
import in.srain.cube.util.CLog;
import in.srain.cube.util.CubeDebug;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class SimpleDownloader
implements ImageDownloader {
    protected static final String LOG_TAG = CubeDebug.DEBUG_IMAGE_LOG_TAG_PROVIDER;
    private static final int IO_BUFFER_SIZE = 8192;
    private static SimpleDownloader sInstance;

    public static SimpleDownloader getInstance() {
        if (sInstance == null) {
            sInstance = new SimpleDownloader();
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean downloadToStream(ImageTask imageTask, String urlString, OutputStream outputStream, ProgressUpdateHandler progressUpdateHandler) {
        SimpleDownloader.disableConnectionReuseIfNecessary();
        HttpURLConnection urlConnection = null;
        FilterOutputStream out = null;
        BufferedInputStream in = null;
        try {
            int b;
            URL url = new URL(urlString);
            urlConnection = (HttpURLConnection)url.openConnection();
            int len = urlConnection.getContentLength();
            int total = 0;
            in = new BufferedInputStream(urlConnection.getInputStream(), 8192);
            out = new BufferedOutputStream(outputStream, 8192);
            while ((b = in.read()) != -1) {
                ++total;
                ((BufferedOutputStream)out).write(b);
                if (progressUpdateHandler == null) continue;
                progressUpdateHandler.onProgressUpdate(total, len);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            CLog.e((String)LOG_TAG, (String)("Error in downloadBitmap - " + e));
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
        return false;
    }

    public static void disableConnectionReuseIfNecessary() {
        if (Build.VERSION.SDK_INT < 8) {
            System.setProperty("http.keepAlive", "false");
        }
    }
}

