/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.mints.base;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import in.srain.cube.R;
import in.srain.cube.mints.base.MenuItemFragment;
import in.srain.cube.util.LocalDisplay;
import in.srain.cube.views.block.BlockListAdapter;
import in.srain.cube.views.block.BlockListView;

public abstract class BlockMenuFragment
extends MenuItemFragment {
    private BlockListView mBlockListView;
    private int mSize = 0;
    private BlockListAdapter<MenuItemFragment.MenuItemInfo> mBlockListAdapter = new BlockListAdapter<MenuItemFragment.MenuItemInfo>(){

        @Override
        public View getView(LayoutInflater layoutInflater, int position) {
            return BlockMenuFragment.this.getViewForBlock(layoutInflater, position);
        }
    };

    @Override
    protected int getLayoutId() {
        return R.layout.cube_mints_base_fragment_block_menu;
    }

    @Override
    protected void setupViews(View view) {
        this.mBlockListView = (BlockListView)view.findViewById(R.id.fragment_block_menu_block_list);
        this.setupList();
    }

    protected View getViewForBlock(LayoutInflater layoutInflater, int position) {
        MenuItemFragment.MenuItemInfo itemInfo = this.mBlockListAdapter.getItem(position);
        ViewGroup view = (ViewGroup)layoutInflater.inflate(R.layout.cube_mints_base_block_menu_item, null);
        if (itemInfo != null) {
            TextView textView = (TextView)view.findViewById(R.id.cube_mints_base_block_menu_item_title);
            textView.setText((CharSequence)itemInfo.getTitle());
            view.setBackgroundColor(itemInfo.getColor());
        }
        return view;
    }

    protected void setupList() {
        this.mSize = (LocalDisplay.SCREEN_WIDTH_PIXELS - LocalDisplay.dp2px(35.0f)) / 3;
        int horizontalSpacing = LocalDisplay.dp2px(5.0f);
        int verticalSpacing = LocalDisplay.dp2px(10.5f);
        this.mBlockListView.setOnItemClickListener(new BlockListView.OnItemClickListener(){

            @Override
            public void onItemClick(View v, int position) {
                MenuItemFragment.MenuItemInfo itemInfo = (MenuItemFragment.MenuItemInfo)BlockMenuFragment.this.mBlockListAdapter.getItem(position);
                if (itemInfo != null) {
                    itemInfo.onClick(v);
                }
            }
        });
        this.mBlockListAdapter.setSpace(horizontalSpacing, verticalSpacing);
        this.mBlockListAdapter.setBlockSize(this.mSize, this.mSize);
        this.mBlockListAdapter.setColumnNum(3);
        this.mBlockListView.setAdapter(this.mBlockListAdapter);
        this.mBlockListAdapter.displayBlocks(this.mItemInfos);
    }

    @Override
    protected boolean enableDefaultBack() {
        return false;
    }
}

